/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gui.item;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.ToggleButton;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.gui.item.IItemFilterGui;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.item.filter.PowerItemFilter;
import crazypants.enderio.conduit.packet.PacketItemConduitFilter;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.network.PacketHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;

public class PowerItemFilterGui
implements IItemFilterGui {
    private static final int ID_STICKY = GuiExternalConnection.nextButtonId();
    private static final int ID_MORE = GuiExternalConnection.nextButtonId();
    private static final int ID_LEVEL = GuiExternalConnection.nextButtonId();
    private final IItemConduit itemConduit;
    private final GuiExternalConnection gui;
    private final ToggleButton stickyB;
    private final GuiButton modeB;
    private final GuiButton levelB;
    private final boolean isInput;
    private final PowerItemFilter filter;

    public PowerItemFilterGui(GuiExternalConnection gui, IItemConduit itemConduit, boolean isInput) {
        int butLeft;
        this.gui = gui;
        this.itemConduit = itemConduit;
        this.isInput = isInput;
        this.filter = isInput ? (PowerItemFilter)itemConduit.getInputFilter(gui.getDir()) : (PowerItemFilter)itemConduit.getOutputFilter(gui.getDir());
        int x = butLeft = isInput ? 106 : 5;
        int y = 120;
        this.stickyB = new ToggleButton((IGuiScreen)gui, ID_STICKY, x, y, (IWidgetIcon)IconEIO.FILTER_STICKY_OFF, (IWidgetIcon)IconEIO.FILTER_STICKY);
        String[] lines = EnderIO.lang.localizeList("gui.conduit.item.stickyEnabled");
        this.stickyB.setSelectedToolTip(lines);
        this.stickyB.setUnselectedToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.stickyDisbaled")});
        this.stickyB.setPaintSelectedBorder(false);
        this.modeB = new GuiButton(ID_MORE, 0, 0, 40, 20, "");
        this.levelB = new GuiButton(ID_LEVEL, 0, 0, 40, 20, "");
    }

    @Override
    public void mouseClicked(int x, int y, int par3) {
        x += this.gui.getGuiLeft();
        y += this.gui.getGuiTop();
        if (par3 == 1) {
            Minecraft mc = Minecraft.func_71410_x();
            if (this.modeB.func_146116_c(mc, x, y)) {
                this.modeB.func_146113_a(mc.func_147118_V());
                this.filter.setMode(this.filter.getMode().prev());
                this.sendFilterChange();
            } else if (this.levelB.func_146116_c(mc, x, y)) {
                this.levelB.func_146113_a(mc.func_147118_V());
                this.filter.setLevel((this.filter.getLevel() + 4) % 5);
                this.sendFilterChange();
            }
        }
    }

    @Override
    public void updateButtons() {
        if (!this.isInput) {
            this.stickyB.onGuiInit();
            this.stickyB.setSelected(this.filter.isSticky());
        }
        int x0 = this.gui.getGuiLeft() + (this.isInput ? 106 : 5);
        int y0 = this.gui.getGuiTop() + 96;
        int x1 = x0 + 45;
        this.modeB.field_146128_h = x0;
        this.modeB.field_146129_i = y0;
        this.levelB.field_146128_h = x1;
        this.levelB.field_146129_i = y0;
        switch (this.filter.getMode()) {
            case LESS: {
                this.modeB.field_146126_j = "<";
                break;
            }
            case LESS_EQUAL: {
                this.modeB.field_146126_j = "<=";
                break;
            }
            case EQUAL: {
                this.modeB.field_146126_j = "=";
                break;
            }
            case MORE_EQUAL: {
                this.modeB.field_146126_j = ">=";
                break;
            }
            case MORE: {
                this.modeB.field_146126_j = ">";
                break;
            }
            default: {
                this.modeB.field_146126_j = "??";
            }
        }
        this.levelB.field_146126_j = String.format("%d%%", this.filter.getLevel() * 100 / 4);
        this.gui.addButton(this.modeB);
        this.gui.addButton(this.levelB);
    }

    @Override
    public void actionPerformed(GuiButton guiButton) {
        if (guiButton == this.stickyB) {
            this.filter.setSticky(this.stickyB.isSelected());
            this.sendFilterChange();
        } else if (guiButton == this.modeB) {
            this.filter.setMode(this.filter.getMode().next());
            this.sendFilterChange();
        } else if (guiButton == this.levelB) {
            this.filter.setLevel((this.filter.getLevel() + 1) % 5);
            this.sendFilterChange();
        }
    }

    private void sendFilterChange() {
        this.updateButtons();
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketItemConduitFilter(this.itemConduit, this.gui.getDir()));
    }

    @Override
    public void deactivate() {
        this.stickyB.detach();
        this.gui.removeButton(this.modeB);
        this.gui.removeButton(this.levelB);
    }

    @Override
    public void renderCustomOptions(int top, float par1, int par2, int par3) {
    }
}

