/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_HatchElementBuilder;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.IGT_HatchAdder;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Steam_BusInput;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Steam_BusOutput;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GT_MetaTileEntity_Hatch_CustomFluidBase;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public abstract class GregtechMeta_SteamMultiBase<T extends GregtechMeta_SteamMultiBase<T>>
extends GregtechMeta_MultiBlockBase<T> {
    public ArrayList<GT_MetaTileEntity_Hatch_Steam_BusInput> mSteamInputs = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_Steam_BusOutput> mSteamOutputs = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_CustomFluidBase> mSteamInputFluids = new ArrayList();
    protected static final String TT_steaminputbus = StatCollector.func_74838_a((String)"GTPP.MBTT.SteamInputBus");
    protected static final String TT_steamoutputbus = StatCollector.func_74838_a((String)"GTPP.MBTT.SteamOutputBus");
    protected static final String TT_steamhatch = StatCollector.func_74838_a((String)"GTPP.MBTT.SteamHatch");

    public GregtechMeta_SteamMultiBase(String aName) {
        super(aName);
    }

    public GregtechMeta_SteamMultiBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)this.getCasingTextureIndex()), aActive ? this.getFrontOverlayActive() : this.getFrontOverlay()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)this.getCasingTextureIndex())};
    }

    protected abstract GT_RenderedTexture getFrontOverlay();

    protected abstract GT_RenderedTexture getFrontOverlayActive();

    private int getCasingTextureIndex() {
        return 10;
    }

    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic().setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(GT_Values.V[1]);
        logic.setAvailableAmperage((long)this.getMaxParallelRecipes());
        logic.setAmperageOC(false);
    }

    public ArrayList<FluidStack> getAllSteamStacks() {
        ArrayList<FluidStack> aFluids = new ArrayList<FluidStack>();
        FluidStack aSteam = FluidUtils.getSteam(1);
        for (FluidStack aFluid : this.getStoredFluids()) {
            if (!aFluid.isFluidEqual(aSteam)) continue;
            aFluids.add(aFluid);
        }
        return aFluids;
    }

    public int getTotalSteamStored() {
        int aSteam = 0;
        for (FluidStack aFluid : this.getAllSteamStacks()) {
            aSteam += aFluid.amount;
        }
        return aSteam;
    }

    public boolean tryConsumeSteam(int aAmount) {
        if (this.getTotalSteamStored() <= 0) {
            return false;
        }
        return this.depleteInput(FluidUtils.getSteam(aAmount));
    }

    public int getMaxEfficiency(ItemStack arg0) {
        return 0;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && (this.mUpdate == 1 || this.mStartUpCheck == 1)) {
            this.mSteamInputs.clear();
            this.mSteamOutputs.clear();
            this.mSteamInputFluids.clear();
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    public boolean onRunningTick(ItemStack aStack) {
        long aSteamVal;
        this.fixAllMaintenanceIssue();
        if (this.lEUt < 0L && !this.tryConsumeSteam((int)(aSteamVal = -this.lEUt * 10000L / (long)Math.max(1000, this.mEfficiency)))) {
            this.stopMachine();
            return false;
        }
        return true;
    }

    @Override
    public boolean addToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            this.log("Invalid IGregTechTileEntity");
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            this.log("Invalid IMetaTileEntity");
            return false;
        }
        boolean aDidAdd = false;
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_CustomFluidBase) {
            this.log("Adding Steam Input Hatch");
            aDidAdd = this.addToMachineListInternal(this.mSteamInputFluids, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Steam_BusInput) {
            this.log("Trying to set recipe map. Type: " + (this.getRecipeMap() != null ? this.getRecipeMap().mNEIName : "Null"));
            this.resetRecipeMapForHatch(aTileEntity, this.getRecipeMap());
            this.log("Adding Steam Input Bus");
            aDidAdd = this.addToMachineListInternal(this.mSteamInputs, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Steam_BusOutput) {
            this.log("Adding Steam Output Bus");
            aDidAdd = this.addToMachineListInternal(this.mSteamOutputs, aMetaTileEntity, aBaseCasingIndex);
        }
        return aDidAdd;
    }

    public void stopMachine() {
        super.stopMachine();
    }

    public boolean depleteInput(FluidStack aLiquid) {
        if (aLiquid == null) {
            return false;
        }
        for (GT_MetaTileEntity_Hatch_CustomFluidBase tHatch : this.mSteamInputFluids) {
            FluidStack tLiquid;
            if (!GregtechMeta_SteamMultiBase.isValidMetaTileEntity((MetaTileEntity)tHatch) || (tLiquid = tHatch.getFluid()) == null || !tLiquid.isFluidEqual(aLiquid) || (tLiquid = tHatch.drain(aLiquid.amount, false)) == null || tLiquid.amount < aLiquid.amount) continue;
            tLiquid = tHatch.drain(aLiquid.amount, true);
            return tLiquid != null && tLiquid.amount >= aLiquid.amount;
        }
        return false;
    }

    public boolean depleteInput(ItemStack aStack) {
        if (GT_Utility.isStackInvalid((Object)aStack)) {
            return false;
        }
        FluidStack aLiquid = GT_Utility.getFluidForFilledItem((ItemStack)aStack, (boolean)true);
        if (aLiquid != null) {
            return this.depleteInput(aLiquid);
        }
        for (GT_MetaTileEntity_Hatch_CustomFluidBase gT_MetaTileEntity_Hatch_CustomFluidBase : this.mSteamInputFluids) {
            if (!GregtechMeta_SteamMultiBase.isValidMetaTileEntity((MetaTileEntity)gT_MetaTileEntity_Hatch_CustomFluidBase) || !GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)gT_MetaTileEntity_Hatch_CustomFluidBase.getBaseMetaTileEntity().func_70301_a(0)) || gT_MetaTileEntity_Hatch_CustomFluidBase.getBaseMetaTileEntity().func_70301_a((int)0).field_77994_a < aStack.field_77994_a) continue;
            gT_MetaTileEntity_Hatch_CustomFluidBase.getBaseMetaTileEntity().func_70298_a(0, aStack.field_77994_a);
            return true;
        }
        for (GT_MetaTileEntity_Hatch_Steam_BusInput gT_MetaTileEntity_Hatch_Steam_BusInput : this.mSteamInputs) {
            gT_MetaTileEntity_Hatch_Steam_BusInput.mRecipeMap = this.getRecipeMap();
            if (!GregtechMeta_SteamMultiBase.isValidMetaTileEntity((MetaTileEntity)gT_MetaTileEntity_Hatch_Steam_BusInput)) continue;
            for (int i = gT_MetaTileEntity_Hatch_Steam_BusInput.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                if (!GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)gT_MetaTileEntity_Hatch_Steam_BusInput.getBaseMetaTileEntity().func_70301_a(i)) || gT_MetaTileEntity_Hatch_Steam_BusInput.getBaseMetaTileEntity().func_70301_a((int)0).field_77994_a < aStack.field_77994_a) continue;
                gT_MetaTileEntity_Hatch_Steam_BusInput.getBaseMetaTileEntity().func_70298_a(0, aStack.field_77994_a);
                return true;
            }
        }
        return false;
    }

    public ArrayList<FluidStack> getStoredFluids() {
        ArrayList<FluidStack> rList = new ArrayList<FluidStack>();
        for (GT_MetaTileEntity_Hatch_CustomFluidBase tHatch : this.mSteamInputFluids) {
            if (!GregtechMeta_SteamMultiBase.isValidMetaTileEntity((MetaTileEntity)tHatch) || tHatch.getFillableStack() == null) continue;
            rList.add(tHatch.getFillableStack());
        }
        return rList;
    }

    public ArrayList<ItemStack> getStoredInputs() {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        for (GT_MetaTileEntity_Hatch_Steam_BusInput tHatch : this.mSteamInputs) {
            tHatch.mRecipeMap = this.getRecipeMap();
            if (!GregtechMeta_SteamMultiBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            for (int i = tHatch.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                if (tHatch.getBaseMetaTileEntity().func_70301_a(i) == null) continue;
                rList.add(tHatch.getBaseMetaTileEntity().func_70301_a(i));
            }
        }
        return rList;
    }

    public boolean addOutput(ItemStack aStack) {
        if (GT_Utility.isStackInvalid((Object)aStack)) {
            return false;
        }
        aStack = GT_Utility.copy((Object[])new Object[]{aStack});
        boolean outputSuccess = true;
        while (outputSuccess && aStack.field_77994_a > 0) {
            outputSuccess = false;
            ItemStack single = aStack.func_77979_a(1);
            for (GT_MetaTileEntity_Hatch_Steam_BusOutput tHatch : this.mSteamOutputs) {
                if (outputSuccess || !GregtechMeta_SteamMultiBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
                for (int i = tHatch.func_70302_i_() - 1; i >= 0 && !outputSuccess; --i) {
                    if (!tHatch.getBaseMetaTileEntity().addStackToSlot(i, single)) continue;
                    outputSuccess = true;
                }
            }
            for (GT_MetaTileEntity_Hatch_Steam_BusOutput tHatch : this.mOutputHatches) {
                if (outputSuccess || !GregtechMeta_SteamMultiBase.isValidMetaTileEntity((MetaTileEntity)tHatch) || !tHatch.outputsItems() || !tHatch.getBaseMetaTileEntity().addStackToSlot(1, single)) continue;
                outputSuccess = true;
            }
        }
        return outputSuccess;
    }

    public ArrayList<ItemStack> getStoredOutputs() {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        for (GT_MetaTileEntity_Hatch_Steam_BusOutput tHatch : this.mSteamOutputs) {
            if (!GregtechMeta_SteamMultiBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            for (int i = tHatch.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                rList.add(tHatch.getBaseMetaTileEntity().func_70301_a(i));
            }
        }
        return rList;
    }

    public List<ItemStack> getItemOutputSlots(ItemStack[] toOutput) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (GT_MetaTileEntity_Hatch tBus : GregtechMeta_SteamMultiBase.filterValidMetaTileEntities(this.mSteamOutputs)) {
            IGregTechTileEntity tBusInv = tBus.getBaseMetaTileEntity();
            for (int i = 0; i < tBusInv.func_70302_i_(); ++i) {
                ret.add(tBus.func_70301_a(i));
            }
        }
        return ret;
    }

    @Override
    public void updateSlots() {
        for (GT_MetaTileEntity_Hatch_CustomFluidBase gT_MetaTileEntity_Hatch_CustomFluidBase : this.mSteamInputFluids) {
            if (!GregtechMeta_SteamMultiBase.isValidMetaTileEntity((MetaTileEntity)gT_MetaTileEntity_Hatch_CustomFluidBase)) continue;
            gT_MetaTileEntity_Hatch_CustomFluidBase.updateSlots();
        }
        for (GT_MetaTileEntity_Hatch_Steam_BusInput gT_MetaTileEntity_Hatch_Steam_BusInput : this.mSteamInputs) {
            if (!GregtechMeta_SteamMultiBase.isValidMetaTileEntity((MetaTileEntity)gT_MetaTileEntity_Hatch_Steam_BusInput)) continue;
            gT_MetaTileEntity_Hatch_Steam_BusInput.updateSlots();
        }
    }

    protected static <T extends GregtechMeta_SteamMultiBase<T>> GT_HatchElementBuilder<T> buildSteamInput(Class<T> typeToken) {
        return GT_StructureUtility.buildHatchAdder(typeToken).adder(GregtechMeta_SteamMultiBase::addToMachineList).hatchIds(new int[]{31040}).shouldReject(t -> !t.mSteamInputFluids.isEmpty());
    }

    protected static enum SteamHatchElement implements IHatchElement<GregtechMeta_SteamMultiBase<?>>
    {
        InputBus_Steam{

            public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
                return Collections.singletonList(GT_MetaTileEntity_Hatch_Steam_BusInput.class);
            }

            public long count(GregtechMeta_SteamMultiBase<?> t) {
                return t.mSteamInputs.size();
            }
        }
        ,
        OutputBus_Steam{

            public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
                return Collections.singletonList(GT_MetaTileEntity_Hatch_Steam_BusOutput.class);
            }

            public long count(GregtechMeta_SteamMultiBase<?> t) {
                return t.mSteamOutputs.size();
            }
        };


        public IGT_HatchAdder<? super GregtechMeta_SteamMultiBase<?>> adder() {
            return GregtechMeta_SteamMultiBase::addToMachineList;
        }
    }
}

