/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity;

import chylex.hee.system.collections.WeightedList;
import chylex.hee.system.collections.weight.IWeightProvider;
import chylex.hee.system.commands.HeeDebugCommand;
import chylex.hee.system.logging.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.StatCollector;

public class RandomNameGenerator {
    private static final WeightedList<Char> vowels = new WeightedList((IWeightProvider[])new Char[]{new Char('a', 10), new Char('e', 10), new Char('i', 8), new Char('o', 7), new Char('u', 6), new Char('y', 3)});
    private static final WeightedList<Char> consonants = new WeightedList((IWeightProvider[])new Char[]{new Char('b', 6), new Char('c', 5), new Char('d', 6), new Char('f', 4), new Char('g', 2), new Char('h', 4), new Char('j', 4), new Char('k', 7), new Char('l', 7), new Char('m', 7), new Char('n', 7), new Char('p', 7), new Char('q', 1), new Char('r', 6), new Char('s', 7), new Char('t', 7), new Char('v', 6), new Char('w', 1), new Char('x', 1), new Char('z', 3)});
    private static final Map<Character, char[]> matches = new HashMap<Character, char[]>();
    public static final HeeDebugCommand.HeeTest $debugTest;

    public static void generateEntityName(EntityLiving entity, int length) {
        if (!entity.func_94056_bM()) {
            entity.func_94058_c(RandomNameGenerator.generate(entity.func_70681_au(), length) + StatCollector.func_74838_a((String)"namegenerator.middle") + entity.func_70005_c_());
        }
    }

    public static String generate(Random rand, int length) {
        StringBuilder build = new StringBuilder();
        boolean useVowel = rand.nextInt(3) == 0;
        for (int a = 0; a < length; ++a) {
            char c;
            if (useVowel) {
                c = RandomNameGenerator.vowels.getRandomItem((Random)rand).character;
                build.append(a == 0 ? Character.toUpperCase(c) : c);
                useVowel = !useVowel;
                continue;
            }
            c = RandomNameGenerator.consonants.getRandomItem((Random)rand).character;
            build.append(a == 0 ? Character.toUpperCase(c) : c);
            if (rand.nextInt(3) == 0 && a + 1 < length && matches.containsKey(Character.valueOf(c))) {
                char[] matchArray = matches.get(Character.valueOf(c));
                build.append(matchArray[rand.nextInt(matchArray.length)]);
                ++a;
            }
            useVowel = !useVowel;
        }
        return build.toString();
    }

    static {
        matches.put(Character.valueOf('b'), new char[]{'l', 'r'});
        matches.put(Character.valueOf('c'), new char[]{'h', 'l', 'r', 'z'});
        matches.put(Character.valueOf('d'), new char[]{'l', 'r'});
        matches.put(Character.valueOf('f'), new char[]{'l', 'r'});
        matches.put(Character.valueOf('g'), new char[]{'n', 'p', 'r'});
        matches.put(Character.valueOf('k'), new char[]{'l', 'r'});
        matches.put(Character.valueOf('l'), new char[]{'b', 't'});
        matches.put(Character.valueOf('n'), new char[]{'c', 'g'});
        matches.put(Character.valueOf('p'), new char[]{'h', 'l', 'r'});
        matches.put(Character.valueOf('r'), new char[]{'c', 'k', 'm', 'n', 's'});
        matches.put(Character.valueOf('s'), new char[]{'c', 'h', 'k', 'l', 'n', 'q', 't'});
        matches.put(Character.valueOf('t'), new char[]{'h', 'l', 'r', 'w'});
        matches.put(Character.valueOf('z'), new char[]{'d'});
        $debugTest = new HeeDebugCommand.HeeTest(){

            @Override
            public void run(String ... args) {
                for (int a = 0; a < 50; ++a) {
                    Log.debug("> " + RandomNameGenerator.generate(this.world.field_73012_v, 4 + this.world.field_73012_v.nextInt(8)), new Object[0]);
                }
            }
        };
    }

    static class Char
    implements IWeightProvider {
        final char character;
        private byte weight;

        Char(char character, int weight) {
            this.character = character;
            this.weight = (byte)weight;
        }

        @Override
        public int getWeight() {
            return this.weight;
        }
    }
}

