/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.boss.dragon.managers;

import chylex.hee.entity.boss.EntityBossDragon;
import chylex.hee.entity.boss.dragon.attacks.passive.DragonPassiveAttackBase;
import chylex.hee.entity.boss.dragon.attacks.special.DragonSpecialAttackBase;
import chylex.hee.proxy.ModCommonProxy;
import chylex.hee.system.collections.WeightedList;
import chylex.hee.system.collections.weight.IWeightProvider;
import chylex.hee.system.collections.weight.ObjectWeightPair;
import chylex.hee.system.util.MathUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import org.apache.commons.lang3.ArrayUtils;

public class DragonAttackManager {
    private final List<DragonPassiveAttackBase> passiveAttackList = new ArrayList<DragonPassiveAttackBase>();
    private final List<DragonSpecialAttackBase> specialAttackList = new ArrayList<DragonSpecialAttackBase>();
    private final WeightedList<DragonSpecialAttackBase> specialAttackWeights = new WeightedList((IWeightProvider[])new DragonSpecialAttackBase[0]);
    private final Queue<Byte> specialAttackQueue = new LinkedList<Byte>();
    protected EntityBossDragon dragon;

    public DragonAttackManager(EntityBossDragon dragon) {
        this.dragon = dragon;
    }

    public void registerPassive(DragonPassiveAttackBase attack) {
        if (this.getPassiveAttackById(attack.id) != null) {
            throw new IllegalArgumentException("Tried to register passive dragon attack with already registered attack ID " + attack.id);
        }
        this.passiveAttackList.add(attack);
    }

    public void registerSpecial(DragonSpecialAttackBase attack) {
        if (this.getSpecialAttackById(attack.id) != null) {
            throw new IllegalArgumentException("Tried to register special dragon attack with already registered attack ID " + attack.id);
        }
        this.specialAttackList.add(attack);
        if (attack.getWeight() != -1) {
            this.specialAttackWeights.add(attack);
        }
    }

    public DragonPassiveAttackBase getPassiveAttackById(int id) {
        for (DragonPassiveAttackBase attack : this.passiveAttackList) {
            if (attack.id != id) continue;
            return attack;
        }
        return null;
    }

    public DragonSpecialAttackBase getSpecialAttackById(int id) {
        for (DragonSpecialAttackBase attack : this.specialAttackList) {
            if (attack.id != id) continue;
            return attack;
        }
        return null;
    }

    public List<DragonSpecialAttackBase> getSpecialAttackList() {
        return Collections.unmodifiableList(this.specialAttackList);
    }

    public boolean isPlayerViable(EntityPlayer player) {
        return MathUtil.distance(player.field_70165_t, player.field_70161_v) <= 160.0;
    }

    public List<EntityPlayer> getViablePlayers() {
        List players = this.dragon.field_70170_p.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)-160.0, (double)-32.0, (double)-160.0, (double)160.0, (double)512.0, (double)160.0));
        if (players.size() > 1) {
            Iterator iter = players.iterator();
            while (iter.hasNext()) {
                EntityPlayer player = (EntityPlayer)iter.next();
                if (!player.field_71075_bZ.field_75098_d && !player.field_70128_L) continue;
                iter.remove();
            }
        }
        return players;
    }

    public EntityPlayer getRandomPlayer() {
        List<EntityPlayer> list = this.getViablePlayers();
        return list.isEmpty() ? null : list.get(this.dragon.field_70170_p.field_73012_v.nextInt(list.size()));
    }

    public EntityPlayer getWeakPlayer() {
        List<EntityPlayer> list = this.getViablePlayers();
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        WeightedList players = new WeightedList((IWeightProvider[])new ObjectWeightPair[0]);
        for (EntityPlayer p : list) {
            players.add(ObjectWeightPair.of(p, 5 + ((int)p.func_110143_aJ() >> 1) + (p.func_70658_aO() >> 2)));
        }
        return (EntityPlayer)((ObjectWeightPair)players.getRandomItem(this.dragon.field_70170_p.field_73012_v)).getObject();
    }

    public void updatePassiveAttacks(DragonSpecialAttackBase currentSpecialAttack) {
        for (DragonPassiveAttackBase attack : this.passiveAttackList) {
            if (currentSpecialAttack != null && currentSpecialAttack.isPassiveAttackDisabled(attack.id)) continue;
            attack.update();
        }
    }

    public DragonSpecialAttackBase pickSpecialAttack(DragonSpecialAttackBase lastAttack) {
        int healthPercentage = this.getHealthPercentage();
        if (healthPercentage == 0) {
            return null;
        }
        if (this.specialAttackQueue.isEmpty()) {
            WeightedList<DragonSpecialAttackBase> list = new WeightedList<DragonSpecialAttackBase>(this.specialAttackWeights);
            int amt = list.size() - 2;
            for (int a = 0; a < amt; ++a) {
                DragonSpecialAttackBase attack = list.getRandomItem(this.dragon.field_70170_p.field_73012_v);
                list.remove(attack);
                this.specialAttackQueue.add(attack.id);
            }
        }
        return this.getSpecialAttackById(this.specialAttackQueue.poll().byteValue());
    }

    public boolean biteClosePlayers() {
        boolean res = false;
        for (EntityPlayer player : this.dragon.field_70170_p.func_72872_a(EntityPlayer.class, this.dragon.dragonPartHead.field_70121_D.func_72314_b(2.2, 1.5, 2.2))) {
            int rm;
            int diff = this.dragon.field_70170_p.field_73013_u.func_151525_a();
            player.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.dragon), (ModCommonProxy.opMobs ? 14.0f : 9.0f) + (float)diff);
            switch (diff) {
                case 3: {
                    rm = 31;
                    break;
                }
                case 2: {
                    rm = 20;
                    break;
                }
                case 1: {
                    rm = 14;
                    break;
                }
                default: {
                    rm = 9;
                }
            }
            if (this.dragon.field_70170_p.field_73012_v.nextInt(100) < rm) {
                player.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 90 + 30 * diff, ModCommonProxy.opMobs ? 1 : 0));
                this.dragon.rewards.addHandicap(0.1f, false);
                if (this.dragon.field_70170_p.field_73012_v.nextInt(100) < 35 + diff * 12) {
                    player.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 160 + 24 * diff, 0));
                    player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 80 + 24 * diff, 0));
                }
            }
            res = true;
        }
        return res;
    }

    public int getHealthPercentage() {
        return (int)(100.0f / this.dragon.func_110138_aP() * this.dragon.func_110143_aJ());
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74773_a("attq", ArrayUtils.toPrimitive((Byte[])this.specialAttackQueue.toArray(new Byte[this.specialAttackQueue.size()])));
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        for (byte b : tag.func_74770_j("attq")) {
            this.specialAttackQueue.add(b);
        }
    }
}

