/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.compendium.objects;

import chylex.hee.mechanics.compendium.objects.IKnowledgeObjectInstance;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class ObjectBlock
implements IKnowledgeObjectInstance<BlockMetaWrapper> {
    private final BlockMetaWrapper wrapper;

    public ObjectBlock(Block block) {
        this.wrapper = new BlockMetaWrapper(block, -1);
    }

    public ObjectBlock(Block block, int metadata) {
        this.wrapper = new BlockMetaWrapper(block, metadata);
    }

    @Override
    public BlockMetaWrapper getUnderlyingObject() {
        return this.wrapper;
    }

    @Override
    public ItemStack createItemStackToRender() {
        return new ItemStack(this.wrapper.block, 1, this.wrapper.metadata == -1 ? 0 : (int)this.wrapper.metadata);
    }

    @Override
    public boolean checkEquality(Object o) {
        if (o.getClass() != BlockMetaWrapper.class) {
            return false;
        }
        BlockMetaWrapper bmw = (BlockMetaWrapper)o;
        return bmw.block == this.wrapper.block && (bmw.metadata == -1 || this.wrapper.metadata == -1 || bmw.metadata == this.wrapper.metadata);
    }

    public static class BlockMetaWrapper {
        public Block block;
        public byte metadata;

        public BlockMetaWrapper(Block block, int metadata) {
            this.block = block;
            this.metadata = (byte)metadata;
        }

        public boolean equals(Object o) {
            return o != null && o.getClass() == BlockMetaWrapper.class && ((BlockMetaWrapper)o).block == this.block;
        }

        public int hashCode() {
            return this.block.hashCode();
        }

        public String toString() {
            return this.block + "/" + this.metadata;
        }
    }
}

