/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.generators.gregtech5.circuits;

import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.DisplayComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.circuits.AutoValue_CircuitRecipe;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.circuits.AutoValue_CircuitRecipe_Recipe;
import com.github.dcysteine.neicustomdiagram.main.Logger;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechOreDictUtil;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechRecipeUtil;
import com.google.auto.value.AutoValue;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import gregtech.api.util.GT_Recipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.item.ItemStack;

@AutoValue
abstract class CircuitRecipe {
    static final int MAX_ITEM_INPUTS = 6;

    CircuitRecipe() {
    }

    static CircuitRecipe create(int itemInputsSize, Collection<Recipe> recipes) {
        ArrayList itemInputsBuilderList = new ArrayList();
        IntStream.range(0, itemInputsSize).forEach(i -> itemInputsBuilderList.add(ImmutableSortedSet.naturalOrder()));
        Recipe firstRecipe = (Recipe)Iterables.getFirst(recipes, null);
        boolean requiresCleanroom = firstRecipe.requiresCleanroom();
        boolean requiresLowGravity = firstRecipe.requiresLowGravity();
        DisplayComponent output = firstRecipe.output();
        ImmutableSortedSet.Builder fluidInputsBuilder = ImmutableSortedSet.naturalOrder();
        for (Recipe recipe : recipes) {
            if (recipe.itemInputsSize() != itemInputsSize) {
                Logger.GREGTECH_5_CIRCUITS.warn("Expected recipe to have {} item inputs: [{}]", new Object[]{itemInputsSize, recipe});
                continue;
            }
            if (!output.equals(recipe.output())) {
                Logger.GREGTECH_5_CIRCUITS.warn("Expected recipe to have output [{}]: [{}]", new Object[]{output, recipe});
                continue;
            }
            if (requiresCleanroom != recipe.requiresCleanroom()) {
                Logger.GREGTECH_5_CIRCUITS.warn("Expected recipe to have cleanroom requirement [{}]: [{}]", new Object[]{requiresCleanroom, recipe});
                continue;
            }
            if (requiresLowGravity != recipe.requiresLowGravity()) {
                Logger.GREGTECH_5_CIRCUITS.warn("Expected recipe to have low gravity requirement [{}]: [{}]", new Object[]{requiresLowGravity, recipe});
                continue;
            }
            for (int i2 = 0; i2 < itemInputsSize; ++i2) {
                ((ImmutableSortedSet.Builder)itemInputsBuilderList.get(i2)).addAll((Iterable)recipe.itemInputs().get(i2));
            }
            fluidInputsBuilder.add((Object)recipe.fluidInput());
        }
        ImmutableList itemInputs = ImmutableList.copyOf((Collection)itemInputsBuilderList.stream().map(ImmutableSortedSet.Builder::build).collect(Collectors.toList()));
        ImmutableSortedSet fluidInputs = fluidInputsBuilder.build();
        boolean missingCombinations = false;
        long expectedNumberOfRecipes = fluidInputs.size();
        try {
            expectedNumberOfRecipes *= itemInputs.stream().mapToLong(Set::size).reduce(1L, Math::multiplyExact);
            expectedNumberOfRecipes /= recipes.stream().mapToLong(rec$ -> ((Recipe)rec$).itemInputsPermutationMultiplier()).reduce(1L, Math::multiplyExact);
        }
        catch (ArithmeticException e) {
            Logger.GREGTECH_5_CIRCUITS.error("Arithmetic exception when calculating number of recipes for circuit: [{}] [{}]", new Object[]{output.toPrettyString(), e});
            expectedNumberOfRecipes = recipes.size();
        }
        if (expectedNumberOfRecipes != (long)recipes.size()) {
            Logger.GREGTECH_5_CIRCUITS.warn("Expected {} recipes but got {} for circuit: [{}]", new Object[]{expectedNumberOfRecipes, recipes.size(), output});
            missingCombinations = expectedNumberOfRecipes > (long)recipes.size();
        }
        return new AutoValue_CircuitRecipe(missingCombinations, requiresCleanroom, requiresLowGravity, (ImmutableList<ImmutableSortedSet<DisplayComponent>>)itemInputs, (ImmutableSortedSet<DisplayComponent>)fluidInputs, output);
    }

    static List<CircuitRecipe> buildCircuitRecipes(Iterable<GT_Recipe> rawRecipes) {
        HashBasedTable recipeTable = HashBasedTable.create();
        for (GT_Recipe rawRecipe : rawRecipes) {
            Recipe recipe = Recipe.create(rawRecipe);
            int row = recipe.itemInputsSize();
            int column = recipe.outputStackSize();
            HashSet<Recipe> recipeSet = (HashSet<Recipe>)recipeTable.get((Object)row, (Object)column);
            if (recipeSet == null) {
                recipeSet = new HashSet<Recipe>();
                recipeTable.put((Object)row, (Object)column, recipeSet);
            }
            recipeSet.add(recipe);
        }
        return recipeTable.rowMap().entrySet().stream().sorted(Map.Entry.comparingByKey().reversed()).flatMap(entry -> ((Map)entry.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).map(innerEntry -> CircuitRecipe.create((Integer)entry.getKey(), (Collection)innerEntry.getValue()))).collect(Collectors.toList());
    }

    abstract boolean missingCombinations();

    abstract boolean requiresCleanroom();

    abstract boolean requiresLowGravity();

    abstract ImmutableList<ImmutableSortedSet<DisplayComponent>> itemInputs();

    abstract ImmutableSortedSet<DisplayComponent> fluidInputs();

    abstract DisplayComponent output();

    @AutoValue
    static abstract class Recipe {
        Recipe() {
        }

        private static Recipe create(GT_Recipe recipe) {
            ImmutableList.Builder itemInputsBuilder = ImmutableList.builder();
            for (ItemStack itemStack : recipe.mInputs) {
                if (itemStack == null) continue;
                ItemComponent itemComponent = ItemComponent.create(itemStack);
                List<Component> reverseUnifiedItems = GregTechOreDictUtil.reverseUnify(itemComponent);
                itemInputsBuilder.add((Object)ImmutableList.copyOf((Collection)reverseUnifiedItems.stream().map(c -> DisplayComponent.builder(c).setStackSize(itemStack.field_77994_a).build()).collect(Collectors.toList())));
            }
            DisplayComponent fluidInput = (DisplayComponent)Iterables.getOnlyElement(GregTechRecipeUtil.buildComponentsFromFluidInputs(recipe));
            DisplayComponent output = (DisplayComponent)Iterables.getOnlyElement(GregTechRecipeUtil.buildComponentsFromOutputs(recipe));
            return new AutoValue_CircuitRecipe_Recipe(GregTechRecipeUtil.requiresCleanroom(recipe), GregTechRecipeUtil.requiresLowGravity(recipe), (ImmutableList<ImmutableList<DisplayComponent>>)itemInputsBuilder.build(), fluidInput, output);
        }

        abstract boolean requiresCleanroom();

        abstract boolean requiresLowGravity();

        abstract ImmutableList<ImmutableList<DisplayComponent>> itemInputs();

        abstract DisplayComponent fluidInput();

        abstract DisplayComponent output();

        private int itemInputsSize() {
            return this.itemInputs().size();
        }

        private int outputStackSize() {
            return this.output().stackSize().get();
        }

        private int itemInputsPermutationMultiplier() {
            return this.itemInputs().stream().mapToInt(List::size).reduce(1, Math::multiplyExact);
        }
    }
}

