/*
 * Decompiled with CFR 0.152.
 */
package openblocks.shapes;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.nio.ByteBuffer;
import java.util.List;
import openmods.renderer.shaders.BufferHelper;
import openmods.utils.Coord;
import org.lwjgl.BufferUtils;

public class CoordShape {
    @SideOnly(value=Side.CLIENT)
    private int vbo;
    private final List<Coord> coords;

    public CoordShape(List<Coord> coords) {
        this.coords = coords;
    }

    @SideOnly(value=Side.CLIENT)
    public int bindVBO() {
        if (this.vbo == 0) {
            ByteBuffer data = BufferUtils.createByteBuffer((int)(this.coords.size() * 3 * 4));
            for (Coord c : this.coords) {
                data.putInt(c.x).putInt(c.y).putInt(c.z);
            }
            data.flip();
            this.vbo = BufferHelper.methods().glGenBuffers();
            BufferHelper.methods().glBindBuffer(34962, this.vbo);
            BufferHelper.methods().glBufferData(34962, data, 35044);
        } else {
            BufferHelper.methods().glBindBuffer(34962, this.vbo);
        }
        return this.vbo;
    }

    public List<Coord> getCoords() {
        return this.coords;
    }

    public int size() {
        return this.coords.size();
    }

    @SideOnly(value=Side.CLIENT)
    public void destroy() {
        if (this.vbo != 0) {
            BufferHelper.methods().glDeleteBuffers(this.vbo);
        }
        this.vbo = 0;
    }
}

