/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.common.component.traits;

import li.cil.oc.api.internal.TextBuffer;
import li.cil.oc.common.component.traits.TextBufferProxy;
import li.cil.oc.common.component.traits.TextBufferProxy$;
import li.cil.oc.util.ExtendedUnicodeHelper;
import li.cil.oc.util.PackedColor;
import li.cil.oc.util.PackedColor$;
import li.cil.oc.util.PackedColor$Color$;
import li.cil.oc.util.PackedColor$Depth$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple3;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public abstract class TextBufferProxy$class {
    public static int getWidth(TextBufferProxy $this) {
        return $this.data().width();
    }

    public static int getHeight(TextBufferProxy $this) {
        return $this.data().height();
    }

    public static boolean setColorDepth(TextBufferProxy $this, TextBuffer.ColorDepth depth) {
        if (depth.ordinal() > $this.getMaximumColorDepth().ordinal()) {
            throw new IllegalArgumentException("unsupported depth");
        }
        return $this.data().format_$eq(PackedColor$Depth$.MODULE$.format(depth));
    }

    public static TextBuffer.ColorDepth getColorDepth(TextBufferProxy $this) {
        return $this.data().format().depth();
    }

    public static void onBufferPaletteChange(TextBufferProxy $this, int index) {
    }

    public static void setPaletteColor(TextBufferProxy $this, int index, int color) {
        PackedColor.ColorFormat colorFormat = $this.data().format();
        if (colorFormat instanceof PackedColor.MutablePaletteFormat) {
            PackedColor.MutablePaletteFormat mutablePaletteFormat = (PackedColor.MutablePaletteFormat)colorFormat;
            mutablePaletteFormat.update(index, color);
            $this.onBufferPaletteChange(index);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new Exception("palette not available");
    }

    public static int getPaletteColor(TextBufferProxy $this, int index) {
        PackedColor.ColorFormat colorFormat = $this.data().format();
        if (colorFormat instanceof PackedColor.MutablePaletteFormat) {
            PackedColor.MutablePaletteFormat mutablePaletteFormat = (PackedColor.MutablePaletteFormat)colorFormat;
            int n = mutablePaletteFormat.apply(index);
            return n;
        }
        throw new Exception("palette not available");
    }

    public static void onBufferColorChange(TextBufferProxy $this) {
    }

    public static void setForegroundColor(TextBufferProxy $this, int color) {
        $this.setForegroundColor(color, false);
    }

    public static void setForegroundColor(TextBufferProxy $this, int color, boolean isFromPalette) {
        PackedColor.Color value = new PackedColor.Color(color, isFromPalette);
        PackedColor.Color color2 = $this.data().foreground();
        PackedColor.Color color3 = value;
        if (color2 == null ? color3 != null : !((Object)color2).equals(color3)) {
            $this.data().foreground_$eq(value);
            $this.onBufferColorChange();
        }
    }

    public static int getForegroundColor(TextBufferProxy $this) {
        return $this.data().foreground().value();
    }

    public static boolean isForegroundFromPalette(TextBufferProxy $this) {
        return $this.data().foreground().isPalette();
    }

    public static void setBackgroundColor(TextBufferProxy $this, int color) {
        $this.setBackgroundColor(color, false);
    }

    public static void setBackgroundColor(TextBufferProxy $this, int color, boolean isFromPalette) {
        PackedColor.Color value = new PackedColor.Color(color, isFromPalette);
        PackedColor.Color color2 = $this.data().background();
        PackedColor.Color color3 = value;
        if (color2 == null ? color3 != null : !((Object)color2).equals(color3)) {
            $this.data().background_$eq(value);
            $this.onBufferColorChange();
        }
    }

    public static int getBackgroundColor(TextBufferProxy $this) {
        return $this.data().background().value();
    }

    public static boolean isBackgroundFromPalette(TextBufferProxy $this) {
        return $this.data().background().isPalette();
    }

    public static void onBufferCopy(TextBufferProxy $this, int col, int row, int w, int h, int tx, int ty) {
    }

    public static void copy(TextBufferProxy $this, int col, int row, int w, int h, int tx, int ty) {
        if ($this.data().copy(col, row, w, h, tx, ty)) {
            $this.onBufferCopy(col, row, w, h, tx, ty);
        }
    }

    public static void onBufferFill(TextBufferProxy $this, int col, int row, int w, int h, int c) {
    }

    public static void fill(TextBufferProxy $this, int col, int row, int w, int h, char c) {
        $this.fill(col, row, w, h, (int)c);
    }

    public static void fill(TextBufferProxy $this, int col, int row, int w, int h, int c) {
        if ($this.data().fill(col, row, w, h, c)) {
            $this.onBufferFill(col, row, w, h, c);
        }
    }

    public static void onBufferSet(TextBufferProxy $this, int col, int row, String s, boolean vertical) {
    }

    private static String truncate(TextBufferProxy $this, String s, int sLength, int leftOffset, int maxWidth) {
        int subFrom = s.offsetByCodePoints(0, leftOffset);
        int width = package$.MODULE$.min(sLength, maxWidth);
        return width <= 0 ? "" : (sLength - leftOffset <= width ? s : s.substring(subFrom, s.offsetByCodePoints(subFrom, width)));
    }

    public static void set(TextBufferProxy $this, int col, int row, String s, boolean vertical) {
        int sLength = ExtendedUnicodeHelper.length(s);
        if (col < $this.data().width() && (col >= 0 || -col < sLength)) {
            Tuple3 tuple3;
            Tuple3 tuple32 = vertical ? (row < 0 ? new Tuple3((Object)BoxesRunTime.boxToInteger((int)col), (Object)BoxesRunTime.boxToInteger((int)0), (Object)TextBufferProxy$class.truncate($this, s, sLength, -row, $this.data().height())) : new Tuple3((Object)BoxesRunTime.boxToInteger((int)col), (Object)BoxesRunTime.boxToInteger((int)row), (Object)TextBufferProxy$class.truncate($this, s, sLength, 0, $this.data().height() - row))) : (tuple3 = col < 0 ? new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)row), (Object)TextBufferProxy$class.truncate($this, s, sLength, -col, $this.data().width())) : new Tuple3((Object)BoxesRunTime.boxToInteger((int)col), (Object)BoxesRunTime.boxToInteger((int)row), (Object)TextBufferProxy$class.truncate($this, s, sLength, 0, $this.data().width() - col)));
            if (tuple3 != null) {
                Tuple3 tuple33;
                int x = BoxesRunTime.unboxToInt((Object)tuple3._1());
                int y = BoxesRunTime.unboxToInt((Object)tuple3._2());
                String truncated = (String)tuple3._3();
                Tuple3 tuple34 = tuple33 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)x), (Object)BoxesRunTime.boxToInteger((int)y), (Object)truncated);
                int x2 = BoxesRunTime.unboxToInt((Object)tuple34._1());
                int y2 = BoxesRunTime.unboxToInt((Object)tuple34._2());
                String truncated2 = (String)tuple34._3();
                if ($this.data().set(x2, y2, truncated2, vertical)) {
                    $this.onBufferSet(x2, row, truncated2, vertical);
                }
            } else {
                throw new MatchError((Object)tuple3);
            }
        }
    }

    public static char get(TextBufferProxy $this, int col, int row) {
        return (char)$this.data().get(col, row);
    }

    public static int getCodePoint(TextBufferProxy $this, int col, int row) {
        return $this.data().get(col, row);
    }

    public static int getForegroundColor(TextBufferProxy $this, int column, int row) {
        return $this.isForegroundFromPalette(column, row) ? PackedColor$.MODULE$.extractForeground(TextBufferProxy$class.color($this, column, row)) : PackedColor$.MODULE$.unpackForeground(TextBufferProxy$class.color($this, column, row), $this.data().format());
    }

    public static boolean isForegroundFromPalette(TextBufferProxy $this, int column, int row) {
        return $this.data().format().isFromPalette(PackedColor$.MODULE$.extractForeground(TextBufferProxy$class.color($this, column, row)));
    }

    public static int getBackgroundColor(TextBufferProxy $this, int column, int row) {
        return $this.isBackgroundFromPalette(column, row) ? PackedColor$.MODULE$.extractBackground(TextBufferProxy$class.color($this, column, row)) : PackedColor$.MODULE$.unpackBackground(TextBufferProxy$class.color($this, column, row), $this.data().format());
    }

    public static boolean isBackgroundFromPalette(TextBufferProxy $this, int column, int row) {
        return $this.data().format().isFromPalette(PackedColor$.MODULE$.extractBackground(TextBufferProxy$class.color($this, column, row)));
    }

    public static void rawSetText(TextBufferProxy $this, int col, int row, char[][] text) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(row), RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(row + text.length), $this.data().height())).foreach$mVc$sp((Function1)new Serializable($this, col, row, text){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TextBufferProxy $outer;
            private final int col$1;
            private final int row$1;
            private final char[][] text$1;

            public final void apply(int y) {
                this.apply$mcVI$sp(y);
            }

            public void apply$mcVI$sp(int y) {
                char[] line = this.text$1[y - this.row$1];
                Array$.MODULE$.copy((Object)line, 0, (Object)this.$outer.data().buffer()[y], this.col$1, RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(line.length), this.$outer.data().width()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.col$1 = col$1;
                this.row$1 = row$1;
                this.text$1 = text$1;
            }
        });
    }

    public static void rawSetText(TextBufferProxy $this, int col, int row, int[][] text) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(row), RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(row + text.length), $this.data().height())).foreach$mVc$sp((Function1)new Serializable($this, col, row, text){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TextBufferProxy $outer;
            private final int col$2;
            private final int row$2;
            private final int[][] text$2;

            public final void apply(int y) {
                this.apply$mcVI$sp(y);
            }

            public void apply$mcVI$sp(int y) {
                int[] line = this.text$2[y - this.row$2];
                Array$.MODULE$.copy((Object)line, 0, (Object)this.$outer.data().buffer()[y], this.col$2, RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(line.length), this.$outer.data().width()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.col$2 = col$2;
                this.row$2 = row$2;
                this.text$2 = text$2;
            }
        });
    }

    public static void rawSetForeground(TextBufferProxy $this, int col, int row, int[][] color) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(row), RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(row + color.length), $this.data().height())).foreach$mVc$sp((Function1)new Serializable($this, col, row, color){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TextBufferProxy $outer;
            public final int col$3;
            private final int row$3;
            private final int[][] color$1;

            public final void apply(int y) {
                this.apply$mcVI$sp(y);
            }

            public void apply$mcVI$sp(int y) {
                int[] line = this.color$1[y - this.row$3];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.col$3), RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.col$3 + line.length), this.$outer.data().width())).foreach$mVc$sp((Function1)new Serializable(this, line, y){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ TextBufferProxy$.anonfun.rawSetForeground.1 $outer;
                    private final int[] line$1;
                    private final int y$1;

                    public final void apply(int x) {
                        this.apply$mcVI$sp(x);
                    }

                    public void apply$mcVI$sp(int x) {
                        int packedBackground = this.$outer.li$cil$oc$common$component$traits$TextBufferProxy$$anonfun$$$outer().data().color()[this.y$1][x] & 0xFF;
                        int packedForeground = this.$outer.li$cil$oc$common$component$traits$TextBufferProxy$$anonfun$$$outer().data().format().deflate(new PackedColor.Color(this.line$1[x - this.$outer.col$3], PackedColor$Color$.MODULE$.apply$default$2())) << PackedColor$.MODULE$.ForegroundShift() & 0xFF00;
                        this.$outer.li$cil$oc$common$component$traits$TextBufferProxy$$anonfun$$$outer().data().color()[this.y$1][x] = (short)(packedForeground | packedBackground);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.line$1 = line$1;
                        this.y$1 = y$1;
                    }
                });
            }

            public /* synthetic */ TextBufferProxy li$cil$oc$common$component$traits$TextBufferProxy$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.col$3 = col$3;
                this.row$3 = row$3;
                this.color$1 = color$1;
            }
        });
    }

    public static void rawSetBackground(TextBufferProxy $this, int col, int row, int[][] color) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(row), RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(row + color.length), $this.data().height())).foreach$mVc$sp((Function1)new Serializable($this, col, row, color){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TextBufferProxy $outer;
            public final int col$4;
            private final int row$4;
            private final int[][] color$2;

            public final void apply(int y) {
                this.apply$mcVI$sp(y);
            }

            public void apply$mcVI$sp(int y) {
                int[] line = this.color$2[y - this.row$4];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.col$4), RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.col$4 + line.length), this.$outer.data().width())).foreach$mVc$sp((Function1)new Serializable(this, line, y){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ TextBufferProxy$.anonfun.rawSetBackground.1 $outer;
                    private final int[] line$2;
                    private final int y$2;

                    public final void apply(int x) {
                        this.apply$mcVI$sp(x);
                    }

                    public void apply$mcVI$sp(int x) {
                        int packedBackground = this.$outer.li$cil$oc$common$component$traits$TextBufferProxy$$anonfun$$$outer().data().format().deflate(new PackedColor.Color(this.line$2[x - this.$outer.col$4], PackedColor$Color$.MODULE$.apply$default$2())) & 0xFF;
                        int packedForeground = this.$outer.li$cil$oc$common$component$traits$TextBufferProxy$$anonfun$$$outer().data().color()[this.y$2][x] & 0xFF00;
                        this.$outer.li$cil$oc$common$component$traits$TextBufferProxy$$anonfun$$$outer().data().color()[this.y$2][x] = (short)(packedForeground | packedBackground);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.line$2 = line$2;
                        this.y$2 = y$2;
                    }
                });
            }

            public /* synthetic */ TextBufferProxy li$cil$oc$common$component$traits$TextBufferProxy$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.col$4 = col$4;
                this.row$4 = row$4;
                this.color$2 = color$2;
            }
        });
    }

    private static short color(TextBufferProxy $this, int column, int row) {
        if (column < 0 || column >= $this.getWidth() || row < 0 || row >= $this.getHeight()) {
            throw new IndexOutOfBoundsException();
        }
        return $this.data().color()[row][column];
    }

    public static void $init$(TextBufferProxy $this) {
    }
}

