/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.event;

import baubles.api.BaublesApi;
import com.bymarcin.openglasses.OpenGlasses;
import com.bymarcin.openglasses.item.OpenGlassesItem;
import com.bymarcin.openglasses.network.GlassesNetworkRegistry;
import com.bymarcin.openglasses.network.packet.EquipGlassesPacket;
import com.bymarcin.openglasses.network.packet.UnequipGlassesPacket;
import com.bymarcin.openglasses.surface.ClientSurface;
import com.bymarcin.openglasses.utils.Location;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import tconstruct.armor.ArmorProxyClient;
import tconstruct.armor.player.ArmorExtended;
import tconstruct.armor.player.TPlayerStats;

public class ClientEventHandler {
    int tick = 0;

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent e) {
        IInventory handler;
        int i;
        Item glasses;
        if (e.player != Minecraft.func_71410_x().field_71439_g) {
            return;
        }
        ++this.tick;
        if (this.tick % 40 != 0) {
            return;
        }
        this.tick = 0;
        ItemStack glassesStack = e.player.field_71071_by.field_70460_b[3];
        Item item = glasses = glassesStack != null ? glassesStack.func_77973_b() : null;
        if (OpenGlasses.tinkers && !(glasses instanceof OpenGlassesItem)) {
            ArmorExtended inventory = TPlayerStats.get((EntityPlayer)e.player).armor;
            for (i = 0; i != inventory.func_70302_i_(); ++i) {
                glassesStack = e.side.isClient() ? ArmorProxyClient.armorExtended.func_70301_a(i) : inventory.func_70301_a(i);
                Item item2 = glasses = glassesStack != null ? glassesStack.func_77973_b() : null;
                if (glasses instanceof OpenGlassesItem) break;
            }
        }
        if (OpenGlasses.baubles && !(glasses instanceof OpenGlassesItem) && (handler = BaublesApi.getBaubles((EntityPlayer)e.player)) != null) {
            for (i = 0; i < handler.func_70302_i_(); ++i) {
                glassesStack = handler.func_70301_a(i);
                Item item3 = glasses = glassesStack != null ? glassesStack.func_77973_b() : null;
                if (glasses instanceof OpenGlassesItem) break;
            }
        }
        if (glasses instanceof OpenGlassesItem) {
            Location uuid = OpenGlassesItem.getUUID(glassesStack);
            if (uuid != null && !ClientSurface.instances.haveGlasses) {
                ClientEventHandler.equiped(e.player, uuid);
            } else if (ClientSurface.instances.haveGlasses && (uuid == null || !uuid.equals(ClientSurface.instances.lastBind))) {
                ClientEventHandler.unEquiped(e.player);
            }
        } else if (ClientSurface.instances.haveGlasses) {
            ClientEventHandler.unEquiped(e.player);
        }
    }

    @SubscribeEvent
    public void onJoin(EntityJoinWorldEvent e) {
        if (e.entity == Minecraft.func_71410_x().field_71439_g && e.world.field_72995_K) {
            ClientSurface.instances.removeAllWidgets();
            ClientSurface.instances.haveGlasses = false;
        }
    }

    public static void unEquiped(EntityPlayer player) {
        ClientSurface.instances.haveGlasses = false;
        ClientSurface.instances.removeAllWidgets();
        GlassesNetworkRegistry.packetHandler.sendToServer((IMessage)new UnequipGlassesPacket(player));
    }

    public static void equiped(EntityPlayer player, Location uuid) {
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
        ClientSurface.instances.lastBind = uuid;
        GlassesNetworkRegistry.packetHandler.sendToServer((IMessage)new EquipGlassesPacket(uuid, player, sr.func_78326_a(), sr.func_78328_b()));
        ClientSurface.instances.haveGlasses = true;
    }
}

