/*
 * Decompiled with CFR 0.152.
 */
package io.nettyopis.channel;

import io.nettyopis.channel.Channel;
import io.nettyopis.channel.ChannelFuture;
import io.nettyopis.channel.ChannelPromise;
import io.nettyopis.channel.EventLoop;
import io.nettyopis.channel.EventLoopGroup;
import io.nettyopis.util.concurrent.DefaultThreadFactory;
import io.nettyopis.util.concurrent.MultithreadEventExecutorGroup;
import io.nettyopis.util.internal.SystemPropertyUtil;
import io.nettyopis.util.internal.logging.InternalLogger;
import io.nettyopis.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.ThreadFactory;

public abstract class MultithreadEventLoopGroup
extends MultithreadEventExecutorGroup
implements EventLoopGroup {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MultithreadEventLoopGroup.class);
    private static final int DEFAULT_EVENT_LOOP_THREADS = Math.max(1, SystemPropertyUtil.getInt("io.nettyopis.eventLoopThreads", Runtime.getRuntime().availableProcessors() * 2));

    protected MultithreadEventLoopGroup(int nThreads, ThreadFactory threadFactory, Object ... args) {
        super(nThreads == 0 ? DEFAULT_EVENT_LOOP_THREADS : nThreads, threadFactory, args);
    }

    @Override
    protected ThreadFactory newDefaultThreadFactory() {
        return new DefaultThreadFactory(this.getClass(), 10);
    }

    @Override
    public EventLoop next() {
        return (EventLoop)super.next();
    }

    @Override
    public ChannelFuture register(Channel channel) {
        return this.next().register(channel);
    }

    @Override
    public ChannelFuture register(Channel channel, ChannelPromise promise) {
        return this.next().register(channel, promise);
    }

    static {
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.eventLoopThreads: {}", (Object)DEFAULT_EVENT_LOOP_THREADS);
        }
    }
}

