/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.signals;

import javax.annotation.Nonnull;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.api.signals.AbstractPair;
import mods.railcraft.api.signals.IControllerTile;
import mods.railcraft.api.signals.IReceiverTile;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.api.signals.SignalController;
import net.minecraft.tileentity.TileEntity;

public abstract class SignalReceiver
extends AbstractPair {
    private boolean needsInit = true;

    public SignalReceiver(String locTag, TileEntity tile, int maxPairings) {
        super(locTag, tile, maxPairings);
    }

    public SignalController getControllerAt(WorldCoordinate coord) {
        TileEntity con = this.getPairAt(coord);
        if (con != null) {
            return ((IControllerTile)con).getController();
        }
        return null;
    }

    @Override
    public void informPairsOfNameChange() {
        for (WorldCoordinate coord : this.getPairs()) {
            SignalController ctrl = this.getControllerAt(coord);
            if (ctrl == null) continue;
            ctrl.onPairNameChange(this.getCoords(), this.getName());
        }
    }

    @Override
    protected String getTagName() {
        return "receiver";
    }

    @Override
    public boolean isValidPair(WorldCoordinate otherCoord, TileEntity otherTile) {
        if (otherTile instanceof IControllerTile) {
            SignalController controller = ((IControllerTile)otherTile).getController();
            return controller.isPairedWith(this.getCoords());
        }
        return false;
    }

    public void onControllerAspectChange(SignalController con, @Nonnull SignalAspect aspect) {
        ((IReceiverTile)this.tile).onControllerAspectChange(con, aspect);
    }

    protected void registerController(SignalController controller) {
        this.addPairing(controller.getCoords());
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.needsInit) {
            this.needsInit = false;
            for (WorldCoordinate pair : this.getPairs()) {
                SignalController controller = this.getControllerAt(pair);
                if (controller == null) continue;
                this.onControllerAspectChange(controller, controller.getAspectFor(this.getCoords()));
            }
        }
    }
}

