/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.IEnergyTransfer;
import mods.railcraft.api.carts.ILinkageManager;
import mods.railcraft.api.electricity.IElectricMinecart;
import mods.railcraft.common.carts.CartContainerBase;
import mods.railcraft.common.carts.IIC2EnergyCart;
import mods.railcraft.common.carts.Train;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.ic2.IC2Plugin;
import mods.railcraft.common.util.misc.APIErrorHandler;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.SafeNBTWrapper;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

abstract class EntityCartEnergy
extends CartContainerBase
implements IEnergyTransfer,
IElectricMinecart,
IIC2EnergyCart {
    private final IElectricMinecart.ChargeHandler chargeHandler = new IElectricMinecart.ChargeHandler((EntityMinecart)this, IElectricMinecart.ChargeHandler.Type.STORAGE, this.getCapacity());

    public EntityCartEnergy(World world) {
        super(world);
    }

    @Override
    public IElectricMinecart.ChargeHandler getChargeHandler() {
        return this.chargeHandler;
    }

    @Override
    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ItemStack stack = this.getIC2Item();
        if (RailcraftConfig.doCartsBreakOnDrop() && stack != null) {
            items.add(new ItemStack(Items.field_151143_au));
            items.add(stack);
        } else {
            items.add(this.getCartItem());
        }
        return items;
    }

    public void func_70071_h_() {
        ItemStack stack;
        super.func_70071_h_();
        if (Game.isNotHost(this.field_70170_p)) {
            return;
        }
        if (this.getEnergy() > (double)this.getCapacity()) {
            this.setEnergy(this.getCapacity());
        }
        if (IC2Plugin.isEnergyItem(stack = this.func_70301_a(0)) && this.getEnergy() > 0.0) {
            this.setEnergy(this.getEnergy() - IC2Plugin.chargeItem(stack, this.getEnergy(), this.getTier()));
        }
        if (IC2Plugin.isEnergyItem(stack = this.func_70301_a(1)) && this.getEnergy() < (double)this.getCapacity()) {
            this.setEnergy(this.getEnergy() + IC2Plugin.dischargeItem(stack, (double)this.getCapacity() - this.getEnergy(), this.getTier()));
        }
    }

    @Override
    public abstract int getTier();

    @Override
    public boolean doInteract(EntityPlayer player) {
        if (Game.isHost(this.field_70170_p)) {
            GuiHandler.openGui(EnumGui.CART_ENERGY, player, this.field_70170_p, (Entity)this);
        }
        return true;
    }

    public boolean canBeRidden() {
        return false;
    }

    public final float getMaxCartSpeedOnRail() {
        int numLocomotives = Train.getTrain((EntityMinecart)this).getNumRunningLocomotives();
        if (numLocomotives == 0) {
            return super.getMaxCartSpeedOnRail();
        }
        return Math.min(1.2f, 0.18f - 0.05f * (float)this.getTier() + (float)(numLocomotives - 1) * 0.075f);
    }

    public int func_70302_i_() {
        return 2;
    }

    @Override
    public abstract String func_145825_b();

    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        SafeNBTWrapper safe = new SafeNBTWrapper(nbt);
        this.setEnergy(safe.getDouble("energy"));
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.getEnergy());
    }

    @Override
    public double injectEnergy(Object source, double amount, int tier, boolean ignoreTransferLimit, boolean simulate, boolean passAlong) {
        int capacity;
        double e;
        if (tier < this.getTier()) {
            return amount;
        }
        double extra = 0.0;
        if (!ignoreTransferLimit) {
            extra = Math.max(amount - (double)this.getTransferLimit(), 0.0);
            amount = Math.min(amount, (double)this.getTransferLimit());
        }
        if ((e = this.getEnergy() + amount) > (double)(capacity = this.getCapacity())) {
            extra += e - (double)capacity;
            e = capacity;
        }
        if (!simulate) {
            this.setEnergy(e);
        }
        if (!passAlong) {
            return extra;
        }
        try {
            ILinkageManager lm = CartTools.getLinkageManager(this.field_70170_p);
            EntityMinecart linkedCart = lm.getLinkedCartA((EntityMinecart)this);
            if (extra > 0.0 && linkedCart != source && linkedCart instanceof IEnergyTransfer) {
                extra = ((IEnergyTransfer)linkedCart).injectEnergy(this, extra, tier, ignoreTransferLimit, simulate, true);
            }
            linkedCart = lm.getLinkedCartB((EntityMinecart)this);
            if (extra > 0.0 && linkedCart != source && linkedCart instanceof IEnergyTransfer) {
                extra = ((IEnergyTransfer)linkedCart).injectEnergy(this, extra, tier, ignoreTransferLimit, simulate, true);
            }
        }
        catch (Throwable t) {
            APIErrorHandler.versionMismatch(IEnergyTransfer.class);
        }
        return extra;
    }

    @Override
    public double extractEnergy(Object source, double amount, int tier, boolean ignoreTransferLimit, boolean simulate, boolean passAlong) {
        double provide;
        if (tier < this.getTier()) {
            return 0.0;
        }
        if (!ignoreTransferLimit) {
            amount = Math.min(amount, (double)this.getTransferLimit());
        }
        double e = this.getEnergy();
        if ((e -= (provide = Math.min(amount, e))) < 0.0) {
            e = 0.0;
        }
        if (!simulate) {
            this.setEnergy(e);
        }
        if (!passAlong) {
            return provide;
        }
        ILinkageManager lm = CartTools.getLinkageManager(this.field_70170_p);
        EntityMinecart linkedCart = lm.getLinkedCartA((EntityMinecart)this);
        if (provide < amount && linkedCart != source && linkedCart instanceof IEnergyTransfer) {
            provide += ((IEnergyTransfer)linkedCart).extractEnergy(this, amount - provide, tier, ignoreTransferLimit, simulate, true);
        }
        linkedCart = lm.getLinkedCartB((EntityMinecart)this);
        if (provide < amount && linkedCart != source && linkedCart instanceof IEnergyTransfer) {
            provide += ((IEnergyTransfer)linkedCart).extractEnergy(this, amount - provide, tier, ignoreTransferLimit, simulate, true);
        }
        return provide;
    }

    public abstract ItemStack getIC2Item();

    public Block func_145820_n() {
        ItemStack stack = this.getIC2Item();
        if (stack != null) {
            return ((ItemBlock)stack.func_77973_b()).field_150939_a;
        }
        return super.func_145820_n();
    }

    public int func_94098_o() {
        ItemStack stack = this.getIC2Item();
        if (stack != null) {
            return stack.func_77960_j();
        }
        return 0;
    }

    @Override
    public int getEnergyBarScaled(int scale) {
        return (int)this.getEnergy() * scale / this.getCapacity();
    }

    @Override
    public double getEnergy() {
        return this.chargeHandler.getCharge();
    }

    @Override
    public void setEnergy(double energy) {
        this.chargeHandler.setCharge(energy);
    }

    @Override
    public boolean canExtractEnergy() {
        return true;
    }

    @Override
    public boolean canInjectEnergy() {
        return true;
    }

    @Override
    public String getName() {
        return this.func_70005_c_();
    }

    @Override
    public EntityMinecart getEntity() {
        return this;
    }
}

