/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.network;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.util.network.PacketDispatcher;
import mods.railcraft.common.util.network.PacketTileEntity;
import mods.railcraft.common.util.network.RailcraftPacket;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class PacketTileRequest
extends RailcraftPacket {
    private TileEntity tile;
    private EntityPlayerMP player;

    public PacketTileRequest(EntityPlayerMP player) {
        this.player = player;
    }

    public PacketTileRequest(TileEntity tile) {
        this.tile = tile;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeInt(this.tile.func_145831_w().field_73011_w.field_76574_g);
        data.writeInt(this.tile.field_145851_c);
        data.writeInt(this.tile.field_145848_d);
        data.writeInt(this.tile.field_145849_e);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        WorldServer world = DimensionManager.getWorld((int)data.readInt());
        if (world == null) {
            return;
        }
        int x = data.readInt();
        int y = data.readInt();
        int z = data.readInt();
        this.tile = world.func_147438_o(x, y, z);
        if (this.tile instanceof RailcraftTileEntity && this.player != null) {
            PacketDispatcher.sendToPlayer(new PacketTileEntity((RailcraftTileEntity)this.tile), this.player);
        }
    }

    @Override
    public int getID() {
        return RailcraftPacket.PacketType.TILE_REQUEST.ordinal();
    }
}

