/*
 * Decompiled with CFR 0.152.
 */
package stevesaddons.threading;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import stevesaddons.threading.ThreadSafeHandler;
import vswe.stevesfactory.components.ScrollController;

public class SearchItems
implements Runnable {
    public static volatile List<SearchEntry> searchEntries = new ArrayList<SearchEntry>();
    private String search;
    private ScrollController controller;
    private boolean showAll;

    public SearchItems(String search, ScrollController controller, boolean showAll) {
        this.search = search;
        this.controller = controller;
        this.showAll = showAll;
    }

    @Override
    public void run() {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        if (this.search.equals(".inv")) {
            InventoryPlayer inventory = Minecraft.func_71410_x().field_71439_g.field_71071_by;
            for (int itemStack = 0; itemStack < inventory.func_70302_i_(); ++itemStack) {
                ItemStack stack = inventory.func_70301_a(itemStack);
                if (stack == null) continue;
                stack = stack.func_77946_l();
                stack.field_77994_a = 1;
                itemStacks.add(stack);
            }
        } else {
            if (searchEntries.isEmpty()) {
                SearchItems.setItems();
            }
            if (!this.showAll) {
                Pattern pattern = Pattern.compile(Pattern.quote(this.search), 2);
                boolean advanced = Minecraft.func_71410_x().field_71474_y.field_82882_x;
                for (SearchEntry entry : searchEntries) {
                    entry.search(pattern, itemStacks, advanced);
                }
            } else {
                for (SearchEntry entry : searchEntries) {
                    itemStacks.add(entry.getStack());
                }
            }
        }
        SearchItems.setResult(this.controller, itemStacks);
    }

    public static void setResult(ScrollController controller, List<ItemStack> stackList) {
        ThreadSafeHandler.handle.put(controller, stackList);
    }

    public static synchronized void setItems() {
        if (!searchEntries.isEmpty()) {
            return;
        }
        ArrayList stacks = new ArrayList();
        ArrayList<SearchEntry> searchEntries = new ArrayList<SearchEntry>();
        for (Object anItemRegistry : Item.field_150901_e) {
            try {
                Item item = (Item)anItemRegistry;
                item.func_150895_a(item, item.func_77640_w(), stacks);
            }
            catch (Exception item) {}
        }
        for (ItemStack stack : stacks) {
            try {
                List tooltipList = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false);
                List advTooltipList = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, true);
                String searchString = "";
                for (Object string : tooltipList) {
                    if (string == null) continue;
                    searchString = searchString + string + "\n";
                }
                String advSearchString = "";
                for (Object string : advTooltipList) {
                    if (string == null) continue;
                    advSearchString = advSearchString + string + "\n";
                }
                searchEntries.add(new SearchEntry(searchString, advSearchString, stack));
            }
            catch (Throwable throwable) {}
        }
        SearchItems.searchEntries = searchEntries;
    }

    public static class SearchEntry {
        private String toolTip;
        private String advToolTip;
        private ItemStack stack;

        public SearchEntry(String searchString, String advSearchString, ItemStack stack) {
            this.toolTip = searchString;
            this.advToolTip = advSearchString;
            this.stack = stack;
        }

        public void search(Pattern pattern, List<ItemStack> stacks, boolean advanced) {
            if (pattern.matcher(advanced ? this.advToolTip : this.toolTip).find()) {
                stacks.add(this.stack);
            }
        }

        public ItemStack getStack() {
            return this.stack;
        }
    }
}

