/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.weaponry;

import cpw.mods.fml.common.Loader;
import java.util.List;
import mods.battlegear2.api.core.InventoryPlayerBattle;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.tools.BowstringMaterial;
import tconstruct.library.tools.CustomMaterial;
import tconstruct.library.weaponry.IAmmo;
import tconstruct.library.weaponry.ProjectileWeapon;
import tconstruct.weaponry.ammo.ArrowAmmo;
import tconstruct.weaponry.entity.ArrowEntity;

public abstract class BowBaseAmmo
extends ProjectileWeapon {
    public BowBaseAmmo(int baseDamage, String name) {
        super(baseDamage, name);
    }

    @Override
    public int durabilityTypeAccessory() {
        return 2;
    }

    @Override
    public int durabilityTypeExtra() {
        return 1;
    }

    @Override
    public boolean zoomOnWindup(ItemStack itemStack) {
        return true;
    }

    @Override
    public float getZoom(ItemStack itemStack) {
        return 1.2f;
    }

    @Override
    public float getMinWindupProgress(ItemStack itemStack) {
        return 0.5f;
    }

    @Override
    public float getProjectileSpeed(ItemStack itemStack) {
        return super.getProjectileSpeed(itemStack) * 0.9f;
    }

    @Override
    public ItemStack searchForAmmo(EntityPlayer player, ItemStack weapon) {
        int i;
        ItemStack offhand;
        if (Loader.isModLoaded((String)"battlegear2") && (offhand = ((InventoryPlayerBattle)player.field_71071_by).getCurrentOffhandWeapon()) != null && (this.checkTinkerArrow(offhand) || this.checkVanillaArrow(offhand))) {
            return offhand;
        }
        ItemStack[] inventory = player.field_71071_by.field_70462_a;
        for (i = 0; i < InventoryPlayer.func_70451_h(); ++i) {
            if (!this.checkTinkerArrow(inventory[i])) continue;
            return inventory[i];
        }
        for (i = 0; i < InventoryPlayer.func_70451_h(); ++i) {
            if (!this.checkVanillaArrow(inventory[i])) continue;
            return inventory[i];
        }
        for (i = InventoryPlayer.func_70451_h(); i < inventory.length; ++i) {
            if (!this.checkTinkerArrow(inventory[i])) continue;
            return inventory[i];
        }
        for (i = InventoryPlayer.func_70451_h(); i < inventory.length; ++i) {
            if (!this.checkVanillaArrow(inventory[i])) continue;
            return inventory[i];
        }
        if (player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)weapon) > 0) {
            return new ItemStack(Items.field_151032_g);
        }
        return null;
    }

    private boolean checkTinkerArrow(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (!(stack.func_77973_b() instanceof ArrowAmmo)) {
            return false;
        }
        return ((IAmmo)stack.func_77973_b()).getAmmoCount(stack) > 0;
    }

    private boolean checkVanillaArrow(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.func_77973_b() == Items.field_151032_g;
    }

    @Override
    protected Entity createProjectile(ItemStack arrows, World world, EntityPlayer player, float speed, float accuracy, float windup) {
        EntityArrow arrow;
        if (arrows.func_77973_b() == Items.field_151032_g) {
            arrow = new EntityArrow(world, (EntityLivingBase)player, speed / 1.5f);
        } else {
            ItemStack reference = arrows.func_77946_l();
            reference.field_77994_a = 1;
            reference.func_77978_p().func_74775_l("InfiTool").func_74768_a("Ammo", 1);
            arrow = new ArrowEntity(world, player, speed, accuracy, reference);
        }
        if (player.field_71075_bZ.field_75098_d) {
            arrow.field_70251_a = 2;
        }
        if (windup >= 1.0f) {
            arrow.func_70243_d(true);
        }
        return arrow;
    }

    @Override
    public void playFiringSound(World world, EntityPlayer player, ItemStack weapon, ItemStack ammo, float speed, float accuracy) {
        world.func_72956_a((Entity)player, "random.bow", 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + speed * 0.5f);
    }

    @Override
    public void buildTool(int id, String name, List list) {
        if (TConstructRegistry.getBowMaterial(id) == null) {
            return;
        }
        ItemStack handleStack = new ItemStack(this.getHandleItem(), 1, 0);
        ItemStack accessoryStack = this.getPartAmount() > 2 ? new ItemStack(this.getAccessoryItem(), 1, id) : null;
        ItemStack extraStack = this.getPartAmount() > 3 ? new ItemStack(this.getExtraItem(), 1, id) : null;
        ItemStack tool = ToolBuilder.instance.buildTool(new ItemStack(this.getHeadItem(), 1, id), handleStack, accessoryStack, extraStack, "");
        if (tool != null) {
            tool.func_77978_p().func_74775_l("InfiTool").func_74757_a("Built", true);
            list.add(tool);
        }
    }

    @Override
    protected int getDefaultColor(int renderPass, int materialID) {
        CustomMaterial material;
        if (renderPass == 0 && (material = TConstructRegistry.getCustomMaterial(materialID, BowstringMaterial.class)) != null) {
            return material.color;
        }
        return super.getDefaultColor(renderPass, materialID);
    }

    @Override
    public String[] getTraits() {
        return new String[]{"weapon", "bow", "windup"};
    }
}

