/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.gui;

import codechicken.nei.VisiblityData;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.TaggedInventoryArea;
import cpw.mods.fml.common.Optional;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.PatternBuilder;
import tconstruct.library.modifier.IModifyable;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.util.HarvestLevels;
import tconstruct.tools.gui.ChestSlot;
import tconstruct.tools.gui.GuiBorderWidget;
import tconstruct.tools.gui.GuiElementDuex;
import tconstruct.tools.gui.GuiElementScalable;
import tconstruct.tools.gui.GuiSliderWidget;
import tconstruct.tools.gui.ToolStationGuiHelper;
import tconstruct.tools.logic.CraftingStationLogic;

@Optional.Interface(iface="codechicken.nei.api.INEIGuiHandler", modid="NotEnoughItems")
public class CraftingStationGui
extends GuiContainer
implements INEIGuiHandler {
    private static final ResourceLocation gui_inventory = new ResourceLocation("tinker", "textures/gui/generic.png");
    public static final GuiElementScalable slotElement = new GuiElementScalable(7, 7, 18, 18, 64, 64);
    public static final GuiElementScalable slotEmptyElement = new GuiElementScalable(25, 7, 18, 18, 64, 64);
    private static final GuiElementDuex sliderNormal = new GuiElementDuex(7, 25, 10, 15, 64, 64);
    private static final GuiElementDuex sliderLow = new GuiElementDuex(17, 25, 10, 15, 64, 64);
    private static final GuiElementDuex sliderHigh = new GuiElementDuex(27, 25, 10, 15, 64, 64);
    private static final GuiElementDuex sliderTop = new GuiElementDuex(43, 7, 12, 1, 64, 64);
    private static final GuiElementDuex sliderBottom = new GuiElementDuex(43, 38, 12, 1, 64, 64);
    private static final GuiElementScalable sliderBackground = new GuiElementScalable(43, 8, 12, 30, 64, 64);
    private static final GuiElementScalable textBackground = new GuiElementScalable(25, 7, 18, 10, 64, 64);
    private final GuiSliderWidget slider = new GuiSliderWidget(sliderNormal, sliderHigh, sliderLow, sliderTop, sliderBottom, sliderBackground);
    private final GuiBorderWidget border = new GuiBorderWidget();
    private int firstSlotId;
    private int lastSlotId;
    private int chestSlotCount;
    private static final ResourceLocation background = new ResourceLocation("tinker", "textures/gui/tinkertable.png");
    private static final ResourceLocation description = new ResourceLocation("tinker", "textures/gui/description.png");
    private static final ResourceLocation icons = new ResourceLocation("tinker", "textures/gui/icons.png");
    public boolean active;
    public String toolName;
    public GuiTextField text;
    public String title;
    public String body;
    CraftingStationLogic logic;
    private int craftingLeft = 0;
    private int craftingTop = 0;
    private int craftingTextLeft = 0;
    private int descLeft = 0;
    private int descTop = 0;
    private int descTextLeft = 0;
    private int chestLeft = 0;
    private int chestTop = 0;
    private int chestWidth = 0;
    private int chestHeight = 0;
    @Deprecated
    public static final int CHEST_WIDTH = 116;

    public CraftingStationGui(InventoryPlayer inventory, CraftingStationLogic logic, World world, int x, int y, int z) {
        super(logic.getGuiContainer(inventory, world, x, y, z));
        this.logic = logic;
        this.title = "\u00a7n" + StatCollector.func_74838_a((String)"gui.toolforge1");
        this.body = StatCollector.func_74838_a((String)"gui.toolforge2");
        this.toolName = "";
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146999_f = 176;
        this.field_147000_g = 166;
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.craftingLeft = this.field_147003_i;
        this.craftingTop = this.field_147009_r;
        if (this.logic.tinkerTable) {
            this.descLeft = this.field_147003_i + 176;
            this.descTop = this.craftingTop;
        }
        if (this.logic.chest != null) {
            this.updateChest();
        } else {
            this.slider.hide();
        }
        this.craftingTextLeft = this.craftingLeft - this.field_147003_i;
        this.descTextLeft = this.descLeft - this.field_147003_i;
    }

    protected void func_146979_b(int par1, int par2) {
        if (this.logic.chest != null) {
            TileEntity te;
            if (this.logic.chest.get() instanceof TileEntity && ((te = (TileEntity)this.logic.chest.get()) == null || te.func_145831_w().func_147438_o(te.field_145851_c, te.field_145848_d, te.field_145849_e) == null && te.func_145831_w().field_72995_K)) {
                this.field_146297_k.field_71439_g.func_71053_j();
                return;
            }
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)((IInventory)this.logic.chest.get()).func_145825_b()), 8, 6, 0x202020);
        }
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)(this.logic.tinkerTable ? "crafters.TinkerTable" : this.logic.getInvName())), this.craftingTextLeft + 8, 6, 0x202020);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), this.craftingTextLeft + 8, 72, 0x202020);
        if (this.logic.tinkerTable) {
            if (this.logic.isStackInSlot(0)) {
                this.drawToolStats(this.logic.func_70301_a(0));
            } else if (this.logic.isStackInSlot(5)) {
                if (!(this.logic.isStackInSlot(1) || this.logic.isStackInSlot(2) || this.logic.isStackInSlot(3) || this.logic.isStackInSlot(4) || this.logic.isStackInSlot(6) || this.logic.isStackInSlot(7) || this.logic.isStackInSlot(8) || this.logic.isStackInSlot(9))) {
                    this.drawToolStats(this.logic.func_70301_a(5));
                } else {
                    this.drawToolInformation();
                }
            } else {
                this.drawToolInformation();
            }
        }
    }

    void drawToolStats(ItemStack stack) {
        ToolMaterial material;
        int matID;
        if (stack.func_77973_b() instanceof IModifyable) {
            ToolStationGuiHelper.drawToolStats(stack, this.descTextLeft + 10, 0);
        }
        if ((matID = PatternBuilder.instance.getPartID(stack)) != Short.MAX_VALUE && matID > 0 && (material = TConstructRegistry.getMaterial(matID)) != null) {
            this.drawMaterialStats(material);
        }
    }

    void drawToolInformation() {
        int offsetX = this.descTextLeft + 63;
        this.func_73732_a(this.field_146289_q, this.title, offsetX, 8, 0xFFFFFF);
        this.field_146289_q.func_78279_b(this.body, offsetX - 56, 24, 115, 0xFFFFFF);
    }

    protected void drawMaterialStats(ToolMaterial materialEnum) {
        String heart;
        int baseX = this.descTextLeft + 8;
        int baseY = 8;
        String centerTitle = "\u00a7n" + materialEnum.localizedName();
        this.func_73732_a(this.field_146289_q, centerTitle, baseX + 55, 8, 0xFFFFFF);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.partcrafter4") + materialEnum.durability(), baseX, 24, 0xFFFFFF);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.partcrafter5") + materialEnum.handleDurability() + "x", baseX, 35, 0xFFFFFF);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.partcrafter6") + (float)materialEnum.toolSpeed() / 100.0f, baseX, 46, 0xFFFFFF);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.partcrafter7") + HarvestLevels.getHarvestLevelName(materialEnum.harvestLevel()), baseX, 57, 0xFFFFFF);
        int attack = materialEnum.attack();
        String string = heart = attack == 2 ? StatCollector.func_74838_a((String)"gui.partcrafter8") : StatCollector.func_74838_a((String)"gui.partcrafter9");
        if (attack % 2 == 0) {
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.partcrafter10") + attack / 2 + heart, baseX, 68, 0xFFFFFF);
        } else {
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"gui.partcrafter10") + (float)attack / 2.0f + heart, baseX, 68, 0xFFFFFF);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(background);
        this.func_73729_b(this.craftingLeft, this.craftingTop, 0, 0, 176, 166);
        if (this.active) {
            this.func_73729_b(this.craftingLeft + 62, this.craftingTop, 0, 166, 112, 22);
        }
        this.field_146297_k.func_110434_K().func_110577_a(icons);
        if (this.logic.tinkerTable && !this.logic.isStackInSlot(5)) {
            this.func_73729_b(this.craftingLeft + 47, this.craftingTop + 33, 0, 233, 18, 18);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(gui_inventory);
        if (this.hasChest()) {
            this.chestLeft += this.border.w;
            this.chestTop += this.border.h;
            this.border.draw();
            int x = this.chestLeft;
            int y = this.chestTop;
            int midW = this.chestWidth - this.border.w * 2;
            if (this.shouldDrawName()) {
                textBackground.drawScaledX(this.chestLeft, this.chestTop, midW);
                y += CraftingStationGui.textBackground.h;
            }
            this.drawChestSlots(x, y);
            if (this.slider.isEnabled()) {
                this.slider.update(mouseX, mouseY, !this.isMouseOverFullSlot(mouseX, mouseY) && this.isMouseInChest(mouseX, mouseY));
                this.slider.draw();
                this.updateChestSlots();
            }
            this.chestLeft -= this.border.w;
            this.chestTop -= this.border.h;
        }
        if (this.logic.tinkerTable) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(description);
            this.func_73729_b(this.descLeft, this.descTop, 0, 0, 126, 172);
        }
    }

    public VisiblityData modifyVisiblity(GuiContainer gui, VisiblityData currentVisibility) {
        boolean bl = currentVisibility.showWidgets = this.field_146294_l - this.field_146999_f >= 107;
        if (this.field_147003_i < 58) {
            currentVisibility.showStateButtons = false;
        }
        return currentVisibility;
    }

    public Iterable<Integer> getItemSpawnSlots(GuiContainer gui, ItemStack item) {
        return null;
    }

    public List<TaggedInventoryArea> getInventoryAreas(GuiContainer gui) {
        return Collections.emptyList();
    }

    public boolean handleDragNDrop(GuiContainer gui, int mousex, int mousey, ItemStack draggedStack, int button) {
        return false;
    }

    public boolean hideItemPanelSlot(GuiContainer gui, int x, int y, int w, int h) {
        int cw;
        int n = cw = this.logic.chest != null ? this.chestWidth : 0;
        if (this.logic.chest != null) {
            Rectangle blah = new Rectangle(x, y, w, h);
            Rectangle chestRectangle = new Rectangle(this.chestLeft, this.chestTop, this.chestWidth, this.chestHeight + (this.shouldDrawName() ? CraftingStationGui.textBackground.y : 0) + this.border.h * 2);
            if (chestRectangle.intersects(blah)) {
                return true;
            }
        }
        if (y + h - 4 < this.field_147009_r || y + 4 > this.field_147009_r + this.field_147000_g) {
            return false;
        }
        return x - w - 4 >= this.field_147003_i + cw && x + 4 <= this.field_147003_i + this.field_146999_f + cw + (this.logic.tinkerTable ? 126 : 0);
    }

    public boolean hasChest() {
        return this.logic.chest != null;
    }

    public boolean isMouseInChest(int mouseX, int mouseY) {
        int xMod = (this.slider.isEnabled() ? this.slider.width : 0) + this.border.w;
        int yMod = (this.shouldDrawName() ? CraftingStationGui.textBackground.y : 0) + this.border.h * 2;
        return mouseX >= this.chestLeft - xMod && mouseX < this.chestLeft + this.chestWidth + xMod && mouseY >= this.chestTop - yMod && mouseY < this.chestTop + this.chestHeight + yMod;
    }

    public boolean isMouseOverFullSlot(int mouseX, int mouseY) {
        for (Object slot : this.field_147002_h.field_75151_b) {
            if (!this.func_146981_a((Slot)slot, mouseX, mouseY) || !((Slot)slot).func_75216_d()) continue;
            return true;
        }
        return false;
    }

    protected boolean shouldDrawName() {
        return this.logic.chest != null && ((IInventory)this.logic.chest.get()).func_145825_b() != null && !((IInventory)this.logic.chest.get()).func_145825_b().isEmpty();
    }

    public void func_146977_a(Slot slot) {
        if (!slot.func_111238_b()) {
            return;
        }
        super.func_146977_a(slot);
    }

    public boolean shouldDrawSlot(Slot slot) {
        if (!(slot instanceof ChestSlot)) {
            return true;
        }
        ChestSlot chestSlot = (ChestSlot)slot;
        if (!this.slider.isEnabled()) {
            return true;
        }
        return this.firstSlotId <= chestSlot.getVisualIndex() && this.lastSlotId > chestSlot.getVisualIndex();
    }

    public boolean func_146981_a(Slot slotIn, int mouseX, int mouseY) {
        return super.func_146981_a(slotIn, mouseX, mouseY) && this.shouldDrawSlot(slotIn);
    }

    private int getDisplayedRows() {
        return this.chestHeight / CraftingStationGui.slotElement.h;
    }

    private int calcCappedYSize(int max) {
        int h;
        for (h = CraftingStationGui.slotElement.h * this.logic.invRows; h > max; h -= CraftingStationGui.slotElement.h) {
        }
        return h;
    }

    public int getChestWidth() {
        return this.chestWidth;
    }

    public void updateChest() {
        this.chestHeight = this.calcCappedYSize(CraftingStationGui.slotElement.h * 10);
        this.chestSlotCount = this.logic.slotCount;
        if (this.getDisplayedRows() < this.logic.invRows) {
            this.slider.enable();
        } else {
            this.slider.disable();
        }
        this.chestWidth = this.logic.invColumns * CraftingStationGui.slotElement.w + 2 * this.border.w + (this.slider.isEnabled() ? this.slider.width : 0);
        this.chestLeft = this.field_147003_i - this.chestWidth;
        this.chestTop = this.field_147009_r;
        this.field_147003_i = this.chestLeft;
        this.border.setPosition(this.chestLeft, this.chestTop);
        this.border.setSize(this.chestWidth, this.chestHeight + (this.shouldDrawName() ? CraftingStationGui.textBackground.h : 0) + 2 * this.border.h);
        this.slider.show();
        this.slider.setPosition(this.chestLeft + this.logic.invColumns * CraftingStationGui.slotElement.w + this.border.w, this.chestTop + (this.shouldDrawName() ? CraftingStationGui.textBackground.h : 0) + this.border.h);
        this.slider.setSize(this.chestHeight);
        this.slider.setSliderParameters(0, this.logic.invRows - this.getDisplayedRows(), 1);
        this.updateChestSlots();
    }

    protected void func_73864_a(int x, int y, int button) {
        int height = this.field_147000_g;
        if (this.logic.chest != null && x >= this.field_147003_i && x <= this.field_147003_i + this.chestWidth) {
            this.field_147000_g = this.border.height;
        }
        this.field_146999_f += this.chestWidth;
        super.func_73864_a(x, y, button);
        this.field_146999_f -= this.chestWidth;
        this.field_147000_g = height;
    }

    protected void func_146286_b(int x, int y, int button) {
        int height = this.field_147000_g;
        if (this.logic.chest != null && x >= this.field_147003_i && x <= this.field_147003_i + this.chestWidth) {
            this.field_147000_g = this.border.height;
        }
        this.field_146999_f += this.chestWidth;
        super.func_146286_b(x, y, button);
        this.field_146999_f -= this.chestWidth;
        this.field_147000_g = height;
    }

    protected void updateChestSlots() {
        if (!this.hasChest()) {
            return;
        }
        IInventory secondInventory = this.logic.getSecondInventory();
        int xOffset = this.border.w;
        int yOffset = this.border.h;
        if (this.shouldDrawName()) {
            yOffset += CraftingStationGui.textBackground.h;
        }
        this.firstSlotId = this.slider.getValue() * this.logic.invColumns;
        this.lastSlotId = Math.min(this.chestSlotCount, this.firstSlotId + this.getDisplayedRows() * this.logic.invColumns);
        for (Object o : this.field_147002_h.field_75151_b) {
            if (!(o instanceof ChestSlot)) continue;
            ChestSlot slot = (ChestSlot)((Object)o);
            if (this.shouldDrawSlot(slot)) {
                slot.enable();
                int offset = slot.getVisualIndex() - this.firstSlotId;
                int x = offset % this.logic.invColumns * CraftingStationGui.slotElement.w;
                int y = offset / this.logic.invColumns * CraftingStationGui.slotElement.h;
                slot.field_75223_e = x + xOffset + 1;
                slot.field_75221_f = y + yOffset + 1;
                continue;
            }
            slot.disable();
            slot.field_75223_e = 0;
            slot.field_75221_f = 0;
        }
    }

    protected void drawChestSlots(int xPos, int yPos) {
        int y;
        if (!this.hasChest()) {
            return;
        }
        int width = this.logic.invColumns * CraftingStationGui.slotElement.w;
        int height = this.chestHeight - this.border.h * 2;
        int fullRows = (this.lastSlotId - this.firstSlotId) / this.logic.invColumns;
        int slotsLeft = (this.lastSlotId - this.firstSlotId) % this.logic.invColumns;
        for (y = 0; y < fullRows * CraftingStationGui.slotElement.h && y < height; y += CraftingStationGui.slotElement.h) {
            slotElement.drawScaledX(xPos, yPos + y, width);
        }
        if (slotsLeft > 0) {
            slotElement.drawScaledX(xPos, yPos + y, slotsLeft * CraftingStationGui.slotElement.w);
            slotEmptyElement.drawScaledX(xPos + slotsLeft * CraftingStationGui.slotElement.w, yPos + y, width - slotsLeft * CraftingStationGui.slotElement.w);
        }
    }
}

