/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.weaponry;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Map;
import java.util.Random;
import mantle.pulsar.pulse.Handler;
import mantle.pulsar.pulse.Pulse;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.IPosition;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import tconstruct.TConstruct;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.CastingRecipe;
import tconstruct.library.crafting.FluidType;
import tconstruct.library.crafting.LiquidCasting;
import tconstruct.library.crafting.ModifyBuilder;
import tconstruct.library.crafting.PatternBuilder;
import tconstruct.library.crafting.Smeltery;
import tconstruct.library.crafting.StencilBuilder;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.entity.ProjectileBase;
import tconstruct.library.tools.DualMaterialToolPart;
import tconstruct.library.tools.DynamicToolPart;
import tconstruct.library.tools.FletchlingLeafMaterial;
import tconstruct.library.util.BehaviorProjectileBaseDispense;
import tconstruct.library.util.IPattern;
import tconstruct.library.util.IToolPart;
import tconstruct.library.weaponry.AmmoItem;
import tconstruct.library.weaponry.AmmoWeapon;
import tconstruct.library.weaponry.ArrowShaftMaterial;
import tconstruct.library.weaponry.ProjectileWeapon;
import tconstruct.modifiers.tools.ModAmmoRestock;
import tconstruct.modifiers.tools.ModAttack;
import tconstruct.modifiers.tools.ModWindup;
import tconstruct.smeltery.TinkerSmeltery;
import tconstruct.tools.TinkerTools;
import tconstruct.tools.items.Bowstring;
import tconstruct.tools.items.Fletching;
import tconstruct.tools.items.Pattern;
import tconstruct.util.config.PHConstruct;
import tconstruct.weaponry.AlternateBoltRecipe;
import tconstruct.weaponry.WeaponryActiveToolMod;
import tconstruct.weaponry.WeaponryCommonProxy;
import tconstruct.weaponry.WeaponryHandler;
import tconstruct.weaponry.ammo.ArrowAmmo;
import tconstruct.weaponry.ammo.BoltAmmo;
import tconstruct.weaponry.entity.ArrowEntity;
import tconstruct.weaponry.entity.BoltEntity;
import tconstruct.weaponry.entity.JavelinEntity;
import tconstruct.weaponry.entity.ShurikenEntity;
import tconstruct.weaponry.entity.ThrowingKnifeEntity;
import tconstruct.weaponry.items.Boneana;
import tconstruct.weaponry.items.GlassArrows;
import tconstruct.weaponry.items.WeaponryPattern;
import tconstruct.weaponry.items.WeaponryPatternClay;
import tconstruct.weaponry.weapons.Crossbow;
import tconstruct.weaponry.weapons.Javelin;
import tconstruct.weaponry.weapons.LongBow;
import tconstruct.weaponry.weapons.ShortBow;
import tconstruct.weaponry.weapons.Shuriken;
import tconstruct.weaponry.weapons.ThrowingKnife;
import tconstruct.world.TinkerWorld;

@GameRegistry.ObjectHolder(value="TConstruct")
@Pulse(id="Tinkers' Weaponry", description="The main core of the mod! All of the tools, the tables, and the patterns are here.", pulsesRequired="Tinkers' Tools")
public class TinkerWeaponry {
    @SidedProxy(clientSide="tconstruct.weaponry.WeaponryClientProxy", serverSide="tconstruct.weaponry.WeaponryCommonProxy")
    public static WeaponryCommonProxy proxy;
    public static AmmoWeapon shuriken;
    public static AmmoWeapon throwingknife;
    public static AmmoWeapon javelin;
    public static ProjectileWeapon shortbow;
    public static ProjectileWeapon longbow;
    public static ProjectileWeapon crossbow;
    public static AmmoItem arrowAmmo;
    public static AmmoItem boltAmmo;
    public static ItemStack creativeBolt;
    public static Item bowstring;
    public static DynamicToolPart arrowhead;
    public static Item fletching;
    public static DynamicToolPart partShuriken;
    public static DynamicToolPart partArrowShaft;
    public static DynamicToolPart partBowLimb;
    public static DynamicToolPart partCrossbowLimb;
    public static DynamicToolPart partCrossbowBody;
    public static DualMaterialToolPart partBolt;
    public static Pattern woodPattern;
    public static Pattern metalPattern;
    public static Pattern clayPattern;
    public static GlassArrows glassArrows;
    public static Boneana boneana;
    public static ModAttack modAttack;
    public static Random random;
    public static Item[] patternOutputs;

    @Handler
    public void preInit(FMLPreInitializationEvent event) {
        this.registerItems();
        this.registerLegendaries();
        this.registerMaterials();
    }

    @Handler
    public void init(FMLInitializationEvent event) {
        this.addPartRecipies();
        this.addWeaponRecipies();
        this.setupCreativeTab();
        ItemStack redstoneItem = new ItemStack(Items.field_151137_ax);
        ItemStack redstoneBlock = new ItemStack(Blocks.field_150451_bX);
        ModifyBuilder.registerModifier(new ModWindup(2, new ItemStack[]{redstoneItem, redstoneBlock}, new int[]{1, 9}));
        ModifyBuilder.registerModifier(new ModAmmoRestock());
        modAttack = new ModAttack("Quartz", 11, new ItemStack[]{new ItemStack(Items.field_151128_bU), new ItemStack(Blocks.field_150371_ca, 1, Short.MAX_VALUE)}, new int[]{1, 4}, true);
        ModifyBuilder.registerModifier(modAttack);
        TConstructRegistry.registerActiveToolMod(new WeaponryActiveToolMod());
        this.registerDispenserProjectiles();
    }

    @Handler
    public void postInit(FMLPostInitializationEvent event) {
        WeaponryHandler weaponryHandler = new WeaponryHandler();
        MinecraftForge.EVENT_BUS.register((Object)weaponryHandler);
        FMLCommonHandler.instance().bus().register((Object)weaponryHandler);
        ItemStack headStack = DualMaterialToolPart.createDualMaterial(boltAmmo.getHeadItem(), 0, 2);
        ItemStack handleStack = new ItemStack(boltAmmo.getAccessoryItem(), 1, 0);
        ItemStack tool = ToolBuilder.instance.buildTool(headStack, handleStack, null, null, "");
        if (tool != null) {
            tool.func_77978_p().func_74775_l("InfiTool").func_74757_a("Built", true);
            creativeBolt = tool;
        } else {
            TConstruct.logger.error("Couldn't build basic Tinker Bolt for creative crossbow shootnig");
        }
        proxy.init();
        this.registerBoltCasting();
    }

    private void registerItems() {
        TinkerTools.bowstring = bowstring = new Bowstring().func_77655_b("tconstruct.Bowstring");
        arrowhead = new DynamicToolPart("_arrowhead", "ArrowHead");
        TinkerTools.arrowhead = arrowhead;
        TinkerTools.fletching = fletching = new Fletching().func_77655_b("tconstruct.Fletching");
        partShuriken = new DynamicToolPart("_shuriken", "Shuriken");
        partArrowShaft = new DynamicToolPart("_arrow_shaft", "Shaft", ArrowShaftMaterial.class);
        partBowLimb = new DynamicToolPart("_bow_limb", "BowLimb");
        partCrossbowLimb = new DynamicToolPart("_crossbow_limb", "CrossbowLimb");
        partCrossbowBody = new DynamicToolPart("_crossbow_body", "CrossbowBody");
        partBolt = new DualMaterialToolPart("_bolt", "Bolt");
        shuriken = new Shuriken();
        throwingknife = new ThrowingKnife();
        javelin = new Javelin();
        shortbow = new ShortBow();
        TinkerTools.shortbow = shortbow;
        longbow = new LongBow();
        crossbow = new Crossbow();
        arrowAmmo = new ArrowAmmo();
        boltAmmo = new BoltAmmo();
        woodPattern = new WeaponryPattern("pattern_", "Pattern");
        metalPattern = new WeaponryPattern("cast_", "MetalPattern");
        clayPattern = new WeaponryPatternClay("clay_cast_", "ClayPattern");
        GameRegistry.registerItem((Item)bowstring, (String)"bowstring");
        GameRegistry.registerItem((Item)arrowhead, (String)"arrowhead");
        GameRegistry.registerItem((Item)fletching, (String)"fletching");
        GameRegistry.registerItem((Item)partShuriken, (String)"ShurikenPart");
        GameRegistry.registerItem((Item)partBowLimb, (String)"BowLimbPart");
        GameRegistry.registerItem((Item)partCrossbowLimb, (String)"CrossbowLimbPart");
        GameRegistry.registerItem((Item)partCrossbowBody, (String)"CrossbowBodyPart");
        GameRegistry.registerItem((Item)partBolt, (String)"BoltPart");
        GameRegistry.registerItem((Item)shuriken, (String)"Shuriken");
        GameRegistry.registerItem((Item)throwingknife, (String)"ThrowingKnife");
        GameRegistry.registerItem((Item)javelin, (String)"Javelin");
        GameRegistry.registerItem((Item)shortbow, (String)"ShortBow");
        GameRegistry.registerItem((Item)longbow, (String)"LongBow");
        GameRegistry.registerItem((Item)crossbow, (String)"Crossbow");
        GameRegistry.registerItem((Item)arrowAmmo, (String)"ArrowAmmo");
        GameRegistry.registerItem((Item)boltAmmo, (String)"BoltAmmo");
        GameRegistry.registerItem((Item)woodPattern, (String)"Pattern");
        GameRegistry.registerItem((Item)metalPattern, (String)"Cast");
        GameRegistry.registerItem((Item)clayPattern, (String)"Clay Cast");
    }

    private void addPartRecipies() {
        int n;
        int m;
        StencilBuilder.registerStencil(21, TinkerTools.woodPattern, 25);
        StencilBuilder.registerStencil(22, TinkerTools.woodPattern, 24);
        StencilBuilder.registerStencil(23, TinkerTools.woodPattern, 23);
        StencilBuilder.registerStencil(24, (Item)woodPattern, 0);
        StencilBuilder.registerStencil(25, (Item)woodPattern, 1);
        StencilBuilder.registerStencil(26, (Item)woodPattern, 2);
        StencilBuilder.registerStencil(27, (Item)woodPattern, 3);
        PatternBuilder.instance.addToolPattern(woodPattern);
        int[] nonMetals = new int[]{0, 1, 3, 4, 5, 6, 7, 8, 9, 17};
        int[] liquidDamage = new int[]{2, 13, 10, 11, 12, 14, 15, 6, 16, 18};
        patternOutputs = new Item[]{partShuriken, partCrossbowLimb, partCrossbowBody, partBowLimb};
        if (PHConstruct.craftMetalTools) {
            for (m = 0; m < patternOutputs.length; ++m) {
                for (int i = 0; i < 18; ++i) {
                    TConstructRegistry.addPartMapping((Item)woodPattern, m, i, new ItemStack(patternOutputs[m], 1, i));
                }
            }
        } else {
            for (m = 0; m < patternOutputs.length; ++m) {
                int[] i = nonMetals;
                n = i.length;
                for (int j = 0; j < n; ++j) {
                    int nonMetal = i[j];
                    TConstructRegistry.addPartMapping((Item)woodPattern, m, nonMetal, new ItemStack(patternOutputs[m], 1, nonMetal));
                }
            }
        }
        int[] m2 = nonMetals;
        int i = m2.length;
        for (n = 0; n < i; ++n) {
            int nonMetal = m2[n];
            TConstructRegistry.addPartMapping(TinkerTools.woodPattern, 25, nonMetal, new ItemStack((Item)arrowhead, 1, nonMetal));
        }
        if (TConstruct.pulsar.isPulseLoaded("Tinkers' Smeltery")) {
            LiquidCasting tableCasting = TConstructRegistry.getTableCasting();
            for (i = 0; i < patternOutputs.length; ++i) {
                ItemStack cast = new ItemStack((Item)metalPattern, 1, i);
                ItemStack clay_cast = new ItemStack((Item)clayPattern, 1, i);
                tableCasting.addCastingRecipe(cast, new FluidStack(TinkerSmeltery.moltenAlubrassFluid, 144), new ItemStack(patternOutputs[i], 1, Short.MAX_VALUE), false, 50);
                if (!PHConstruct.removeGoldCastRecipes) {
                    tableCasting.addCastingRecipe(cast, new FluidStack(TinkerSmeltery.moltenGoldFluid, 288), new ItemStack(patternOutputs[i], 1, Short.MAX_VALUE), false, 50);
                }
                for (int iterTwo = 0; iterTwo < TinkerSmeltery.liquids.length; ++iterTwo) {
                    Fluid fs = TinkerSmeltery.liquids[iterTwo].getFluid();
                    int fluidAmount = metalPattern.getPatternCost(cast) * 144 / 2;
                    ItemStack metalCast = new ItemStack(patternOutputs[i], 1, liquidDamage[iterTwo]);
                    tableCasting.addCastingRecipe(metalCast, new FluidStack(fs, fluidAmount), cast, 50);
                    Smeltery.addMelting(FluidType.getFluidType(fs), metalCast, 0, fluidAmount);
                }
            }
            for (int iterTwo = 0; iterTwo < TinkerSmeltery.liquids.length; ++iterTwo) {
                Fluid fs = TinkerSmeltery.liquids[iterTwo].getFluid();
                ItemStack clay_cast = new ItemStack((Item)clayPattern, 1, 3);
                int fluidAmount = clayPattern.getPatternCost(clay_cast) * 144 / 2;
                tableCasting.addCastingRecipe(new ItemStack(patternOutputs[3], 1, liquidDamage[iterTwo]), new FluidStack(fs, fluidAmount), clay_cast, true, 50);
            }
            ItemStack cast = new ItemStack(TinkerSmeltery.metalPattern, 1, 25);
            ItemStack clay_cast = new ItemStack(TinkerSmeltery.clayPattern, 1, 25);
            tableCasting.addCastingRecipe(cast, new FluidStack(TinkerSmeltery.moltenAlubrassFluid, 144), new ItemStack((Item)arrowhead, 1, Short.MAX_VALUE), false, 50);
            if (!PHConstruct.removeGoldCastRecipes) {
                tableCasting.addCastingRecipe(cast, new FluidStack(TinkerSmeltery.moltenGoldFluid, 288), new ItemStack((Item)arrowhead, 1, Short.MAX_VALUE), false, 50);
            }
            for (int iterTwo = 0; iterTwo < TinkerSmeltery.liquids.length; ++iterTwo) {
                Fluid fs = TinkerSmeltery.liquids[iterTwo].getFluid();
                int fluidAmount = ((IPattern)TinkerSmeltery.metalPattern).getPatternCost(cast) * 144 / 2;
                ItemStack metalCast = new ItemStack((Item)arrowhead, 1, liquidDamage[iterTwo]);
                tableCasting.addCastingRecipe(metalCast, new FluidStack(fs, fluidAmount), cast, 50);
                tableCasting.addCastingRecipe(metalCast, new FluidStack(fs, fluidAmount), clay_cast, true, 50);
                Smeltery.addMelting(FluidType.getFluidType(fs), metalCast, 0, fluidAmount);
            }
            FluidType stone = FluidType.getFluidType("Stone");
            for (int sc = 0; sc < patternOutputs.length; ++sc) {
                if (patternOutputs[sc] == null) continue;
                ItemStack item = new ItemStack(patternOutputs[sc], 1, 1);
                int amount = 8 * woodPattern.getPatternCost(new ItemStack((Item)woodPattern, 1, sc)) / 2;
                Smeltery.addMelting(stone, item, 1, amount);
            }
        }
    }

    private void registerLegendaries() {
        glassArrows = new GlassArrows();
        boneana = new Boneana();
        GameRegistry.registerItem((Item)glassArrows, (String)"GlassArrows");
        GameRegistry.registerItem((Item)boneana, (String)"Boneana");
    }

    private void registerMaterials() {
        TConstructRegistry.addBowMaterial(0, 18, 3.0f);
        TConstructRegistry.addBowMaterial(4, 20, 3.4f);
        TConstructRegistry.addBowMaterial(5, 38, 3.0f);
        TConstructRegistry.addBowMaterial(8, 28, 4.2f);
        TConstructRegistry.addBowMaterial(17, 21, 4.0f);
        TConstructRegistry.addBowMaterial(9, 10, 1.1f);
        TConstructRegistry.addBowMaterial(2, 54, 5.2f);
        TConstructRegistry.addBowMaterial(16, 60, 5.5f);
        TConstructRegistry.addBowMaterial(18, 42, 5.2f);
        TConstructRegistry.addBowMaterial(11, 55, 4.9f);
        TConstructRegistry.addBowMaterial(10, 45, 5.3f);
        TConstructRegistry.addBowMaterial(12, 50, 5.0f);
        TConstructRegistry.addBowMaterial(13, 40, 4.9f);
        TConstructRegistry.addBowMaterial(14, 45, 5.1f);
        TConstructRegistry.addBowMaterial(15, 45, 5.0f);
        TConstructRegistry.addBowMaterial(1, 90, 1.0f);
        TConstructRegistry.addBowMaterial(3, 90, 1.0f);
        TConstructRegistry.addBowMaterial(6, 109, 1.0f);
        TConstructRegistry.addBowMaterial(7, 80, 1.0f);
        TConstructRegistry.addArrowMaterial(0, 0.69f, 0.5f);
        TConstructRegistry.addArrowMaterial(1, 2.05f, 1.0f);
        TConstructRegistry.addArrowMaterial(2, 3.3f, 0.8f);
        TConstructRegistry.addArrowMaterial(3, 1.325f, 1.0f);
        TConstructRegistry.addArrowMaterial(4, 0.76f, 1.0f);
        TConstructRegistry.addArrowMaterial(5, 1.69f, 1.0f);
        TConstructRegistry.addArrowMaterial(6, 2.4f, 1.0f);
        TConstructRegistry.addArrowMaterial(7, 1.5f, 1.3f);
        TConstructRegistry.addArrowMaterial(8, 0.22f, 0.0f);
        TConstructRegistry.addArrowMaterial(9, 0.69f, 10.0f);
        TConstructRegistry.addArrowMaterial(10, 3.0f, 2.0f);
        TConstructRegistry.addArrowMaterial(11, 1.25f, 2.0f);
        TConstructRegistry.addArrowMaterial(12, 2.25f, 1.0f);
        TConstructRegistry.addArrowMaterial(13, 2.7f, 1.1f);
        TConstructRegistry.addArrowMaterial(14, 3.2f, 1.2f);
        TConstructRegistry.addArrowMaterial(15, 1.1f, 0.7f);
        TConstructRegistry.addArrowMaterial(16, 3.6f, 0.9f);
        TConstructRegistry.addArrowMaterial(17, 0.22f, 0.0f);
        TConstructRegistry.addArrowMaterial(18, 3.0f, 0.5f);
        TConstructRegistry.addCustomMaterial(ArrowShaftMaterial.createMaterial(0, Items.field_151055_y, 1.0f, 1.0f, 0.15f, 8807718));
        TConstructRegistry.addCustomMaterial(ArrowShaftMaterial.createMaterial(1, Items.field_151103_aS, 0.95f, 1.8f, 0.02f, 15591103));
        TConstructRegistry.addCustomMaterial(ArrowShaftMaterial.createMaterial(2, Items.field_151120_aE, 1.5f, 0.5f, 0.66f, 13107079));
        TConstructRegistry.addCustomMaterial(ArrowShaftMaterial.createMaterial(3, Items.field_151072_bj, 1.2f, 0.9f, 0.08f, 16773933));
        TConstructRegistry.addCustomMaterial(ArrowShaftMaterial.createMaterial(0, TinkerTools.toolRod, 0, 1.0f, 1.0f, 0.15f, 8807718));
        TConstructRegistry.addCustomMaterial(ArrowShaftMaterial.createMaterial(1, TinkerTools.toolRod, 5, 0.95f, 1.8f, 0.02f, 15591103));
        TConstructRegistry.addFletchingMaterial(0, 2, new ItemStack(Items.field_151008_G), new ItemStack(fletching, 1, 0), 95.0f, 0.05f, 1.0f, 0xFFFFFF);
        TConstructRegistry.addCustomMaterial(new FletchlingLeafMaterial(1, 2, "treeLeaves", new ItemStack(fletching, 1, 1), 75.0f, 0.0f, 2.5f));
        TConstructRegistry.addFletchingMaterial(2, 2, new ItemStack(TinkerTools.materials, 1, 1), new ItemStack(fletching, 1, 2), 100.0f, 0.005f, 0.8f, 8570995);
        TConstructRegistry.addFletchingMaterial(3, 2, new ItemStack(TinkerTools.materials, 1, 17), new ItemStack(fletching, 1, 3), 100.0f, 0.005f, 0.8f, 7653575);
        TConstructRegistry.addFletchingMaterial(4, 2, new ItemStack((Block)TinkerWorld.slimeLeaves, 1, 0), new ItemStack(fletching, 1, 4), 98.0f, 0.02f, 1.4f, 7661767);
        TConstructRegistry.addBowstringMaterial(0, 2, new ItemStack(Items.field_151007_F), new ItemStack(bowstring, 1, 0), 1.0f, 1.0f, 1.0f, 0xEEEEEE);
    }

    private void addWeaponRecipies() {
        TConstructRegistry.addToolRecipe(shuriken, new Item[]{partShuriken, partShuriken, partShuriken, partShuriken});
        TConstructRegistry.addToolRecipe(throwingknife, TinkerTools.knifeBlade, TinkerTools.toolRod);
        TConstructRegistry.addToolRecipe(javelin, new Item[]{arrowhead, TinkerTools.toughRod, TinkerTools.toughRod});
        TConstructRegistry.addToolRecipe(shortbow, new Item[]{partBowLimb, bowstring, partBowLimb});
        TConstructRegistry.addToolRecipe(longbow, new Item[]{partBowLimb, bowstring, partBowLimb, TinkerTools.largePlate});
        TConstructRegistry.addToolRecipe(crossbow, new Item[]{partCrossbowLimb, partCrossbowBody, bowstring, TinkerTools.toughBinding});
        TConstructRegistry.addToolRecipe(arrowAmmo, new Item[]{arrowhead, partArrowShaft, fletching});
        TConstructRegistry.addToolRecipe(boltAmmo, new Item[]{partBolt, partBolt, fletching});
    }

    private void registerBoltCasting() {
        if (PHConstruct.alternativeBoltRecipe) {
            GameRegistry.addRecipe((IRecipe)new AlternateBoltRecipe());
        }
        LiquidCasting tb = TConstructRegistry.getTableCasting();
        for (Map.Entry<String, FluidType> entry : FluidType.fluidTypes.entrySet()) {
            FluidStack liquid;
            CastingRecipe recipe;
            if (!entry.getValue().isToolpart || (recipe = tb.getCastingRecipe(liquid = new FluidStack(entry.getValue().fluid, 144), new ItemStack(TinkerSmeltery.metalPattern, 1, 2))) == null) continue;
            int matID = recipe.getResult().func_77960_j();
            for (Integer id : TConstructRegistry.toolMaterials.keySet()) {
                ItemStack rod = new ItemStack(TinkerTools.toolRod, 1, id.intValue());
                if (((IToolPart)TinkerTools.toolRod).getMaterialID(rod) == -1) continue;
                tb.addCastingRecipe(DualMaterialToolPart.createDualMaterial((Item)partBolt, id, matID), liquid, rod, true, 150);
            }
        }
    }

    private void setupCreativeTab() {
        ItemStack tool = new ItemStack((Item)longbow, 1, 0);
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("InfiTool", (NBTBase)new NBTTagCompound());
        compound.func_74775_l("InfiTool").func_74768_a("RenderHead", 0);
        compound.func_74775_l("InfiTool").func_74768_a("RenderHandle", 0);
        compound.func_74775_l("InfiTool").func_74768_a("RenderAccessory", 0);
        compound.func_74775_l("InfiTool").func_74768_a("RenderExtra", 1);
        tool.func_77982_d(compound);
        TConstructRegistry.weaponryTab.init(tool);
    }

    private void registerDispenserProjectiles() {
        BlockDispenser.field_149943_a.func_82595_a((Object)shuriken, (Object)new BehaviorProjectileBaseDispense(){

            @Override
            protected ProjectileBase getProjectileEntity(World world, IPosition position, ItemStack stack) {
                return new ShurikenEntity(world, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
            }

            @Override
            protected float ballistic() {
                return 0.0f;
            }
        });
        BlockDispenser.field_149943_a.func_82595_a((Object)throwingknife, (Object)new BehaviorProjectileBaseDispense(){

            @Override
            protected ProjectileBase getProjectileEntity(World world, IPosition position, ItemStack stack) {
                return new ThrowingKnifeEntity(world, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
            }
        });
        BlockDispenser.field_149943_a.func_82595_a((Object)javelin, (Object)new BehaviorProjectileBaseDispense(){

            @Override
            protected ProjectileBase getProjectileEntity(World world, IPosition position, ItemStack stack) {
                return new JavelinEntity(world, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
            }
        });
        BlockDispenser.field_149943_a.func_82595_a((Object)arrowAmmo, (Object)new BehaviorProjectileBaseDispense(){

            @Override
            protected ProjectileBase getProjectileEntity(World world, IPosition position, ItemStack stack) {
                return new ArrowEntity(world, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
            }
        });
        BlockDispenser.field_149943_a.func_82595_a((Object)boltAmmo, (Object)new BehaviorProjectileBaseDispense(){

            @Override
            protected ProjectileBase getProjectileEntity(World world, IPosition position, ItemStack stack) {
                return new BoltEntity(world, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
            }
        });
    }

    static {
        random = new Random();
    }
}

