/*
 * Decompiled with CFR 0.152.
 */
package vexatos.tgregworks.integration.iguanatweakstconstruct;

import iguanaman.iguanatweakstconstruct.leveling.LevelingLogic;
import iguanaman.iguanatweakstconstruct.reference.Config;
import iguanaman.iguanatweakstconstruct.replacing.ReplacementLogic;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.crafting.ToolRecipe;
import tconstruct.library.modifier.ItemModifier;
import tconstruct.library.tools.DualMaterialToolPart;
import tconstruct.library.tools.DynamicToolPart;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.util.IToolPart;
import tconstruct.tools.TinkerTools;
import tconstruct.weaponry.TinkerWeaponry;
import vexatos.tgregworks.integration.recipe.tconstruct.TGregToolRecipe;

public class ModTGregPartReplacement
extends ItemModifier {
    public ModTGregPartReplacement() {
        super(new ItemStack[0], 0, "");
    }

    public boolean matches(ItemStack[] recipe, ItemStack input) {
        return this.canModify(input, recipe);
    }

    protected boolean canModify(ItemStack itemStack, ItemStack[] parts) {
        ToolRecipe recipe;
        if (!(itemStack.func_77973_b() instanceof ToolCore)) {
            return false;
        }
        ToolCore tool = (ToolCore)itemStack.func_77973_b();
        NBTTagCompound tags = itemStack.func_77978_p().func_74775_l("InfiTool");
        if (tags.func_74767_n("Special")) {
            return false;
        }
        if (tags.func_74762_e("Damage") > 0) {
            return false;
        }
        if (Config.disableStoneTools) {
            if (tool.getHeadItem() != null && ReplacementLogic.getToolPartMaterial((NBTTagCompound)tags, (ReplacementLogic.PartTypes)ReplacementLogic.PartTypes.HEAD) == 1) {
                return false;
            }
            if (tool.getHandleItem() != null && ReplacementLogic.getToolPartMaterial((NBTTagCompound)tags, (ReplacementLogic.PartTypes)ReplacementLogic.PartTypes.HANDLE) == 1 && tool.getHandleItem() != TinkerWeaponry.bowstring && tool.getHandleItem() != TinkerWeaponry.partArrowShaft) {
                return false;
            }
            if (tool.getAccessoryItem() != null && ReplacementLogic.getToolPartMaterial((NBTTagCompound)tags, (ReplacementLogic.PartTypes)ReplacementLogic.PartTypes.ACCESSORY) == 1 && tool.getAccessoryItem() != TinkerWeaponry.bowstring && tool.getAccessoryItem() != TinkerWeaponry.fletching) {
                return false;
            }
            if (tool.getExtraItem() != null && ReplacementLogic.getToolPartMaterial((NBTTagCompound)tags, (ReplacementLogic.PartTypes)ReplacementLogic.PartTypes.EXTRA) == 1) {
                return false;
            }
        }
        if ((recipe = this.findRecipe(tool)) == null) {
            return false;
        }
        Item replacementPartItem = null;
        int partIndex = -1;
        ReplacementLogic.PartTypes partType = null;
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i] == null) continue;
            Item item = parts[i].func_77973_b();
            if (tool == TinkerWeaponry.arrowAmmo && (item == Items.field_151120_aE || item == Items.field_151072_bj || item == Items.field_151103_aS || item == Items.field_151055_y)) {
                item = TinkerWeaponry.partArrowShaft;
            }
            if (item == Items.field_151103_aS || item == Items.field_151055_y) {
                item = TinkerTools.toolRod;
            }
            if (!(item instanceof IToolPart)) {
                return false;
            }
            if (replacementPartItem != null) {
                return false;
            }
            if (recipe.validHead(item)) {
                partType = ReplacementLogic.PartTypes.HEAD;
            } else if (recipe.validHandle(item)) {
                partType = ReplacementLogic.PartTypes.HANDLE;
            } else if (recipe.validAccessory(item)) {
                partType = ReplacementLogic.PartTypes.ACCESSORY;
            } else if (recipe.validExtra(item)) {
                partType = ReplacementLogic.PartTypes.EXTRA;
            } else {
                return false;
            }
            replacementPartItem = item;
            partIndex = i;
        }
        if (replacementPartItem == null) {
            return false;
        }
        if (partIndex == -1) {
            return false;
        }
        int newMatId = ToolBuilder.instance.getMaterialID(parts[partIndex]);
        int oldMatId = ReplacementLogic.getToolPartMaterial((NBTTagCompound)tags, partType);
        int modifiers = tags.func_74762_e("Modifiers");
        for (int i = partIndex; i > 0; --i) {
            partType = ReplacementLogic.detectAdditionalPartType((ToolRecipe)recipe, replacementPartItem, partType);
            oldMatId = ReplacementLogic.getToolPartMaterial((NBTTagCompound)tags, (ReplacementLogic.PartTypes)partType);
        }
        if (partType == ReplacementLogic.PartTypes.HEAD && TConstructRegistry.getMaterial((int)newMatId).harvestLevel == 0 && LevelingLogic.hasBoostXp((NBTTagCompound)tags)) {
            return false;
        }
        if (ReplacementLogic.hasExtraModifier((int)oldMatId)) {
            --modifiers;
        }
        if (ReplacementLogic.hasExtraModifier((int)newMatId)) {
            ++modifiers;
        }
        if (modifiers < 0) {
            return false;
        }
        if (newMatId == oldMatId) {
            if (tool == TinkerWeaponry.boltAmmo && replacementPartItem instanceof DualMaterialToolPart) {
                int oldHeadMatId;
                int newHeadMatId = ((DualMaterialToolPart)replacementPartItem).getMaterialID2(parts[partIndex]);
                return newHeadMatId != (oldHeadMatId = ReplacementLogic.getToolPartMaterial((NBTTagCompound)tags, (ReplacementLogic.PartTypes)ReplacementLogic.PartTypes.HEAD));
            }
            return false;
        }
        return true;
    }

    public void modify(ItemStack[] parts, ItemStack itemStack) {
        ToolCore tool = (ToolCore)itemStack.func_77973_b();
        ToolRecipe recipe = this.findRecipe(tool);
        NBTTagCompound tags = itemStack.func_77978_p().func_74775_l("InfiTool");
        DynamicToolPart replacementPartItem = null;
        int partIndex = -1;
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i] == null) continue;
            replacementPartItem = parts[i].func_77973_b();
            partIndex = i;
        }
        if (tool == TinkerWeaponry.arrowAmmo && (replacementPartItem == Items.field_151120_aE || replacementPartItem == Items.field_151072_bj || replacementPartItem == Items.field_151103_aS || replacementPartItem == Items.field_151055_y)) {
            replacementPartItem = TinkerWeaponry.partArrowShaft;
        }
        if (replacementPartItem == Items.field_151103_aS || replacementPartItem == Items.field_151055_y) {
            replacementPartItem = TinkerTools.toolRod;
        }
        ReplacementLogic.PartTypes partType = ReplacementLogic.detectAdditionalPartType((ToolRecipe)recipe, (Item)replacementPartItem, null);
        for (int i = partIndex; i > 0; --i) {
            partType = ReplacementLogic.detectAdditionalPartType((ToolRecipe)recipe, (Item)replacementPartItem, (ReplacementLogic.PartTypes)partType);
        }
        ReplacementLogic.exchangeToolPart((ToolCore)tool, (NBTTagCompound)tags, (ReplacementLogic.PartTypes)partType, (ItemStack)parts[partIndex], (ItemStack)itemStack);
    }

    private ToolRecipe findRecipe(ToolCore tool) {
        for (ToolRecipe r : ToolBuilder.instance.combos) {
            if (!(r instanceof TGregToolRecipe) || !r.getType().getClass().equals(tool.getClass())) continue;
            return r;
        }
        return null;
    }

    public void addMatchingEffect(ItemStack input) {
    }
}

