/*
 * Decompiled with CFR 0.152.
 */
package taintedmagic.common.items.wand.foci;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import taintedmagic.common.TaintedMagic;
import taintedmagic.common.handler.ConfigHandler;
import taintedmagic.common.helper.TaintedMagicHelper;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;

public class ItemFocusMageMace
extends ItemFocusBasic {
    public IIcon depthIcon = null;
    public IIcon ornIcon = null;
    public static FocusUpgradeType bloodlust = new FocusUpgradeType(58, new ResourceLocation("taintedmagic", "textures/foci/IconBloodlust.png"), "focus.upgrade.bloodlust.name", "focus.upgrade.bloodlust.text", new AspectList().add(Aspect.WEAPON, 1).add(Aspect.HEAL, 1));
    public final AspectList mageMaceCostBase = new AspectList().add(Aspect.EARTH, 220).add(Aspect.ENTROPY, 220).add(Aspect.ORDER, 180);
    public final AspectList mageMAceCostBloodlust = this.mageMaceCostBase.copy().add(Aspect.FIRE, 160);

    public ItemFocusMageMace() {
        this.func_77637_a(TaintedMagic.tabTaintedMagic);
        this.func_77655_b("ItemFocusMageMace");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.icon = ir.func_94245_a("taintedmagic:ItemFocusMageMace");
        this.depthIcon = ir.func_94245_a("taintedmagic:ItemFocusMageMace_depth");
        this.ornIcon = ir.func_94245_a("taintedmagic:ItemFocusMageMace_orn");
    }

    public IIcon getFocusDepthLayerIcon(ItemStack stack) {
        return this.depthIcon;
    }

    public IIcon getOrnament(ItemStack stack) {
        return this.ornIcon;
    }

    public String getSortingHelper(ItemStack stack) {
        return "MACE" + super.getSortingHelper(stack);
    }

    public int getFocusColor(ItemStack stack) {
        return 0x323232;
    }

    public AspectList getVisCost(ItemStack stack) {
        return this.isUpgradedWith(stack, bloodlust) ? this.mageMAceCostBloodlust : this.mageMaceCostBase;
    }

    public int getActivationCooldown(ItemStack stack) {
        return -1;
    }

    public boolean isVisCostPerTick(ItemStack stack) {
        return false;
    }

    public ItemFocusBasic.WandFocusAnimation getAnimation(ItemStack stack) {
        return ItemFocusBasic.WandFocusAnimation.WAVE;
    }

    public ItemStack onFocusRightClick(ItemStack stack, World world, EntityPlayer player, MovingObjectPosition mop) {
        return stack;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean b) {
        super.func_77624_a(stack, player, list, b);
        list.add("");
        list.add(EnumChatFormatting.BLUE + "+" + TaintedMagicHelper.getFocusDamageWithPotency(stack, ConfigHandler.magesMaceBaseDamage) + " " + StatCollector.func_74838_a((String)"text.attackdamageequipped"));
        if (ConfigHandler.magesMaceStaffMultiple != 1.0f) {
            list = TaintedMagicHelper.addTooltipStaffMultiplier(list, ConfigHandler.magesMaceStaffMultiple);
        }
        list.add("");
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack stack, int rank) {
        switch (rank) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 5: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, bloodlust};
            }
        }
        return null;
    }

    public boolean canApplyUpgrade(ItemStack stack, EntityPlayer player, FocusUpgradeType focusUpgradeType, int rank) {
        return !focusUpgradeType.equals((Object)bloodlust) || ThaumcraftApiHelper.isResearchComplete((String)player.func_70005_c_(), (String)"BLOODLUSTUPGRADE");
    }
}

