/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.metaTileEntity.multi.em_collider;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.compatibility.thaumcraft.elementalMatter.definitions.EMComplexAspectDefinition;
import com.github.technus.tectech.compatibility.thaumcraft.elementalMatter.definitions.EMPrimalAspectDefinition;
import com.github.technus.tectech.loader.TecTechConfig;
import com.github.technus.tectech.mechanics.elementalMatter.core.decay.EMDecayResult;
import com.github.technus.tectech.mechanics.elementalMatter.core.definitions.EMPrimitiveTemplate;
import com.github.technus.tectech.mechanics.elementalMatter.core.maps.EMDefinitionStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.maps.EMInstanceStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.EMInstanceStack;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.complex.EMAtomDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.complex.EMHadronDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.primitive.EMQuarkDefinition;
import com.github.technus.tectech.thing.block.QuantumGlassBlock;
import com.github.technus.tectech.thing.casing.TT_Container_Casings;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_InputElemental;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_OutputElemental;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.INameFunction;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.IStatusFunction;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.LedStatus;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.Parameters;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedExtendedFacingTexture;
import com.github.technus.tectech.thing.metaTileEntity.multi.em_collider.IColliderHandler;
import com.github.technus.tectech.thing.metaTileEntity.multi.em_collider.IPrimitiveColliderHandler;
import com.github.technus.tectech.util.CommonValues;
import com.github.technus.tectech.util.DoubleCount;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_EM_collider
extends GT_MetaTileEntity_MultiblockBase_EM
implements IConstructable {
    private static Textures.BlockIcons.CustomIcon ScreenOFF;
    private static Textures.BlockIcons.CustomIcon ScreenON;
    private static Textures.BlockIcons.CustomIcon ScreenON_Slave;
    private static Textures.BlockIcons.CustomIcon ScreenOFF_Slave;
    protected static final byte FUSE_MODE = 0;
    protected static final byte COLLIDE_MODE = 1;
    private static double MASS_TO_EU_INSTANT;
    private static int STARTUP_COST;
    private static int KEEPUP_COST;
    protected byte eTier = 0;
    protected EMInstanceStack stack;
    private long plasmaEnergy;
    protected boolean started = false;
    public static final HashMap<Long, IColliderHandler> FUSE_HANDLERS;
    public static final HashMap<String, IPrimitiveColliderHandler> PRIMITIVE_FUSE_HANDLERS;
    protected Parameters.Group.ParameterIn mode;
    private static final IStatusFunction<GT_MetaTileEntity_EM_collider> MODE_STATUS;
    private static final INameFunction<GT_MetaTileEntity_EM_collider> MODE_NAME;
    private static final String[] description;
    private static final IStructureDefinition<GT_MetaTileEntity_EM_collider> STRUCTURE_DEFINITION;

    private static boolean fuseAspects(EMInstanceStack in1, EMInstanceStack in2, EMInstanceStackMap out) {
        try {
            EMDefinitionStackMap defs = new EMDefinitionStackMap();
            defs.putUnifyExact(in1.getDefinition().getStackForm(1.0));
            defs.putUnifyExact(in2.getDefinition().getStackForm(1.0));
            EMComplexAspectDefinition aspect = new EMComplexAspectDefinition(defs.toImmutable_optimized_unsafe_LeavesExposedElementalTree());
            out.putUnify(new EMInstanceStack(aspect, Math.min(in1.getAmount(), in2.getAmount())));
        }
        catch (Exception e) {
            out.putUnifyAll(new EMInstanceStack[]{in1, in2});
            return true;
        }
        return false;
    }

    private static void registerSimpleAspectFuse(int classTypeStatic) {
        FUSE_HANDLERS.put((long)EMComplexAspectDefinition.getClassTypeStatic() << 16 | (long)classTypeStatic, new IColliderHandler(){

            @Override
            public void collide(EMInstanceStack in1, EMInstanceStack in2, EMInstanceStackMap out) {
                if (GT_MetaTileEntity_EM_collider.fuseAspects(in1, in2, out)) {
                    return;
                }
                if (in1.getAmount() > in2.getAmount()) {
                    out.putUnify(new EMInstanceStack(in1.getDefinition(), in1.getAmount() - in2.getAmount()));
                } else if (in2.getAmount() > in1.getAmount()) {
                    out.putUnify(new EMInstanceStack(in2.getDefinition(), in2.getAmount() - in1.getAmount()));
                }
            }

            @Override
            public byte getRequiredTier() {
                return 1;
            }
        });
    }

    private static void registerSimpleAtomFuse(int classTypeStatic) {
        FUSE_HANDLERS.put((long)EMAtomDefinition.getClassTypeStatic() << 16 | (long)classTypeStatic, new IColliderHandler(){

            @Override
            public void collide(EMInstanceStack in1, EMInstanceStack in2, EMInstanceStackMap out) {
                try {
                    EMDefinitionStackMap defs = new EMDefinitionStackMap();
                    defs.putUnifyAllExact(in1.getDefinition().getSubParticles());
                    defs.putUnifyExact(in2.getDefinition().getStackForm(1.0));
                    EMAtomDefinition atom = new EMAtomDefinition(defs.toImmutable_optimized_unsafe_LeavesExposedElementalTree());
                    out.putUnify(new EMInstanceStack(atom, Math.min(in1.getAmount(), in2.getAmount())));
                }
                catch (Exception e) {
                    out.putUnifyAll(new EMInstanceStack[]{in1, in2});
                    return;
                }
                if (in1.getAmount() > in2.getAmount()) {
                    out.putUnify(new EMInstanceStack(in1.getDefinition(), in1.getAmount() - in2.getAmount()));
                } else if (in2.getAmount() > in1.getAmount()) {
                    out.putUnify(new EMInstanceStack(in2.getDefinition(), in2.getAmount() - in1.getAmount()));
                }
            }

            @Override
            public byte getRequiredTier() {
                return 1;
            }
        });
    }

    public IStructureDefinition<GT_MetaTileEntity_EM_collider> getStructure_EM() {
        return STRUCTURE_DEFINITION;
    }

    public GT_MetaTileEntity_EM_collider(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_EM_collider(String aName) {
        super(aName);
    }

    public static void setValues(int heliumPlasmaValue) {
        double MASS_TO_EU_PARTIAL = (double)heliumPlasmaValue / 1.1238210342782341E36;
        MASS_TO_EU_INSTANT = MASS_TO_EU_PARTIAL * 20.0;
        STARTUP_COST = -heliumPlasmaValue * 10000;
        KEEPUP_COST = -heliumPlasmaValue;
    }

    protected double fuse(GT_MetaTileEntity_EM_collider partner) {
        if (partner.stack != null && this.stack != null) {
            IColliderHandler colliderHandler;
            boolean check = this.stack.getDefinition().fusionMakesEnergy(this.stack.getEnergy()) && partner.stack.getDefinition().fusionMakesEnergy(partner.stack.getEnergy());
            EMInstanceStack stack2 = partner.stack;
            double preMass = DoubleCount.add(stack2.getMass(), this.stack.getMass());
            EMInstanceStackMap map = new EMInstanceStackMap();
            if (stack2.getDefinition().getMatterMassType() > this.stack.getDefinition().getMatterMassType() ? this.handleRecipe(stack2, map, colliderHandler = FUSE_HANDLERS.get((long)(stack2.getDefinition().getMatterMassType() << 16) | (long)this.stack.getDefinition().getMatterMassType())) : this.handleRecipe(stack2, map, colliderHandler = FUSE_HANDLERS.get((long)(this.stack.getDefinition().getMatterMassType() << 16) | (long)stack2.getDefinition().getMatterMassType()))) {
                return 0.0;
            }
            for (EMInstanceStack newStack : (EMInstanceStack[])map.valuesToArray()) {
                check &= newStack.getDefinition().fusionMakesEnergy(newStack.getEnergy());
            }
            this.outputEM = new EMInstanceStackMap[]{map};
            this.stack = null;
            partner.stack = null;
            return check ? preMass - map.getMass() : Math.min(preMass - map.getMass(), 0.0);
        }
        return 0.0;
    }

    protected double collide(GT_MetaTileEntity_EM_collider partner) {
        if (partner.stack != null && this.stack != null) {
            IColliderHandler colliderHandler;
            EMInstanceStack stack2 = partner.stack;
            double preMass = stack2.getMass() + this.stack.getMass();
            EMInstanceStackMap map = new EMInstanceStackMap();
            if (stack2.getDefinition().getMatterMassType() > this.stack.getDefinition().getMatterMassType() ? this.handleRecipe(stack2, map, colliderHandler = FUSE_HANDLERS.get((long)(stack2.getDefinition().getMatterMassType() << 16) | (long)this.stack.getDefinition().getMatterMassType())) : this.handleRecipe(stack2, map, colliderHandler = FUSE_HANDLERS.get((long)(this.stack.getDefinition().getMatterMassType() << 16) | (long)stack2.getDefinition().getMatterMassType()))) {
                return 0.0;
            }
            this.outputEM = new EMInstanceStackMap[]{map};
            this.stack = null;
            partner.stack = null;
            return Math.min(preMass - map.getMass(), 0.0);
        }
        return 0.0;
    }

    private boolean handleRecipe(EMInstanceStack stack2, EMInstanceStackMap map, IColliderHandler colliderHandler) {
        if (colliderHandler == null || this.eTier < colliderHandler.getRequiredTier()) {
            map.putUnifyAll(new EMInstanceStack[]{this.stack, stack2});
            this.outputEM = new EMInstanceStackMap[]{map};
            return true;
        }
        colliderHandler.collide(stack2, this.stack, map);
        return false;
    }

    protected GT_MetaTileEntity_EM_collider getPartner() {
        int zDir;
        int yDir;
        int xDir;
        IGregTechTileEntity iGregTechTileEntity = this.getBaseMetaTileEntity();
        IGregTechTileEntity gregTechBaseTileEntity = iGregTechTileEntity.getIGregTechTileEntityOffset(xDir = iGregTechTileEntity.getBackFacing().offsetX * 4, yDir = iGregTechTileEntity.getBackFacing().offsetY * 4, zDir = iGregTechTileEntity.getBackFacing().offsetZ * 4);
        if (gregTechBaseTileEntity != null) {
            IMetaTileEntity gregTechMetaTileEntity = gregTechBaseTileEntity.getMetaTileEntity();
            return gregTechMetaTileEntity instanceof GT_MetaTileEntity_EM_collider && ((GT_MetaTileEntity_EM_collider)gregTechMetaTileEntity).mMachine && gregTechBaseTileEntity.getBackFacing() == iGregTechTileEntity.getFrontFacing() ? (GT_MetaTileEntity_EM_collider)gregTechMetaTileEntity : null;
        }
        return null;
    }

    protected final boolean isMaster() {
        return this.getBaseMetaTileEntity().getFrontFacing().ordinal() % 2 == 0;
    }

    private void makeEU(double massDiff) {
        this.plasmaEnergy = (long)((double)this.plasmaEnergy + massDiff * MASS_TO_EU_INSTANT);
        if (TecTechConfig.DEBUG_MODE) {
            System.out.println("plasmaEnergy = " + this.plasmaEnergy);
        }
    }

    private EMInstanceStackMap tickStack() {
        if (this.stack == null) {
            return null;
        }
        this.stack.setAge(this.stack.getAge() + 1.0);
        EMDecayResult newInstances = this.stack.decay(1.0, this.stack.getAge(), 0L);
        if (newInstances == null) {
            this.stack.nextColor();
            return null;
        }
        this.stack = (EMInstanceStack)newInstances.getOutput().removeKey(((EMInstanceStack)newInstances.getOutput().getLast()).getDefinition());
        return newInstances.getOutput();
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_EM_collider(this.mName);
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        int xDir = iGregTechTileEntity.getBackFacing().offsetX * 2;
        int zDir = iGregTechTileEntity.getBackFacing().offsetZ * 2;
        if (iGregTechTileEntity.getBlockOffset(xDir, 0, zDir) != TT_Container_Casings.sBlockCasingsTT) {
            this.eTier = 0;
            return false;
        }
        if (iGregTechTileEntity.getMetaIDOffset(xDir, 0, zDir) == 8) {
            this.eTier = 1;
        } else if (iGregTechTileEntity.getMetaIDOffset(xDir, 0, zDir) == 9) {
            this.eTier = (byte)2;
        } else {
            this.eTier = 0;
            return false;
        }
        if (this.structureCheck_EM("tier" + this.eTier, 11, 1, 18)) {
            return true;
        }
        this.eTier = 0;
        return false;
    }

    @Override
    public boolean checkRecipe_EM(ItemStack itemStack) {
        GT_MetaTileEntity_EM_collider partner = this.getPartner();
        if (partner == null) {
            return false;
        }
        this.mEfficiencyIncrease = 10000;
        if (this.started) {
            if (this.stack == null) {
                for (GT_MetaTileEntity_Hatch_InputElemental inputElemental : this.eInputHatches) {
                    EMInstanceStackMap container = inputElemental.getContentHandler();
                    if (container.isEmpty()) continue;
                    this.stack = (EMInstanceStack)container.removeKey(((EMInstanceStack)container.getFirst()).getDefinition());
                    long eut = (long)KEEPUP_COST + (long)((double)KEEPUP_COST * Math.abs(this.stack.getMass() / EMAtomDefinition.getSomethingHeavy().getMass())) / 2L;
                    if (eut < -2147483641L) {
                        return false;
                    }
                    this.mMaxProgresstime = 20;
                    this.mEUt = (int)eut;
                    this.eAmpereFlow = 5L;
                    return true;
                }
                this.mMaxProgresstime = 20;
                this.mEUt = KEEPUP_COST;
                this.eAmpereFlow = 1L;
                return true;
            }
            this.mMaxProgresstime = 20;
            this.mEUt = KEEPUP_COST;
            this.eAmpereFlow = 2L;
        } else {
            this.started = true;
            this.mMaxProgresstime = 20;
            this.mEUt = STARTUP_COST;
            this.eAmpereFlow = 10L;
        }
        return true;
    }

    @Override
    public void outputAfterRecipe_EM() {
        GT_MetaTileEntity_EM_collider partner = this.getPartner();
        if (partner == null) {
            if (this.stack != null) {
                this.cleanMassEM_EM(this.stack.getMass());
                this.stack = null;
            }
            return;
        }
        if (this.isMaster()) {
            switch ((int)this.mode.get()) {
                case 0: {
                    this.makeEU(this.fuse(partner));
                    break;
                }
                case 1: {
                    this.collide(partner);
                    break;
                }
                default: {
                    this.outputEM = new EMInstanceStackMap[2];
                    this.outputEM[1] = this.tickStack();
                    if (this.outputEM[1] == null) {
                        this.outputEM[1] = partner.tickStack();
                        break;
                    }
                    EMInstanceStackMap map = partner.tickStack();
                    if (map == null) break;
                    this.outputEM[1].putUnifyAll(map);
                }
            }
            if (this.outputEM != null) {
                int lim = Math.min(this.outputEM.length, this.eOutputHatches.size());
                for (int i = 0; i < lim; ++i) {
                    if (this.outputEM[i] == null) continue;
                    ((GT_MetaTileEntity_Hatch_OutputElemental)this.eOutputHatches.get(i)).getContentHandler().putUnifyAll(this.outputEM[i]);
                    this.outputEM[i] = null;
                }
            }
        }
    }

    @Override
    public GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.collider.name")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.collider.desc.0")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.collider.desc.1")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.collider.desc.2")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.collider.desc.3")).addInfo(StatCollector.func_74838_a((String)"tt.keyword.Structure.StructureTooComplex")).addSeparator().beginStructureBlock(21, 3, 23, false).addOtherStructurePart(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.collider.name"), StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.collider.Structure.AdditionalCollider"), new int[]{2}).addOtherStructurePart(StatCollector.func_74838_a((String)"tt.keyword.Structure.ElementalInput"), StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyMolecularCasing2D"), new int[]{2}).addOtherStructurePart(StatCollector.func_74838_a((String)"tt.keyword.Structure.ElementalOutput"), StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyMolecularCasing3D"), new int[]{2}).addOtherStructurePart(StatCollector.func_74838_a((String)"tt.keyword.Structure.ElementalOverflow"), StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyMolecularCasing4D"), new int[]{2}).addEnergyHatch(StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyHighPowerCasing"), new int[]{1}).addMaintenanceHatch(StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyHighPowerCasing"), new int[]{1}).toolTipFinisher(CommonValues.TEC_MARK_EM);
        return tt;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        ScreenOFF = new Textures.BlockIcons.CustomIcon("iconsets/EM_COLLIDER");
        ScreenON = new Textures.BlockIcons.CustomIcon("iconsets/EM_COLLIDER_ACTIVE");
        ScreenOFF_Slave = new Textures.BlockIcons.CustomIcon("iconsets/EM_COLLIDER_SLAVE");
        ScreenON_Slave = new Textures.BlockIcons.CustomIcon("iconsets/EM_COLLIDER_ACTIVE_SLAVE");
        super.registerIcons(aBlockIconRegister);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (facing.ordinal() % 2 == 0) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][4], new TT_RenderedExtendedFacingTexture((IIconContainer)(aActive ? ScreenON : ScreenOFF))};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][4], new TT_RenderedExtendedFacingTexture((IIconContainer)(aActive ? ScreenON_Slave : ScreenOFF_Slave))};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][4]};
    }

    @Override
    protected void parametersInstantiation_EM() {
        Parameters.Group hatch_0 = this.parametrization.getGroup(0);
        this.mode = hatch_0.makeInParameter(0, 0.0, MODE_NAME, MODE_STATUS);
    }

    @Override
    public void parametersStatusesWrite_EM(boolean machineBusy) {
        if (this.isMaster()) {
            super.parametersStatusesWrite_EM(machineBusy);
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74774_a("eTier", this.eTier);
        aNBT.func_74757_a("eStarted", this.started);
        if (this.stack != null) {
            aNBT.func_74782_a("eStack", (NBTBase)this.stack.toNBT(TecTech.definitionsRegistry));
        }
        aNBT.func_74772_a("ePlasmaEnergy", this.plasmaEnergy);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.eTier = aNBT.func_74771_c("eTier");
        this.started = aNBT.func_74767_n("eStarted");
        if (aNBT.func_74764_b("eStack")) {
            this.stack = EMInstanceStack.fromNBT(TecTech.definitionsRegistry, aNBT.func_74775_l("eStack"));
        }
        this.plasmaEnergy = aNBT.func_74763_f("ePlasmaEnergy");
    }

    @Override
    public void stopMachine() {
        this.started = false;
        if (this.stack != null) {
            this.cleanMassEM_EM(this.stack.getMass());
            this.stack = null;
        }
        super.stopMachine();
    }

    @Override
    protected void afterRecipeCheckFailed() {
        this.started = false;
        if (this.stack != null) {
            this.cleanMassEM_EM(this.stack.getMass());
            this.stack = null;
        }
        this.getBaseMetaTileEntity().disableWorking();
        super.afterRecipeCheckFailed();
    }

    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (!aBaseMetaTileEntity.isAllowedToWork()) {
            this.started = false;
        }
        super.onPreTick(aBaseMetaTileEntity, aTick);
    }

    public void construct(ItemStack trigger, boolean hintsOnly) {
        IGregTechTileEntity iGregTechTileEntity = this.getBaseMetaTileEntity();
        int xDir = iGregTechTileEntity.getBackFacing().offsetX * 4;
        int yDir = iGregTechTileEntity.getBackFacing().offsetY * 4;
        int zDir = iGregTechTileEntity.getBackFacing().offsetZ * 4;
        if (hintsOnly) {
            StructureLibAPI.hintParticle((World)iGregTechTileEntity.getWorld(), (int)(iGregTechTileEntity.getXCoord() + xDir), (int)(iGregTechTileEntity.getYCoord() + yDir), (int)(iGregTechTileEntity.getZCoord() + zDir), (Block)StructureLibAPI.getBlockHint(), (int)12);
        }
        this.structureBuild_EM("tier" + ((trigger.field_77994_a - 1) % 2 + 1), 11, 1, 18, trigger, hintsOnly);
    }

    public String[] getStructureDescription(ItemStack stackSize) {
        return description;
    }

    static {
        FUSE_HANDLERS = new HashMap();
        PRIMITIVE_FUSE_HANDLERS = new HashMap();
        FUSE_HANDLERS.put((long)EMAtomDefinition.getClassTypeStatic() << 16 | (long)EMAtomDefinition.getClassTypeStatic(), new IColliderHandler(){

            @Override
            public void collide(EMInstanceStack in1, EMInstanceStack in2, EMInstanceStackMap out) {
                try {
                    EMDefinitionStackMap defs = new EMDefinitionStackMap();
                    defs.putUnifyAllExact(in1.getDefinition().getSubParticles());
                    defs.putUnifyAllExact(in2.getDefinition().getSubParticles());
                    EMAtomDefinition atom = new EMAtomDefinition(defs.toImmutable_optimized_unsafe_LeavesExposedElementalTree());
                    out.putUnify(new EMInstanceStack(atom, Math.min(in1.getAmount(), in2.getAmount())));
                }
                catch (Exception e) {
                    out.putUnifyAll(new EMInstanceStack[]{in1, in2});
                    return;
                }
                if (in1.getAmount() > in2.getAmount()) {
                    out.putUnify(new EMInstanceStack(in1.getDefinition(), in1.getAmount() - in2.getAmount()));
                } else if (in2.getAmount() > in1.getAmount()) {
                    out.putUnify(new EMInstanceStack(in2.getDefinition(), in2.getAmount() - in1.getAmount()));
                }
            }

            @Override
            public byte getRequiredTier() {
                return 1;
            }
        });
        GT_MetaTileEntity_EM_collider.registerSimpleAtomFuse(EMHadronDefinition.getClassTypeStatic());
        GT_MetaTileEntity_EM_collider.registerSimpleAtomFuse(EMComplexAspectDefinition.getClassTypeStatic());
        GT_MetaTileEntity_EM_collider.registerSimpleAtomFuse(EMPrimitiveTemplate.getClassTypeStatic());
        FUSE_HANDLERS.put((long)EMHadronDefinition.getClassTypeStatic() << 16 | (long)EMHadronDefinition.getClassTypeStatic(), new IColliderHandler(){

            @Override
            public void collide(EMInstanceStack in1, EMInstanceStack in2, EMInstanceStackMap out) {
                try {
                    EMDefinitionStackMap defs = new EMDefinitionStackMap();
                    defs.putUnifyAllExact(in1.getDefinition().getSubParticles());
                    defs.putUnifyAllExact(in2.getDefinition().getSubParticles());
                    EMHadronDefinition hadron = new EMHadronDefinition(defs.toImmutable_optimized_unsafe_LeavesExposedElementalTree());
                    out.putUnify(new EMInstanceStack(hadron, Math.min(in1.getAmount(), in2.getAmount())));
                }
                catch (Exception e) {
                    out.putUnifyAll(new EMInstanceStack[]{in1, in2});
                    return;
                }
                if (in1.getAmount() > in2.getAmount()) {
                    out.putUnify(new EMInstanceStack(in1.getDefinition(), in1.getAmount() - in2.getAmount()));
                } else if (in2.getAmount() > in1.getAmount()) {
                    out.putUnify(new EMInstanceStack(in2.getDefinition(), in2.getAmount() - in1.getAmount()));
                }
            }

            @Override
            public byte getRequiredTier() {
                return 2;
            }
        });
        FUSE_HANDLERS.put((long)EMHadronDefinition.getClassTypeStatic() << 16 | (long)EMPrimitiveTemplate.getClassTypeStatic(), new IColliderHandler(){

            @Override
            public void collide(EMInstanceStack in1, EMInstanceStack in2, EMInstanceStackMap out) {
                try {
                    EMDefinitionStackMap defs = new EMDefinitionStackMap();
                    defs.putUnifyAllExact(in1.getDefinition().getSubParticles());
                    defs.putUnifyExact(in2.getDefinition().getStackForm(1.0));
                    EMHadronDefinition hadron = new EMHadronDefinition(defs.toImmutable_optimized_unsafe_LeavesExposedElementalTree());
                    out.putUnify(new EMInstanceStack(hadron, Math.min(in1.getAmount(), in2.getAmount())));
                }
                catch (Exception e) {
                    out.putUnifyAll(new EMInstanceStack[]{in1, in2});
                    return;
                }
                if (in1.getAmount() > in2.getAmount()) {
                    out.putUnify(new EMInstanceStack(in1.getDefinition(), in1.getAmount() - in2.getAmount()));
                } else if (in2.getAmount() > in1.getAmount()) {
                    out.putUnify(new EMInstanceStack(in2.getDefinition(), in2.getAmount() - in1.getAmount()));
                }
            }

            @Override
            public byte getRequiredTier() {
                return 2;
            }
        });
        GT_MetaTileEntity_EM_collider.registerSimpleAspectFuse(EMComplexAspectDefinition.getClassTypeStatic());
        GT_MetaTileEntity_EM_collider.registerSimpleAspectFuse(EMPrimitiveTemplate.getClassTypeStatic());
        FUSE_HANDLERS.put((long)EMPrimitiveTemplate.getClassTypeStatic() << 16 | (long)EMPrimitiveTemplate.getClassTypeStatic(), new IColliderHandler(){

            @Override
            public void collide(EMInstanceStack in1, EMInstanceStack in2, EMInstanceStackMap out) {
                IPrimitiveColliderHandler collisionHandler = PRIMITIVE_FUSE_HANDLERS.get(in1.getDefinition().getClass().getName() + '\u0000' + in2.getDefinition().getClass().getName());
                if (collisionHandler != null) {
                    collisionHandler.collide(in2, in1, out);
                } else {
                    out.putUnifyAll(new EMInstanceStack[]{in1, in2});
                }
            }

            @Override
            public byte getRequiredTier() {
                return 2;
            }
        });
        PRIMITIVE_FUSE_HANDLERS.put(EMQuarkDefinition.class.getName() + '\u0000' + EMQuarkDefinition.class.getName(), (in1, in2, out) -> {
            try {
                EMDefinitionStackMap defs = new EMDefinitionStackMap();
                defs.putUnifyExact(in1.getDefinition().getStackForm(1.0));
                defs.putUnifyExact(in2.getDefinition().getStackForm(1.0));
                EMHadronDefinition hadron = new EMHadronDefinition(defs.toImmutable_optimized_unsafe_LeavesExposedElementalTree());
                out.putUnify(new EMInstanceStack(hadron, Math.min(in1.getAmount(), in2.getAmount())));
            }
            catch (Exception e) {
                out.putUnifyAll(new EMInstanceStack[]{in1, in2});
                return;
            }
            if (in1.getAmount() > in2.getAmount()) {
                out.putUnify(new EMInstanceStack(in1.getDefinition(), in1.getAmount() - in2.getAmount()));
            } else if (in2.getAmount() > in1.getAmount()) {
                out.putUnify(new EMInstanceStack(in2.getDefinition(), in2.getAmount() - in1.getAmount()));
            }
        });
        PRIMITIVE_FUSE_HANDLERS.put(EMPrimalAspectDefinition.class.getName() + '\u0000' + EMPrimalAspectDefinition.class.getName(), (in1, in2, out) -> {
            if (GT_MetaTileEntity_EM_collider.fuseAspects(in1, in2, out)) {
                return;
            }
            if (in1.getAmount() > in2.getAmount()) {
                out.putUnify(new EMInstanceStack(in1.getDefinition(), in1.getAmount() - in2.getAmount()));
            } else if (in2.getAmount() > in1.getAmount()) {
                out.putUnify(new EMInstanceStack(in2.getDefinition(), in2.getAmount() - in1.getAmount()));
            }
        });
        MODE_STATUS = (base_EM, p) -> {
            if (base_EM.isMaster()) {
                double mode = p.get();
                if (mode == 0.0 || mode == 1.0) {
                    return LedStatus.STATUS_OK;
                }
                if (mode > 1.0) {
                    return LedStatus.STATUS_TOO_HIGH;
                }
                if (mode < 0.0) {
                    return LedStatus.STATUS_TOO_LOW;
                }
                return LedStatus.STATUS_WRONG;
            }
            return LedStatus.STATUS_OK;
        };
        MODE_NAME = (base_EM, p) -> {
            if (base_EM.isMaster()) {
                double mode = p.get();
                if (mode == 0.0) {
                    return StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.collider.mode.0");
                }
                if (mode == 1.0) {
                    return StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.collider.mode.1");
                }
                return StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.collider.mode.2");
            }
            return StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.collider.mode.3");
        };
        description = new String[]{EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"tt.keyphrase.Hint_Details") + ":", StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.collider.hint.0"), StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.collider.hint.1"), StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.collider.hint.2"), StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.collider.hint.3"), StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.collider.hint.4")};
        STRUCTURE_DEFINITION = IStructureDefinition.builder().addShape("tier1", StructureUtility.transpose((String[][])new String[][]{{"         A A A         ", "        AAAAAAA        ", "      bbbbIIIbbbb      ", "     bAAAAAAAAAAAb     ", "    bAAAA     AAAAb    ", "   bAAA         AAAb   ", "  bAAA           AAAb  ", "  bAA             AAb  ", " AbAA             AAbA ", "AAbA               AbAA", " AIA               AIA ", "AAIA               AIAA", " AIA               AIA ", "AAbA               AbAA", " AbAA             AAbA ", "  bAA             AAb  ", "  bAAA           AAAb  ", "   bAAA         AAAb   ", "    bAAAAbJJJbAAAAb    ", "     bAHHbbbbbHHAb     ", "      bbbbGFGbbbb      "}, {"         AAAAA         ", "       AADDDDDAA       ", "      cDDeeeeeDDc      ", "     cDeeDDDDDeeDc     ", "    cDeDD     DDeDc    ", "   cDeD         DeDc   ", "  cDeD           DeDc  ", " ADeD             DeDA ", " ADeD             DeDA ", "ADeD               DeDA", "ADeD               DeDA", "ADeD               DeDA", "ADeD               DeDA", "ADeD               DeDA", " ADeD             DeDA ", " ADeD             DeDA ", "  cDeD           DeDc  ", "   cDeD         DeDc   ", "    cDeDDbJ~JbDDeDc    ", "     cDeeDDDDDeeDc     ", "      cDDeeeeeDDc      "}, {"         A A A         ", "        AAAAAAA        ", "      bbbbIIIbbbb      ", "     bAAAAAAAAAAAb     ", "    bAAAA     AAAAb    ", "   bAAA         AAAb   ", "  bAAA           AAAb  ", "  bAA             AAb  ", " AbAA             AAbA ", "AAbA               AbAA", " AIA               AIA ", "AAIA               AIAA", " AIA               AIA ", "AAbA               AbAA", " AbAA             AAbA ", "  bAA             AAb  ", "  bAAA           AAAb  ", "   bAAA         AAAb   ", "    bAAAAbJJJbAAAAb    ", "     bAHHbbbbbHHAb     ", "      bbbbGFGbbbb      "}})).addShape("tier2", StructureUtility.transpose((String[][])new String[][]{{"         A A A         ", "        AAAAAAA        ", "      BBBBIIIBBBB      ", "     BAAAAAAAAAAAB     ", "    BAAAA     AAAAB    ", "   BAAA         AAAB   ", "  BAAA           AAAB  ", "  BAA             AAB  ", " ABAA             AABA ", "AABA               ABAA", " AIA               AIA ", "AAIA               AIAA", " AIA               AIA ", "AABA               ABAA", " ABAA             AABA ", "  BAA             AAB  ", "  BAAA           AAAB  ", "   BAAA         AAAB   ", "    BAAAABJJJBAAAAB    ", "     BAHHBBBBBHHAB     ", "      BBBBGFGBBBB      "}, {"         AAAAA         ", "       AADDDDDAA       ", "      CDDEEEEEDDC      ", "     CDEEDDDDDEEDC     ", "    CDEDD     DDEDC    ", "   CDED         DEDC   ", "  CDED           DEDC  ", " ADED             DEDA ", " ADED             DEDA ", "ADED               DEDA", "ADED               DEDA", "ADED               DEDA", "ADED               DEDA", "ADED               DEDA", " ADED             DEDA ", " ADED             DEDA ", "  CDED           DEDC  ", "   CDED         DEDC   ", "    CDEDDBJ~JBDDEDC    ", "     CDEEDDDDDEEDC     ", "      CDDEEEEEDDC      "}, {"         A A A         ", "        AAAAAAA        ", "      BBBBIIIBBBB      ", "     BAAAAAAAAAAAB     ", "    BAAAA     AAAAB    ", "   BAAA         AAAB   ", "  BAAA           AAAB  ", "  BAA             AAB  ", " ABAA             AABA ", "AABA               ABAA", " AIA               AIA ", "AAIA               AIAA", " AIA               AIA ", "AABA               ABAA", " ABAA             AABA ", "  BAA             AAB  ", "  BAAA           AAAB  ", "   BAAA         AAAB   ", "    BAAAABJJJBAAAAB    ", "     BAHHBBBBBHHAB     ", "      BBBBGFGBBBB      "}})).addElement('A', StructureUtility.ofBlock((Block)TT_Container_Casings.sBlockCasingsTT, (int)4)).addElement('b', StructureUtility.ofBlock((Block)TT_Container_Casings.sBlockCasingsTT, (int)4)).addElement('B', StructureUtility.ofBlock((Block)TT_Container_Casings.sBlockCasingsTT, (int)5)).addElement('c', StructureUtility.ofBlock((Block)TT_Container_Casings.sBlockCasingsTT, (int)4)).addElement('C', StructureUtility.ofBlock((Block)TT_Container_Casings.sBlockCasingsTT, (int)6)).addElement('D', StructureUtility.ofBlock((Block)TT_Container_Casings.sBlockCasingsTT, (int)7)).addElement('e', StructureUtility.ofBlock((Block)TT_Container_Casings.sBlockCasingsTT, (int)8)).addElement('E', StructureUtility.ofBlock((Block)TT_Container_Casings.sBlockCasingsTT, (int)9)).addElement('I', StructureUtility.ofBlock((Block)QuantumGlassBlock.INSTANCE, (int)0)).addElement('J', GT_StructureUtility.ofHatchAdderOptional(GT_MetaTileEntity_MultiblockBase_EM::addClassicToMachineList, (int)1024, (int)1, (Block)TT_Container_Casings.sBlockCasingsTT, (int)0)).addElement('H', GT_StructureUtility.ofHatchAdderOptional(GT_MetaTileEntity_MultiblockBase_EM::addElementalInputToMachineList, (int)1028, (int)2, (Block)TT_Container_Casings.sBlockCasingsTT, (int)4)).addElement('F', GT_StructureUtility.ofHatchAdderOptional(GT_MetaTileEntity_MultiblockBase_EM::addElementalOutputToMachineList, (int)1028, (int)3, (Block)TT_Container_Casings.sBlockCasingsTT, (int)4)).addElement('G', GT_StructureUtility.ofHatchAdderOptional(GT_MetaTileEntity_MultiblockBase_EM::addElementalMufflerToMachineList, (int)1028, (int)4, (Block)TT_Container_Casings.sBlockCasingsTT, (int)4)).build();
    }
}

