/*
 * Decompiled with CFR 0.152.
 */
package travellersgear.api;

import java.lang.reflect.Method;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import travellersgear.api.ITravellersGear;
import travellersgear.api.TGSaveData;

public class TravellersGearAPI {
    static Method m_isStackPseudoTravellersGear = null;

    private static NBTTagCompound getTravellersNBTData(EntityPlayer player) {
        NBTTagCompound tag;
        if (TGSaveData.getPlayerData(player) == null) {
            tag = new NBTTagCompound();
            if (player.getEntityData().func_74764_b("TravellersRPG")) {
                tag = player.getEntityData().func_74775_l("TravellersRPG");
                player.getEntityData().func_82580_o("TravellersRPG");
            }
            tag.func_74772_a("UUIDMost", player.getPersistentID().getMostSignificantBits());
            tag.func_74772_a("UUIDLeast", player.getPersistentID().getLeastSignificantBits());
            TGSaveData.setPlayerData(player, tag);
            TGSaveData.setDirty();
        }
        if (player.getEntityData().func_74764_b("TravellersRPG")) {
            tag = player.getEntityData().func_74775_l("TravellersRPG");
            player.getEntityData().func_82580_o("TravellersRPG");
            tag.func_74772_a("UUIDMost", player.getPersistentID().getMostSignificantBits());
            tag.func_74772_a("UUIDLeast", player.getPersistentID().getLeastSignificantBits());
            TGSaveData.setPlayerData(player, tag);
            TGSaveData.setDirty();
        }
        return TGSaveData.getPlayerData(player);
    }

    public static boolean isTravellersGear(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() instanceof ITravellersGear) {
            return true;
        }
        try {
            if (m_isStackPseudoTravellersGear == null) {
                Class<?> c_ModCompatability = Class.forName("travellersgear.common.util.ModCompatability");
                m_isStackPseudoTravellersGear = c_ModCompatability.getMethod("isStackPseudoTravellersGear", ItemStack.class);
            }
            return (Boolean)m_isStackPseudoTravellersGear.invoke(null, stack);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static ItemStack[] getExtendedInventory(EntityPlayer player) {
        ItemStack[] ret = new ItemStack[4];
        NBTTagList inv = TravellersGearAPI.getTravellersNBTData(player).func_150295_c("Inventory", 10);
        if (inv != null) {
            for (int i = 0; i < inv.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = inv.func_150305_b(i);
                int slot = nbttagcompound.func_74771_c("Slot") & 0xFF;
                ItemStack itemstack = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
                if (itemstack == null || slot >= ret.length) continue;
                ret[slot] = itemstack;
            }
        }
        return ret;
    }

    public static void setExtendedInventory(EntityPlayer player, ItemStack[] inv) {
        if (player == null || inv == null) {
            return;
        }
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < inv.length; ++i) {
            if (inv[i] == null) continue;
            NBTTagCompound invSlot = new NBTTagCompound();
            invSlot.func_74774_a("Slot", (byte)i);
            inv[i].func_77955_b(invSlot);
            list.func_74742_a((NBTBase)invSlot);
        }
        TravellersGearAPI.getTravellersNBTData(player).func_74782_a("Inventory", (NBTBase)list);
        TGSaveData.setDirty();
    }

    public static String getTitleForPlayer(EntityPlayer player) {
        ItemStack scroll = TravellersGearAPI.getExtendedInventory(player)[3];
        if (scroll != null) {
            NBTTagList loreList;
            if (scroll.func_77942_o() && scroll.func_77978_p().func_74764_b("title")) {
                return scroll.func_77978_p().func_74779_i("title");
            }
            if (scroll.func_77942_o() && scroll.func_77978_p().func_74764_b("display") && scroll.func_77978_p().func_74775_l("display").func_74764_b("Lore") && (loreList = scroll.func_77978_p().func_74775_l("display").func_150295_c("Lore", 8)).func_74745_c() > 0) {
                return loreList.func_150307_f(0);
            }
            if (scroll.func_82837_s()) {
                return scroll.func_82833_r();
            }
        } else if (player != null && player.func_70005_c_().equalsIgnoreCase("blusunrize")) {
            return "Developer";
        }
        return null;
    }

    public static NBTTagList getDisplayTools(EntityPlayer player) {
        return TravellersGearAPI.getTravellersNBTData(player).func_150295_c("toolDisplay", 10);
    }

    public static void setDisplayTools(EntityPlayer player, NBTTagList list) {
        TravellersGearAPI.getTravellersNBTData(player).func_74782_a("toolDisplay", (NBTBase)list);
        TGSaveData.setDirty();
    }
}

