/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.util;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shukaro.warptheory.util.BlockCoord;

public final class RandomBlockHelper {
    private RandomBlockHelper() {
    }

    @Nullable
    public static BlockCoord randomAirBlock(World world, EntityPlayer player, int radius) {
        return RandomBlockHelper.randomBlock(world, player, radius, block -> block.isAir((IBlockAccess)world));
    }

    @Nullable
    public static BlockCoord randomDoubleAirBlock(World world, EntityPlayer player, int radius) {
        return RandomBlockHelper.randomBlock(world, player, radius, block -> block.isAir((IBlockAccess)world) && world.func_147437_c(block.x, block.y + 1, block.z));
    }

    @Nullable
    public static BlockCoord randomTripleAirBlock(World world, EntityPlayer player, int radius) {
        return RandomBlockHelper.randomBlock(world, player, radius, block -> block.isAir((IBlockAccess)world) && world.func_147437_c(block.x, block.y + 1, block.z) && world.func_147437_c(block.x, block.y + 2, block.z));
    }

    @Nullable
    public static BlockCoord randomBlock(World world, EntityPlayer player, int radius, Predicate<BlockCoord> isValid) {
        int z;
        int y;
        int x = (int)player.field_70165_t + world.field_73012_v.nextInt(radius) - world.field_73012_v.nextInt(radius);
        BlockCoord block = new BlockCoord(x, y = (int)player.field_70163_u + world.field_73012_v.nextInt(radius) - world.field_73012_v.nextInt(radius), z = (int)player.field_70161_v + world.field_73012_v.nextInt(radius) - world.field_73012_v.nextInt(radius));
        return isValid.test(block) ? block : null;
    }

    public static void setLocation(World world, Entity entity, BlockCoord location) {
        entity.func_70012_b((double)location.x + world.field_73012_v.nextDouble(), (double)location.y + world.field_73012_v.nextDouble(), (double)location.z + world.field_73012_v.nextDouble(), 360.0f * world.field_73012_v.nextFloat(), 180.0f * world.field_73012_v.nextFloat() - 90.0f);
    }
}

