/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.yamcore.client.dynamicgui.elements;

import eu.usrv.yamcore.client.dynamicgui.elements.IDisplayElementDataProvider;
import eu.usrv.yamcore.client.dynamicgui.helper.ColoredQuadDrawer;
import eu.usrv.yamcore.client.dynamicgui.helper.IQuadDrawer;
import eu.usrv.yamcore.client.dynamicgui.widgets.IWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import org.lwjgl.opengl.GL11;

public class DisplayElement
implements IWidget {
    private static final int padding = 3;
    private final int[] colors;
    private final String[] lines;
    private final GuiContainer gui;
    private final FontRenderer font;
    private final IQuadDrawer boxWhite;
    private final IQuadDrawer boxBlack;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected IDisplayElementDataProvider dataProvider;

    public DisplayElement(GuiContainer gui, FontRenderer font, int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.gui = gui;
        this.font = font;
        int lineCount = height / (font.field_78288_b + 1);
        this.colors = new int[lineCount];
        this.lines = new String[lineCount];
        for (int i = 0; i < lineCount; ++i) {
            this.colors[i] = 0xFFFFFF;
            this.lines[i] = "";
        }
        this.boxWhite = new ColoredQuadDrawer(0xFFFFFF, width, height);
        this.boxBlack = new ColoredQuadDrawer(0, width - 2, height - 2);
    }

    @Override
    public void drawBackground(Minecraft mc, int mouseX, int mouseY) {
        this.boxWhite.draw(this.x, this.y);
        this.boxBlack.draw(this.x + 1, this.y + 1);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void drawForeground(Minecraft mc, int mouseX, int mouseY) {
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.0f);
        for (int i = 0; i < this.lines.length; ++i) {
            this.drawString(i);
        }
        GL11.glScalef((float)2.0f, (float)2.0f, (float)0.0f);
        GL11.glTranslatef((float)(-this.x), (float)(-this.y), (float)0.0f);
    }

    public void drawString(int lineNum) {
        this.gui.func_73731_b(this.font, this.lines[lineNum], 3, 3 + this.font.field_78288_b * lineNum, this.colors[lineNum]);
    }

    @Override
    public int getElementHeight() {
        return this.width;
    }

    @Override
    public int getElementWidth() {
        return this.height;
    }

    @Override
    public int getElementY() {
        return this.y;
    }

    @Override
    public int getElementX() {
        return this.x;
    }

    @Override
    public void update() {
    }
}

