/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.util;

import com.darkona.adventurebackpack.reference.LoadedMods;
import com.darkona.adventurebackpack.util.LogHelper;
import com.darkona.adventurebackpack.util.ToolRenderHelper;
import com.darkona.adventurebackpack.util.Utils;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;

public final class GregtechUtils {
    private static final String CLASS_RENDERER = "gregtech.common.render.GT_MetaGenerated_Tool_Renderer";
    private static final String TOOLS_NAME = "gt.metatool.01";
    private static final int[] ROTATED_45_TOOLS = new int[]{16, 26, 30, 130};
    private static final int[] ROTATED_90_TOOLS = new int[]{10, 14, 18, 22, 34, 150, 160};
    private static Class<?> toolRenderer;
    private static Object toolRendererInstance;

    private GregtechUtils() {
    }

    private static void createToolRendererInstance() {
        if (Utils.inClient()) {
            try {
                toolRenderer = Class.forName(CLASS_RENDERER);
                toolRendererInstance = toolRenderer.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                LogHelper.error("Error getting instance of Gregtech Tools Renderer: " + e);
            }
        }
    }

    public static boolean isTool(@Nonnull ItemStack stack) {
        return LoadedMods.GREGTECH && stack.func_77973_b().func_77658_a().equals(TOOLS_NAME);
    }

    public static boolean isTool(String itemName) {
        return LoadedMods.GREGTECH && itemName.equals(TOOLS_NAME);
    }

    public static float getToolRotationAngle(ItemStack stack, boolean isLowerSlot) {
        int meta = stack.func_77960_j();
        for (int rotated45 : ROTATED_45_TOOLS) {
            if (meta != rotated45) continue;
            return isLowerSlot ? 0.0f : 90.0f;
        }
        for (int rotated90 : ROTATED_90_TOOLS) {
            if (meta != rotated90) continue;
            return isLowerSlot ? 45.0f : 135.0f;
        }
        return isLowerSlot ? -45.0f : 45.0f;
    }

    public static void renderTool(ItemStack stack, IItemRenderer.ItemRenderType renderType) {
        ToolRenderHelper.render(stack, renderType, toolRenderer, toolRendererInstance);
    }

    static {
        if (LoadedMods.GREGTECH) {
            GregtechUtils.createToolRendererInstance();
        }
    }
}

