/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers;

import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceTerminalSupport;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public interface IInterfaceHost
extends ICraftingProvider,
IUpgradeableHost,
ICraftingRequester,
IInterfaceTerminalSupport {
    public DualityInterface getInterfaceDuality();

    public EnumSet<ForgeDirection> getTargets();

    @Override
    public TileEntity getTileEntity();

    public void saveChanges();

    @Override
    default public IInterfaceTerminalSupport.PatternsConfiguration[] getPatternsConfigurations() {
        DualityInterface dual = this.getInterfaceDuality();
        ArrayList<IInterfaceTerminalSupport.PatternsConfiguration> patterns = new ArrayList<IInterfaceTerminalSupport.PatternsConfiguration>();
        for (int i = 0; i <= dual.getInstalledUpgrades(Upgrades.PATTERN_CAPACITY); ++i) {
            patterns.add(new IInterfaceTerminalSupport.PatternsConfiguration(i * 9, 9));
        }
        return patterns.toArray(new IInterfaceTerminalSupport.PatternsConfiguration[0]);
    }

    @Override
    default public IInventory getPatterns(int index) {
        return this.getInterfaceDuality().getPatterns();
    }

    @Override
    default public boolean shouldDisplay() {
        return this.getInterfaceDuality().getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) == YesNo.YES;
    }

    @Override
    default public String getName() {
        return this.getInterfaceDuality().getTermName();
    }

    @Override
    default public long getSortValue() {
        return this.getInterfaceDuality().getSortValue();
    }
}

