/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.util.accessprioritylist;

import com.github.bartimaeusnek.bartworks.util.accessprioritylist.AccessPriorityList;
import com.github.bartimaeusnek.bartworks.util.accessprioritylist.AccessPriorityListNode;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.commons.lang3.NotImplementedException;

public class AccessPriorityListIterators {

    public static class AccessPriorityListNodeIterator<E>
    implements Iterator<AccessPriorityListNode<E>> {
        final AccessPriorityListNode<E> head;
        AccessPriorityListNode<E> current;

        public AccessPriorityListNodeIterator(AccessPriorityListNode<E> head) {
            this.current = head;
            this.head = this.current;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public AccessPriorityListNode<E> next() {
            AccessPriorityListNode<E> ret = this.current;
            this.current = this.current.getNext();
            return ret;
        }
    }

    public static class AccessPriorityListReverseIterator<E>
    implements Iterator<E> {
        final AccessPriorityListNode<E> tail;
        AccessPriorityListNode<E> current;

        public AccessPriorityListReverseIterator(AccessPriorityListNode<E> tail) {
            this.current = tail;
            this.tail = this.current;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public E next() {
            E ret = this.current.getELEMENT();
            this.current = this.current.getBefore();
            return ret;
        }
    }

    public static class AccessPriorityListIterator<E>
    implements Iterator<E> {
        final AccessPriorityListNode<E> head;
        AccessPriorityListNode<E> current;

        public AccessPriorityListIterator(AccessPriorityListNode<E> head) {
            this.current = head;
            this.head = this.current;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public E next() {
            E ret = this.current.getELEMENT();
            this.current = this.current.getNext();
            return ret;
        }
    }

    public static class AccessPriorityListListIterator<E>
    implements ListIterator<E> {
        final AccessPriorityListNode<E> head;
        final AccessPriorityListNode<E> tail;
        AccessPriorityListNode<E> current;
        int counter = 0;
        boolean reverse;

        public AccessPriorityListListIterator(AccessPriorityListNode<E> head, AccessPriorityListNode<E> tail, boolean reverse) {
            this.head = head;
            this.tail = tail;
            this.current = reverse ? tail : head;
            this.reverse = reverse;
        }

        public AccessPriorityListListIterator(AccessPriorityList<E> list, int index) {
            this.head = list.head;
            this.tail = list.tail;
            this.current = list.getNode(index);
            this.counter = index;
        }

        @Override
        public boolean hasNext() {
            return this.reverse ? this.head != this.current : this.tail != this.current;
        }

        @Override
        public E next() {
            ++this.counter;
            E ret = this.current.getELEMENT();
            this.current = this.current.getNext();
            return ret;
        }

        @Override
        public boolean hasPrevious() {
            return !this.reverse ? this.head != this.current : this.tail != this.current;
        }

        @Override
        public E previous() {
            --this.counter;
            E ret = this.current.getELEMENT();
            this.current = this.current.getBefore();
            return ret;
        }

        @Override
        public int nextIndex() {
            return this.counter + 1;
        }

        @Override
        public int previousIndex() {
            return this.counter - 1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException("Not Implemented");
        }

        @Override
        public void set(E e) {
            throw new NotImplementedException("Not Implemented");
        }

        @Override
        public void add(E e) {
            throw new NotImplementedException("Not Implemented");
        }
    }
}

