/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.database;

import binnie.Binnie;
import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.ITooltip;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.Tooltip;
import binnie.core.craftgui.WidgetAttribute;
import binnie.core.craftgui.database.EnumDiscoveryState;
import binnie.core.craftgui.database.WindowAbstractDatabase;
import binnie.core.craftgui.events.EventHandler;
import binnie.core.craftgui.events.EventMouse;
import binnie.core.craftgui.geometry.IPoint;
import binnie.core.craftgui.minecraft.Window;
import binnie.core.craftgui.minecraft.control.ControlItemDisplay;
import binnie.core.genetics.BreedingSystem;
import binnie.core.util.I18N;
import com.mojang.authlib.GameProfile;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import net.minecraft.util.IIcon;

public class ControlDatabaseIndividualDisplay
extends ControlItemDisplay
implements ITooltip {
    protected EnumDiscoveryState discovered = EnumDiscoveryState.SHOW;
    private IAlleleSpecies species = null;

    public void setSpecies(IAlleleSpecies species) {
        this.setSpecies(species, EnumDiscoveryState.SHOW);
    }

    public void setSpecies(IAlleleSpecies species, EnumDiscoveryState state) {
        this.species = species;
        ISpeciesRoot speciesRoot = Binnie.Genetics.getSpeciesRoot(species);
        BreedingSystem system = Binnie.Genetics.getSystem(speciesRoot.getUID());
        IIndividual ind = system.getSpeciesRoot().templateAsIndividual(system.getSpeciesRoot().getTemplate(species.getUID()));
        super.setItemStack(system.getSpeciesRoot().getMemberStack(ind, system.getDefaultType()));
        Object window = Window.get(this);
        GameProfile username = ((Window)window).getUsername();
        if (window instanceof WindowAbstractDatabase && ((WindowAbstractDatabase)window).isNEI) {
            state = EnumDiscoveryState.SHOW;
        } else if (state == EnumDiscoveryState.UNDETERMINED) {
            state = system.isSpeciesDiscovered(species, ((Window)window).getWorld(), username) ? EnumDiscoveryState.DISCOVERED : EnumDiscoveryState.UNDISCOVERED;
        }
        this.discovered = state;
        this.addAttribute(WidgetAttribute.MOUSE_OVER);
    }

    public ControlDatabaseIndividualDisplay(IWidget parent, float x, float y) {
        this(parent, x, y, 16.0f);
    }

    public ControlDatabaseIndividualDisplay(IWidget parent, float x, float y, float size) {
        super(parent, x, y, size);
        this.addSelfEventHandler((EventHandler)new MouseDownHandler());
    }

    @Override
    public void onRenderForeground() {
        IIcon icon = null;
        if (this.species == null) {
            return;
        }
        BreedingSystem system = Binnie.Genetics.getSystem(this.species.getRoot());
        switch (this.discovered) {
            case SHOW: {
                super.onRenderForeground();
                return;
            }
            case DISCOVERED: {
                icon = system.getDiscoveredIcon();
                break;
            }
            case UNDISCOVERED: {
                icon = system.getUndiscoveredIcon();
            }
        }
        if (icon != null) {
            CraftGUI.render.iconItem(IPoint.ZERO, icon);
        }
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        if (this.species == null) {
            return;
        }
        switch (this.discovered) {
            case SHOW: 
            case DISCOVERED: {
                tooltip.add(this.species.getName());
                break;
            }
            case UNDISCOVERED: {
                tooltip.add(I18N.localise("binniecore.gui.database.discovered.undiscovered"));
            }
        }
    }

    private class MouseDownHandler
    extends EventMouse.Down.Handler {
        private MouseDownHandler() {
        }

        @Override
        public void onEvent(EventMouse.Down event) {
            if (event.getButton() == 0 && ControlDatabaseIndividualDisplay.this.species != null && EnumDiscoveryState.SHOW == ControlDatabaseIndividualDisplay.this.discovered) {
                ((WindowAbstractDatabase)ControlDatabaseIndividualDisplay.this.getSuperParent()).gotoSpeciesDelayed(ControlDatabaseIndividualDisplay.this.species);
            }
        }
    }
}

