/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.minetweaker;

import buildcraft.api.core.StackKey;
import buildcraft.api.fuels.BuildcraftFuelRegistry;
import buildcraft.api.fuels.ICoolant;
import buildcraft.api.fuels.IFuel;
import buildcraft.api.fuels.ISolidCoolant;
import java.util.HashSet;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.buildcraft.Fuels")
@ModOnly(value={"BuildCraft|Energy"})
public class Fuels {
    @ZenMethod
    public static void addCombustionEngineFuel(ILiquidStack fuel, int powerPerCycle, int totalBurningTime) {
        MineTweakerAPI.apply((IUndoableAction)new AddFuelAction(fuel, powerPerCycle, totalBurningTime));
    }

    @ZenMethod
    public static void removeCombustionEngineFuel(ILiquidStack fuel) {
        Fluid fluid = MineTweakerMC.getLiquidStack((ILiquidStack)fuel).getFluid();
        if (BuildcraftFuelRegistry.fuel.getFuel(fluid) != null) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveFuelAction(fluid.getName(), BuildcraftFuelRegistry.fuel.getFuel(fluid)));
        } else {
            MineTweakerAPI.logWarning((String)("No such iron engine fuel: " + fluid.getName()));
        }
    }

    @ZenMethod
    public static void addCombustionEngineCoolant(ILiquidStack coolant, float coolingPerMB) {
        MineTweakerAPI.apply((IUndoableAction)new AddLiquidCoolantAction(MineTweakerMC.getLiquidStack((ILiquidStack)coolant), coolingPerMB));
    }

    @ZenMethod
    public static void addCoolantItem(IItemStack coolantItem, ILiquidStack coolantLiquid) {
        MineTweakerAPI.apply((IUndoableAction)new AddCoolantItemAction(new StackKey(MineTweakerMC.getItemStack((IItemStack)coolantItem)), MineTweakerMC.getLiquidStack((ILiquidStack)coolantLiquid), 1.0f));
    }

    @ZenMethod
    public static void addCoolantItemWithMultiplier(IItemStack coolantItem, ILiquidStack coolantLiquid, float multiplier) {
        MineTweakerAPI.apply((IUndoableAction)new AddCoolantItemAction(new StackKey(MineTweakerMC.getItemStack((IItemStack)coolantItem)), MineTweakerMC.getLiquidStack((ILiquidStack)coolantLiquid), multiplier));
    }

    @ZenMethod
    public static void removeCombustionEngineCoolant(ILiquidStack coolantFluid) {
        FluidStack fluid = MineTweakerMC.getLiquidStack((ILiquidStack)coolantFluid);
        ICoolant coolant = BuildcraftFuelRegistry.coolant.getCoolant(fluid.getFluid());
        if (coolant != null) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveLiquidCoolantAction(coolant));
        } else {
            MineTweakerAPI.logWarning((String)("No such iron engine coolant: " + fluid.getFluid().getName()));
        }
    }

    @ZenMethod
    public static void removeCoolantItem(IIngredient itemI) {
        ItemStack stack = MineTweakerMC.getItemStack((IIngredient)itemI);
        String name = stack.func_82833_r();
        if (BuildcraftFuelRegistry.coolant.getSolidCoolant(new StackKey(stack)) != null) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveCoolantItemAction(name, BuildcraftFuelRegistry.coolant.getSolidCoolant(new StackKey(stack))));
        } else {
            MineTweakerAPI.logWarning((String)("No such iron engine coolant: " + name));
        }
    }

    private static class RemoveCoolantItemAction
    implements IUndoableAction {
        private final String name;
        private final ISolidCoolant coolant;

        public RemoveCoolantItemAction(String name, ISolidCoolant coolant) {
            this.name = name;
            this.coolant = coolant;
        }

        public void apply() {
            BuildcraftFuelRegistry.coolant.getSolidCoolants().remove(this.coolant);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            BuildcraftFuelRegistry.coolant.addSolidCoolant(this.coolant);
        }

        public String describe() {
            return "Removing iron engine coolant item " + this.name;
        }

        public String describeUndo() {
            return "Restoring iron engine coolant item " + this.name;
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class RemoveLiquidCoolantAction
    implements IUndoableAction {
        private final ICoolant coolant;

        public RemoveLiquidCoolantAction(ICoolant coolant) {
            this.coolant = coolant;
        }

        public void apply() {
            BuildcraftFuelRegistry.coolant.getCoolants().remove(this.coolant);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            BuildcraftFuelRegistry.coolant.addCoolant(this.coolant);
        }

        public String describe() {
            return "Removing iron engine coolant " + this.coolant.getFluid().getName();
        }

        public String describeUndo() {
            return "Restoring iron engine coolant " + this.coolant.getFluid().getName();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddCoolantItemAction
    implements IUndoableAction {
        private final StackKey item;
        private final FluidStack liquid;
        private final float mul;

        public AddCoolantItemAction(StackKey item, FluidStack liquid, float mul) {
            this.item = item;
            this.liquid = liquid;
            this.mul = mul;
        }

        public void apply() {
            BuildcraftFuelRegistry.coolant.addSolidCoolant(this.item, new StackKey(this.liquid), this.mul);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            BuildcraftFuelRegistry.coolant.getSolidCoolants().remove(BuildcraftFuelRegistry.coolant.getCoolant(this.liquid.getFluid()));
        }

        public String describe() {
            return "Adding iron engine coolant item " + MineTweakerMC.getIItemStack((ItemStack)this.item.stack);
        }

        public String describeUndo() {
            return "Removing iron engine coolant item " + MineTweakerMC.getIItemStack((ItemStack)this.item.stack);
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddLiquidCoolantAction
    implements IUndoableAction {
        private final FluidStack liquid;
        private final float degreesCooling;

        public AddLiquidCoolantAction(FluidStack liquid, float degreesCooling) {
            this.liquid = liquid;
            this.degreesCooling = degreesCooling;
        }

        public void apply() {
            BuildcraftFuelRegistry.coolant.addCoolant(this.liquid.getFluid(), this.degreesCooling);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            BuildcraftFuelRegistry.coolant.getCoolants().remove(BuildcraftFuelRegistry.coolant.getCoolant(this.liquid.getFluid()));
        }

        public String describe() {
            return "Adding iron engine coolant " + this.liquid;
        }

        public String describeUndo() {
            return "Removing iron engine coolant " + this.liquid;
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class RemoveFuelAction
    implements IUndoableAction {
        private final String fuelName;
        private final IFuel fuel;

        public RemoveFuelAction(String fuelName, IFuel fuel) {
            this.fuelName = fuelName;
            this.fuel = fuel;
        }

        public void apply() {
            BuildcraftFuelRegistry.fuel.getFuels().remove(this.fuel);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            BuildcraftFuelRegistry.fuel.addFuel(this.fuel);
        }

        public String describe() {
            return "Removing iron engine fuel " + this.fuelName;
        }

        public String describeUndo() {
            return "Restoring iron engine fuel " + this.fuelName;
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddFuelAction
    implements IUndoableAction {
        private final ILiquidStack fuel;
        private final int powerPerCycle;
        private final int totalBurningTime;

        public AddFuelAction(ILiquidStack fuel, int powerPerCycle, int totalBurningTime) {
            this.fuel = fuel;
            this.powerPerCycle = powerPerCycle;
            this.totalBurningTime = totalBurningTime;
        }

        public void apply() {
            BuildcraftFuelRegistry.fuel.addFuel(MineTweakerMC.getLiquidStack((ILiquidStack)this.fuel).getFluid(), this.powerPerCycle, this.totalBurningTime);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            HashSet<IFuel> fuelsToRemove = new HashSet<IFuel>();
            for (IFuel fuel : BuildcraftFuelRegistry.fuel.getFuels()) {
                if (fuel == null || fuel.getFluid() != fuel.getFluid() || fuel.getPowerPerCycle() != this.powerPerCycle || fuel.getTotalBurningTime() != this.totalBurningTime) continue;
                fuelsToRemove.add(fuel);
            }
            for (IFuel fuel : fuelsToRemove) {
                BuildcraftFuelRegistry.fuel.getFuels().remove(fuel);
            }
        }

        public String describe() {
            return "Adding iron engine fuel " + this.fuel.getName();
        }

        public String describeUndo() {
            return "Removing iron engine fuel " + this.fuel.getName();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

