/*
 * Decompiled with CFR 0.152.
 */
package com.thecodewarrior.catwalks.util;

import codechicken.lib.vec.BlockCoord;
import com.thecodewarrior.catwalks.CatwalkMod;
import com.thecodewarrior.catwalks.util.BlockHit;
import com.thecodewarrior.catwalks.util.CatwalkEntityProperties;
import com.thecodewarrior.catwalks.util.Predicate;
import com.thecodewarrior.mcjty.varia.WrenchChecker;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.common.util.ForgeDirection;

public class CatwalkUtil {
    static Random rand = new Random();
    static boolean isDev = false;

    public static boolean isDev() {
        return isDev;
    }

    public static void init() {
        isDev = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        WrenchChecker.init();
    }

    public static BlockCoord getRetractCoord(int x, int y, int z, ForgeDirection direction, Predicate<BlockCoord> p) {
        return null;
    }

    public static EntityPlayer getPlayerLooking(Vec3 start, Vec3 end) {
        return CatwalkMod.proxy.getPlayerLooking(start, end);
    }

    public static Block getHeldBlock(EntityLivingBase entity) {
        if (entity.func_70694_bm() != null && entity.func_70694_bm().func_77973_b() instanceof ItemBlock) {
            return ((ItemBlock)entity.func_70694_bm().func_77973_b()).field_150939_a;
        }
        return null;
    }

    public static boolean isHoldingWrench(EntityLivingBase entity, boolean defult) {
        if (entity instanceof EntityPlayer) {
            return CatwalkUtil.isHoldingWrench((EntityPlayer)entity);
        }
        return defult;
    }

    public static boolean isHoldingWrench(EntityPlayer player) {
        ItemStack heldStack = player.func_70694_bm();
        if (heldStack != null) {
            Item item = heldStack.func_77973_b();
            if (WrenchChecker.isAWrench(item)) {
                return true;
            }
            if (item.getToolClasses(heldStack).contains("wrench")) {
                return true;
            }
        }
        return false;
    }

    public static void giveItemsToPlayer(EntityPlayer player, List<ItemStack> stacks) {
        for (ItemStack s : stacks) {
            CatwalkUtil.giveItemToPlayer(player, s);
        }
    }

    public static void giveItemToPlayer(EntityPlayer player, ItemStack _stack) {
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        ItemStack stack = _stack.func_77946_l();
        if (player.field_71071_by.func_70441_a(stack)) {
            player.field_71069_bz.func_75142_b();
        }
        if (!player.field_70170_p.field_72995_K && stack.field_77994_a > 0) {
            double xSize = player.field_70121_D.field_72336_d - player.field_70121_D.field_72340_a;
            double ySize = player.field_70121_D.field_72337_e - player.field_70121_D.field_72338_b;
            double zSize = player.field_70121_D.field_72334_f - player.field_70121_D.field_72339_c;
            EntityItem entity = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, stack);
            entity.field_145804_b = 0;
            entity.field_70159_w = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70179_y = 0.0;
            player.field_70170_p.func_72838_d((Entity)entity);
        }
    }

    public static void spawnHitParticles(float pointX, float pointY, float pointZ, ForgeDirection side, String name, World world) {
        double d = 0.3;
        for (int i = 0; i < 5; ++i) {
            double particleX = (double)pointX + (side.offsetX == 0 ? rand.nextGaussian() * 0.3 * d : (double)side.offsetX * 0.05);
            double particleY = (double)pointY + (side.offsetY == 0 ? rand.nextGaussian() * 0.3 * d : (double)side.offsetY * 0.05);
            double particleZ = (double)pointZ + (side.offsetZ == 0 ? rand.nextGaussian() * 0.3 * d : (double)side.offsetZ * 0.05);
            CatwalkMod.proxy.spawnCustomParticle(name, world, particleX, particleY, particleZ);
        }
    }

    public static void extendParticles(boolean placeSucceeded, boolean didHitAnother, World world, int origX, int origY, int origZ, float hitX, float hitY, float hitZ, ForgeDirection side) {
        if (!placeSucceeded) {
            CatwalkUtil.spawnHitParticles((float)origX + hitX, (float)origY + hitY, (float)origZ + hitZ, side, "cantExtend", world);
        } else if (didHitAnother) {
            CatwalkUtil.spawnHitParticles((float)origX + hitX, (float)origY + hitY, (float)origZ + hitZ, side, "hitAnother", world);
        }
    }

    public static BlockHit getExtendCoord(World world, int x, int y, int z, ForgeDirection direction, Predicate<BlockCoord> pred) {
        int newX = x;
        int newY = y;
        int newZ = z;
        for (int i = 0; i < 128; ++i) {
            Block b = world.func_147439_a(newX += direction.offsetX, newY += direction.offsetY, newZ += direction.offsetZ);
            if (!pred.test(new BlockCoord(newX, newY, newZ))) {
                return new BlockHit(newX - direction.offsetX, newY - direction.offsetY, newZ - direction.offsetZ, direction);
            }
            if (i != 126) continue;
            return new BlockHit(x, y, z, ForgeDirection.UNKNOWN);
        }
        return new BlockHit(x, y, z, direction.getOpposite());
    }

    public static boolean canPlaceBlock(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int _side, ItemBlock blockToPlace, Predicate<Block> shouldExtendFromBlock, Predicate<BlockCoord> continueSearching, Predicate<BlockCoord> ignoreReplaceable) {
        Block block = world.func_147439_a(x, y, z);
        if (shouldExtendFromBlock.test(block) && player.func_70093_af()) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)_side).getOpposite();
            BlockHit coord = CatwalkUtil.getExtendCoord(world, x, y, z, dir, continueSearching);
            return coord.side != ForgeDirection.UNKNOWN.ordinal();
        }
        if (block == Blocks.field_150431_aC) {
            _side = 1;
        } else if (block != Blocks.field_150395_bd && block != Blocks.field_150329_H && block != Blocks.field_150330_I && (!block.isReplaceable((IBlockAccess)world, x, y, z) || block.getClass().isAssignableFrom(blockToPlace.field_150939_a.getClass()))) {
            if (_side == 0) {
                --y;
            }
            if (_side == 1) {
                ++y;
            }
            if (_side == 2) {
                --z;
            }
            if (_side == 3) {
                ++z;
            }
            if (_side == 4) {
                --x;
            }
            if (_side == 5) {
                ++x;
            }
        }
        return world.func_147472_a(blockToPlace.field_150939_a, x, y, z, false, _side, null, stack);
    }

    public static boolean extendBlock(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int _side, float hitX, float hitY, float hitZ, ItemBlock blockToPlace, Predicate<Block> shouldExtendFromBlock, Predicate<BlockCoord> continueSearching, Predicate<BlockCoord> ignoreReplaceable) {
        Block block = world.func_147439_a(x, y, z);
        ForgeDirection side = ForgeDirection.getOrientation((int)_side);
        int meta = world.func_72805_g(x, y, z);
        boolean isExtending = false;
        boolean placeSucceeded = false;
        boolean placeTried = false;
        boolean didHitAnother = false;
        int oldX = x;
        int oldY = y;
        int oldZ = z;
        if (shouldExtendFromBlock.test(block) && player.func_70093_af()) {
            isExtending = true;
            ForgeDirection dir = ForgeDirection.getOrientation((int)_side).getOpposite();
            BlockHit coord = CatwalkUtil.getExtendCoord(world, x, y, z, dir, continueSearching);
            x = coord.x;
            y = coord.y;
            z = coord.z;
            _side = coord.side;
            didHitAnother = continueSearching.test(new BlockCoord(x + 2 * dir.offsetX, y + 2 * dir.offsetY, z + 2 * dir.offsetZ));
        }
        if (block == Blocks.field_150431_aC && (world.func_72805_g(x, y, z) & 7) < 1) {
            _side = 1;
        } else if (block != Blocks.field_150395_bd && block != Blocks.field_150329_H && block != Blocks.field_150330_I && (!block.isReplaceable((IBlockAccess)world, x, y, z) || ignoreReplaceable.test(new BlockCoord(x, y, z)))) {
            if (_side == 0) {
                --y;
            }
            if (_side == 1) {
                ++y;
            }
            if (_side == 2) {
                --z;
            }
            if (_side == 3) {
                ++z;
            }
            if (_side == 4) {
                --x;
            }
            if (_side == 5) {
                ++x;
            }
        }
        if (_side != ForgeDirection.UNKNOWN.ordinal()) {
            if (stack.field_77994_a == 0) {
                placeSucceeded = false;
            } else if (!player.func_82247_a(x, y, z, _side, stack)) {
                placeSucceeded = false;
            } else if (y == 255 && blockToPlace.field_150939_a.func_149688_o().func_76220_a()) {
                placeSucceeded = false;
            } else if (world.func_147472_a(blockToPlace.field_150939_a, x, y, z, false, _side, (Entity)player, stack)) {
                int stackMeta = blockToPlace.func_77647_b(stack.func_77960_j());
                int newMeta = blockToPlace.field_150939_a.func_149660_a(world, x, y, z, _side, hitX, hitY, hitZ, stackMeta);
                if (blockToPlace.placeBlockAt(stack, player, world, x, y, z, _side, hitX, hitY, hitZ, newMeta)) {
                    placeSucceeded = true;
                    world.func_72908_a((double)((float)oldX + 0.5f), (double)((float)oldY + 0.5f), (double)((float)oldZ + 0.5f), blockToPlace.field_150939_a.field_149762_H.func_150496_b(), (blockToPlace.field_150939_a.field_149762_H.func_150497_c() + 1.0f) / 2.0f, blockToPlace.field_150939_a.field_149762_H.func_150494_d() * 0.8f);
                    --stack.field_77994_a;
                }
                placeTried = true;
            } else {
                placeSucceeded = false;
            }
        }
        if (isExtending) {
            CatwalkUtil.extendParticles(placeSucceeded, didHitAnother, world, oldX, oldY, oldZ, hitX, hitY, hitZ, side);
        }
        return placeSucceeded || placeTried;
    }

    public static CatwalkEntityProperties getOrCreateEP(Entity entity) {
        CatwalkEntityProperties catwalkEP = (CatwalkEntityProperties)entity.getExtendedProperties("catwalkmod.catwalkdata");
        if (catwalkEP == null) {
            catwalkEP = new CatwalkEntityProperties();
            entity.registerExtendedProperties("catwalkmod.catwalkdata", (IExtendedEntityProperties)catwalkEP);
        }
        return catwalkEP;
    }

    public static boolean retractBlock(World world, int x, int y, int z, ForgeDirection dir, EntityPlayer player, Predicate<BlockCoord> continueSearching) {
        int newX = x;
        int newY = y;
        int newZ = z;
        for (int i = 0; i < 128; ++i) {
            Block b = world.func_147439_a(newX += dir.offsetX, newY += dir.offsetY, newZ += dir.offsetZ);
            if (continueSearching.test(new BlockCoord(newX, newY, newZ))) continue;
            newX -= dir.offsetX;
            newY -= dir.offsetY;
            newZ -= dir.offsetZ;
            if (i == 0) break;
            b = world.func_147439_a(newX, newY, newZ);
            ArrayList drops = b.getDrops(world, newX, newY, newZ, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(newX, newY, newZ);
            for (ItemStack s : drops) {
                CatwalkUtil.giveItemToPlayer(player, s);
            }
            return true;
        }
        return false;
    }
}

