/*
 * Decompiled with CFR 0.152.
 */
package com.gtnh.findit.service.itemfinder;

import com.gtnh.findit.service.itemfinder.ClientItemFindService;
import com.gtnh.findit.util.ProtoUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.world.ChunkPosition;

public class ItemFoundResponse
implements IMessage {
    private ItemStack foundStack;
    private List<ChunkPosition> positions;

    public ItemFoundResponse(ItemStack foundStack, List<ChunkPosition> positions) {
        this.foundStack = foundStack;
        this.positions = positions;
    }

    public ItemFoundResponse() {
    }

    public void fromBytes(ByteBuf buf) {
        this.foundStack = ProtoUtils.readItemStack(buf);
        this.positions = ProtoUtils.readPositions(buf);
    }

    public void toBytes(ByteBuf buf) {
        ProtoUtils.writeItemStack(buf, this.foundStack);
        ProtoUtils.writePositions(buf, this.positions);
    }

    public ItemStack getFoundStack() {
        return this.foundStack;
    }

    public List<ChunkPosition> getPositions() {
        return this.positions;
    }

    public static class Handler
    implements IMessageHandler<ItemFoundResponse, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(ItemFoundResponse message, MessageContext ctx) {
            if (message.foundStack != null && !message.positions.isEmpty()) {
                ClientItemFindService.getInstance().handleResponse(Minecraft.func_71410_x().field_71439_g, message);
            }
            return null;
        }
    }
}

