/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe.check;

import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import gregtech.api.recipe.check.CheckRecipeResult;
import java.util.Objects;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.StatCollector;

public class SimpleCheckRecipeResult
implements CheckRecipeResult {
    private boolean success;
    private String key;

    SimpleCheckRecipeResult(boolean success, String key) {
        this.success = success;
        this.key = key;
    }

    @Override
    public String getID() {
        return "simple_result";
    }

    @Override
    public boolean wasSuccessful() {
        return this.success;
    }

    @Override
    public String getDisplayString() {
        return StatCollector.func_74838_a((String)("GT5U.gui.text." + this.key));
    }

    @Override
    public CheckRecipeResult newInstance() {
        return new SimpleCheckRecipeResult(false, "");
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeBoolean(this.success);
        NetworkUtils.writeStringSafe((PacketBuffer)buffer, (String)this.key);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.success = buffer.readBoolean();
        this.key = NetworkUtils.readStringSafe((PacketBuffer)buffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleCheckRecipeResult that = (SimpleCheckRecipeResult)o;
        return this.success == that.success && Objects.equals(this.key, that.key);
    }

    public static CheckRecipeResult ofSuccess(String key) {
        return new SimpleCheckRecipeResult(true, key);
    }

    public static CheckRecipeResult ofFailure(String key) {
        return new SimpleCheckRecipeResult(false, key);
    }
}

