/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.gui.modularui.GT_CoverUIBuildContext;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollower_ToggleButtonWidget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_Cover_Pump
extends GT_CoverBehavior {
    public final int mTransferRate;

    @Deprecated
    public GT_Cover_Pump(int aTransferRate) {
        this(aTransferRate, null);
    }

    public GT_Cover_Pump(int aTransferRate, ITexture coverTexture) {
        super(coverTexture);
        this.mTransferRate = aTransferRate;
    }

    @Override
    public boolean isRedstoneSensitive(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return false;
    }

    @Override
    public int doCoverThings(ForgeDirection side, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        IFluidHandler tTank2;
        if (aCoverVariable % 6 > 1 && aTileEntity instanceof IMachineProgress && ((IMachineProgress)((Object)aTileEntity)).isAllowedToWork() != aCoverVariable % 6 < 4) {
            return aCoverVariable;
        }
        if (aTileEntity instanceof IFluidHandler && (tTank2 = aTileEntity.getITankContainerAtSide(side)) != null) {
            IFluidHandler tTank1 = (IFluidHandler)aTileEntity;
            if (aCoverVariable % 2 == 0) {
                FluidStack tLiquid = tTank1.drain(side, this.mTransferRate, false);
                if (tLiquid != null) {
                    tLiquid = tLiquid.copy();
                    tLiquid.amount = tTank2.fill(side.getOpposite(), tLiquid, false);
                    if (tLiquid.amount > 0 && this.canTransferFluid(tLiquid)) {
                        tTank2.fill(side.getOpposite(), tTank1.drain(side, tLiquid.amount, true), true);
                    }
                }
            } else {
                FluidStack tLiquid = tTank2.drain(side.getOpposite(), this.mTransferRate, false);
                if (tLiquid != null) {
                    tLiquid = tLiquid.copy();
                    tLiquid.amount = tTank1.fill(side, tLiquid, false);
                    if (tLiquid.amount > 0 && this.canTransferFluid(tLiquid)) {
                        tTank1.fill(side, tTank2.drain(side.getOpposite(), tLiquid.amount, true), true);
                    }
                }
            }
        }
        return aCoverVariable;
    }

    protected boolean canTransferFluid(FluidStack fluid) {
        return true;
    }

    @Override
    public int onCoverScrewdriverclick(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if ((aCoverVariable = (aCoverVariable + (aPlayer.func_70093_af() ? -1 : 1)) % 12) < 0) {
            aCoverVariable = 11;
        }
        switch (aCoverVariable) {
            case 0: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("006", "Export"));
                break;
            }
            case 1: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("007", "Import"));
                break;
            }
            case 2: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("008", "Export (conditional)"));
                break;
            }
            case 3: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("009", "Import (conditional)"));
                break;
            }
            case 4: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("010", "Export (invert cond)"));
                break;
            }
            case 5: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("011", "Import (invert cond)"));
                break;
            }
            case 6: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("012", "Export allow Input"));
                break;
            }
            case 7: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("013", "Import allow Output"));
                break;
            }
            case 8: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("014", "Export allow Input (conditional)"));
                break;
            }
            case 9: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("015", "Import allow Output (conditional)"));
                break;
            }
            case 10: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("016", "Export allow Input (invert cond)"));
                break;
            }
            case 11: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("017", "Import allow Output (invert cond)"));
            }
        }
        return aCoverVariable;
    }

    @Override
    public boolean letsRedstoneGoIn(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsRedstoneGoOut(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyIn(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOut(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsIn(ForgeDirection side, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsOut(ForgeDirection side, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidIn(ForgeDirection side, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        if (aCoverVariable > 1 && aTileEntity instanceof IMachineProgress && ((IMachineProgress)((Object)aTileEntity)).isAllowedToWork() != aCoverVariable % 6 < 4) {
            return false;
        }
        return aCoverVariable >= 6 || aCoverVariable % 2 != 0;
    }

    @Override
    public boolean letsFluidOut(ForgeDirection side, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        if (aCoverVariable > 1 && aTileEntity instanceof IMachineProgress && ((IMachineProgress)((Object)aTileEntity)).isAllowedToWork() != aCoverVariable % 6 < 4) {
            return false;
        }
        return aCoverVariable >= 6 || aCoverVariable % 2 == 0;
    }

    @Override
    public boolean alwaysLookConnected(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRate(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 1;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public boolean useModularUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(GT_CoverUIBuildContext buildContext) {
        return new PumpUIFactory(buildContext).createWindow();
    }

    private class PumpUIFactory
    extends GT_CoverBehaviorBase.UIFactory {
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;

        public PumpUIFactory(GT_CoverUIBuildContext buildContext) {
            super(buildContext);
        }

        @Override
        protected void addUIWidgets(ModularWindow.Builder builder) {
            ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new CoverDataControllerWidget.CoverDataIndexedControllerWidget_ToggleButtons<ISerializableObject.LegacyCoverData>(this::getCoverData, this::setCoverData, GT_Cover_Pump.this, (id, coverData) -> !this.getClickable((int)id, GT_Cover_Pump.convert(coverData)), (id, coverData) -> new ISerializableObject.LegacyCoverData(this.getNewCoverVariable((int)id, GT_Cover_Pump.convert(coverData)))).addToggleButton(0, CoverDataFollower_ToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_EXPORT).addTooltip(GT_Utility.trans("006", "Export")).setPos(0, 0)).addToggleButton(1, CoverDataFollower_ToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_IMPORT).addTooltip(GT_Utility.trans("007", "Import")).setPos(18, 0)).addToggleButton(2, CoverDataFollower_ToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_CHECKMARK).addTooltip(GT_Utility.trans("224", "Always On")).setPos(0, 18)).addToggleButton(3, CoverDataFollower_ToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_REDSTONE_ON).addTooltip(GT_Utility.trans("225", "Active with Redstone Signal")).setPos(18, 18)).addToggleButton(4, CoverDataFollower_ToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_REDSTONE_OFF).addTooltip(GT_Utility.trans("226", "Inactive with Redstone Signal")).setPos(36, 18)).addToggleButton(5, CoverDataFollower_ToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_ALLOW_INPUT).addTooltip(GT_Utility.trans("227", "Allow Input")).setPos(0, 36)).addToggleButton(6, CoverDataFollower_ToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_BLOCK_INPUT).addTooltip(GT_Utility.trans("228", "Block Input")).setPos(18, 36)).setPos(10, 25))).widget(new TextWidget(GT_Utility.trans("229", "Import/Export")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(64, 28))).widget(new TextWidget(GT_Utility.trans("230", "Conditional")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(64, 46))).widget(new TextWidget(GT_Utility.trans("231", "Enable Input")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(64, 64));
        }

        private int getNewCoverVariable(int id, int coverVariable) {
            switch (id) {
                case 0: {
                    return coverVariable & 0xFFFFFFFE;
                }
                case 1: {
                    return coverVariable | 1;
                }
                case 2: {
                    if (coverVariable > 5) {
                        return 6 | coverVariable & 0xFFFFFFF1;
                    }
                    return coverVariable & 0xFFFFFFF1;
                }
                case 3: {
                    if (coverVariable > 5) {
                        return 8 | coverVariable & 0xFFFFFFF1;
                    }
                    return 2 | coverVariable & 0xFFFFFFF1;
                }
                case 4: {
                    if (coverVariable > 5) {
                        return 0xA | coverVariable & 0xFFFFFFF1;
                    }
                    return 4 | coverVariable & 0xFFFFFFF1;
                }
                case 5: {
                    if (coverVariable > 5) break;
                    return coverVariable + 6;
                }
                case 6: {
                    if (coverVariable <= 5) break;
                    return coverVariable - 6;
                }
            }
            return coverVariable;
        }

        private boolean getClickable(int id, int coverVariable) {
            boolean bl;
            if (coverVariable < 0 | 11 < coverVariable) {
                return false;
            }
            switch (id) {
                case 0: 
                case 1: {
                    if ((1 & coverVariable) != id) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    if (coverVariable % 6 >= 2) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 3: {
                    bl = coverVariable % 6 < 2 | 4 <= coverVariable % 6;
                    break;
                }
                case 4: {
                    if (coverVariable % 6 < 4) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 5: {
                    if (coverVariable < 6) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 6: {
                    if (coverVariable >= 6) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }
    }
}

