/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.SoundResource;
import gregtech.api.items.GT_MetaBase_Item;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.objects.ItemData;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.common.blocks.GT_Block_Ores_Abstract;
import gregtech.common.blocks.GT_TileEntity_Ores;
import gregtech.common.items.behaviors.Behaviour_None;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidBlock;

public class Behaviour_Prospecting
extends Behaviour_None {
    private final int mVanillaCosts;
    private final int mEUCosts;
    private final String mTooltip = GT_LanguageManager.addStringLocalization("gt.behaviour.prospecting", "Usable for Prospecting");

    public Behaviour_Prospecting(int aVanillaCosts, int aEUCosts) {
        this.mVanillaCosts = aVanillaCosts;
        this.mEUCosts = aEUCosts;
    }

    @Override
    public boolean onItemUseFirst(GT_MetaBase_Item aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, ForgeDirection side, float hitX, float hitY, float hitZ) {
        if (aWorld.field_72995_K) {
            return false;
        }
        Block aBlock = aWorld.func_147439_a(aX, aY, aZ);
        if (aBlock == null) {
            return false;
        }
        byte aMeta = (byte)aWorld.func_72805_g(aX, aY, aZ);
        ItemData tAssociation = GT_OreDictUnificator.getAssociation(new ItemStack(aBlock, 1, (int)aMeta));
        if (tAssociation != null && tAssociation.mPrefix != null && tAssociation.mMaterial != null && tAssociation.mPrefix.toString().startsWith("ore")) {
            GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("100", "This is ") + tAssociation.mMaterial.mMaterial.mDefaultLocalName + GT_Utility.trans("101", " Ore."));
            GT_Utility.sendSoundToPlayers(aWorld, SoundResource.RANDOM_ANVIL_USE, 1.0f, -1.0f, aX, aY, aZ);
            return true;
        }
        if ((aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150348_b) || aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150424_aL) || aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150377_bs) || aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, GregTech_API.sBlockStones) || aBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, GregTech_API.sBlockGranites) || aBlock == GregTech_API.sBlockOresUb1 || aBlock == GregTech_API.sBlockOresUb2 || aBlock == GregTech_API.sBlockOresUb3 || aBlock == GregTech_API.sBlockOres1) && GT_ModHandler.damageOrDechargeItem(aStack, this.mVanillaCosts, this.mEUCosts, (EntityLivingBase)aPlayer)) {
            Block tBlock;
            GT_Utility.sendSoundToPlayers(aWorld, SoundResource.RANDOM_ANVIL_USE, 1.0f, -1.0f, aX, aY, aZ);
            int tQuality = aItem instanceof GT_MetaGenerated_Tool ? aItem.getHarvestLevel(aStack, "") : 0;
            int tX = aX;
            int tY = aY;
            int tZ = aZ;
            int j = 6 + tQuality;
            for (int i = 0; i < j; ++i) {
                tBlock = aWorld.func_147439_a(tX -= side.offsetX, tY -= side.offsetY, tZ -= side.offsetZ);
                if (tBlock == Blocks.field_150353_l || tBlock == Blocks.field_150356_k) {
                    GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("102", "There is Lava behind this Rock."));
                    break;
                }
                if (tBlock instanceof BlockLiquid || tBlock instanceof IFluidBlock) {
                    GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("103", "There is a Liquid behind this Rock."));
                    break;
                }
                if (tBlock == Blocks.field_150418_aU || !GT_Utility.hasBlockHitBox(aWorld, tX, tY, tZ)) {
                    GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("104", "There is an Air Pocket behind this Rock."));
                    break;
                }
                if (tBlock == aBlock) continue;
                if (i >= 4) break;
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("105", "Material is changing behind this Rock."));
                break;
            }
            XSTR tRandom = new XSTR(aX ^ aY ^ aZ ^ side.ordinal());
            int j2 = 9 + 2 * tQuality;
            for (int i = 0; i < j2; ++i) {
                tX = aX - 4 - tQuality + ((Random)tRandom).nextInt(j2);
                tBlock = aWorld.func_147439_a(tX, tY = aY - 4 - tQuality + ((Random)tRandom).nextInt(j2), tZ = aZ - 4 - tQuality + ((Random)tRandom).nextInt(j2));
                if (tBlock instanceof GT_Block_Ores_Abstract) {
                    Materials tMaterial;
                    TileEntity tTileEntity = aWorld.func_147438_o(tX, tY, tZ);
                    if (!(tTileEntity instanceof GT_TileEntity_Ores) || (tMaterial = GregTech_API.sGeneratedMaterials[((GT_TileEntity_Ores)tTileEntity).mMetaData % 1000]) == null || tMaterial == Materials._NULL) continue;
                    GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("106", "Found traces of ") + tMaterial.mDefaultLocalName + GT_Utility.trans("101", " Ore."));
                    return true;
                }
                int tMetaID = aWorld.func_72805_g(tX, tY, tZ);
                tAssociation = GT_OreDictUnificator.getAssociation(new ItemStack(tBlock, 1, tMetaID));
                if (tAssociation == null || tAssociation.mPrefix == null || tAssociation.mMaterial == null || !tAssociation.mPrefix.toString().startsWith("ore")) continue;
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("106", "Found traces of ") + tAssociation.mMaterial.mMaterial.mDefaultLocalName + GT_Utility.trans("101", " Ore."));
                return true;
            }
            GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("107", "No Ores found."));
            return true;
        }
        return false;
    }

    @Override
    public List<String> getAdditionalToolTips(GT_MetaBase_Item aItem, List<String> aList, ItemStack aStack) {
        aList.add(this.mTooltip);
        return aList;
    }
}

