/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.data;

import com.google.common.cache.CacheLoader;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.log.JMLogger;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.EntityDTO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.biome.BiomeGenBase;

public class PlayerData
extends CacheLoader<Class, EntityDTO> {
    public static boolean playerIsUnderground(Minecraft mc, EntityPlayer player) {
        if (ForgeHelper.INSTANCE.hasNoSky(player.func_130014_f_())) {
            return true;
        }
        int posX = MathHelper.func_76128_c((double)player.field_70165_t);
        int posY = MathHelper.func_76128_c((double)ForgeHelper.INSTANCE.getEntityBoundingBox((EntityLivingBase)player).field_72338_b);
        int posZ = MathHelper.func_76128_c((double)player.field_70161_v);
        boolean offset = true;
        boolean isUnderground = true;
        if (posY < 0) {
            return true;
        }
        int y = posY;
        block0: for (int x = posX - 1; x <= posX + 1; ++x) {
            for (int z = posZ - 1; z <= posZ + 1; ++z) {
                y = posY + 1;
                ChunkMD chunkMD = DataCache.instance().getChunkMD(new ChunkCoordIntPair(x >> 4, z >> 4));
                if (chunkMD == null || chunkMD.ceiling(x & 0xF, z & 0xF) > y) continue;
                isUnderground = false;
                break block0;
            }
        }
        return isUnderground;
    }

    public EntityDTO load(Class aClass) throws Exception {
        Minecraft mc = ForgeHelper.INSTANCE.getClient();
        EntityClientPlayerMP player = mc.field_71439_g;
        EntityDTO dto = DataCache.instance().getEntityDTO((EntityLivingBase)player);
        dto.update((EntityLivingBase)player, false);
        dto.biome = this.getPlayerBiome((EntityPlayer)player);
        dto.underground = PlayerData.playerIsUnderground(mc, (EntityPlayer)player);
        return dto;
    }

    private String getPlayerBiome(EntityPlayer player) {
        int x = MathHelper.func_76128_c((double)player.field_70165_t) >> 4 & 0xF;
        int z = MathHelper.func_76128_c((double)player.field_70161_v) >> 4 & 0xF;
        ChunkMD playerChunk = DataCache.instance().getChunkMD(new ChunkCoordIntPair(player.field_70176_ah, player.field_70164_aj));
        if (playerChunk != null) {
            try {
                BiomeGenBase biome = ForgeHelper.INSTANCE.getBiome(MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70163_u), MathHelper.func_76128_c((double)player.field_70161_v));
                if (biome != null) {
                    return biome.field_76791_y;
                }
            }
            catch (Exception e) {
                JMLogger.logOnce("Couldn't get player biome: " + e.getMessage(), e);
            }
        }
        return "?";
    }

    public long getTTL() {
        return JourneymapClient.getCoreProperties().cachePlayerData.get();
    }
}

