/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.abstractpackets;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.ModernPacket;

public abstract class StringListPacket
extends ModernPacket {
    private List<String> stringList = new ArrayList<String>();

    public StringListPacket(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        int size = data.readInt();
        for (int i = 0; i < size; ++i) {
            this.getStringList().add(data.readUTF());
        }
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        data.writeInt(this.getStringList().size());
        for (int i = 0; i < this.getStringList().size(); ++i) {
            data.writeUTF(this.getStringList().get(i));
        }
    }

    public List<String> getStringList() {
        return this.stringList;
    }

    public StringListPacket setStringList(List<String> stringList) {
        this.stringList = stringList;
        return this;
    }
}

