/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import java.util.ArrayList;
import java.util.List;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.tuples.LPPosition;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldUtil {
    private final int _x;
    private final int _y;
    private final int _z;
    private final World _worldObj;

    public WorldUtil(World worldObj, int x, int y, int z) {
        this._worldObj = worldObj;
        this._x = x;
        this._y = y;
        this._z = z;
    }

    public WorldUtil(TileEntity tile) {
        this._worldObj = tile.func_145831_w();
        this._x = tile.field_145851_c;
        this._y = tile.field_145848_d;
        this._z = tile.field_145849_e;
    }

    public List<AdjacentTile> getAdjacentTileEntities() {
        return this.getAdjacentTileEntities(false);
    }

    public List<AdjacentTile> getAdjacentTileEntities(boolean flag) {
        ArrayList<AdjacentTile> foundTiles = new ArrayList<AdjacentTile>(6);
        TileEntity tilePipe = null;
        if (flag) {
            tilePipe = this._worldObj.func_147438_o(this._x, this._y, this._z);
        }
        for (ForgeDirection o : ForgeDirection.values()) {
            TileEntity tile;
            if (o == ForgeDirection.UNKNOWN || (tile = this.getAdjacentTileEntitie(o)) == null || flag && SimpleServiceLocator.pipeInformationManager.isItemPipe(tilePipe) && !MainProxy.checkPipesConnections(tilePipe, tile, o)) continue;
            foundTiles.add(new AdjacentTile(tile, o));
        }
        return foundTiles;
    }

    public TileEntity getAdjacentTileEntitie(ForgeDirection direction) {
        LPPosition p = new LPPosition(this._x, this._y, this._z);
        p.moveForward(direction);
        return p.getTileEntity(this._worldObj);
    }
}

