/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.loader.extras;

import com.kuba6000.mobsinfo.api.ConstructableItemStack;
import com.kuba6000.mobsinfo.api.IChanceModifier;
import com.kuba6000.mobsinfo.api.MobDrop;
import com.kuba6000.mobsinfo.api.MobRecipe;
import com.kuba6000.mobsinfo.loader.extras.IExtraLoader;
import com.kuba6000.mobsinfo.loader.extras.Translations;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import tconstruct.armor.TinkerArmor;
import tconstruct.library.tools.ToolCore;
import tconstruct.tools.TinkerTools;
import tconstruct.util.config.PHConstruct;

public class TinkersConstruct
implements IExtraLoader {
    @Override
    public void process(String k, ArrayList<MobDrop> drops, MobRecipe recipe) {
        MobDrop drop;
        if (recipe.entity.getClass() == EntityGhast.class) {
            if (PHConstruct.uhcGhastDrops) {
                for (MobDrop mobDrop : drops) {
                    if (mobDrop.stack.func_77973_b() != Items.field_151073_bk) continue;
                    mobDrop.stack = new ItemStack(Items.field_151043_k);
                    mobDrop.reconstructableStack = new ConstructableItemStack(mobDrop.stack);
                }
            } else {
                for (MobDrop mobDrop : drops) {
                    if (mobDrop.stack.func_77973_b() != Items.field_151073_bk) continue;
                    mobDrop.chance += 10000;
                    mobDrop.clampChance();
                }
            }
        }
        if (recipe.entity instanceof EntitySkeleton) {
            drop = new MobDrop(new ItemStack(Items.field_151144_bL, 1, ((EntitySkeleton)recipe.entity).func_82202_m()), MobDrop.DropType.Normal, 0, null, null, false, false);
            drop.variableChance = true;
            drop.chanceModifiers.add(new BeheadingModifier(10.0, 20.0));
            drops.add(drop);
            if (((EntitySkeleton)recipe.entity).func_82202_m() == 1) {
                MobDrop mobDrop = new MobDrop(new ItemStack(TinkerTools.materials, 1, 8), MobDrop.DropType.Normal, 2000, null, null, true, false);
                drops.add(mobDrop);
            }
        }
        if (recipe.entity.getClass() == EntityZombie.class) {
            drop = new MobDrop(new ItemStack(Items.field_151144_bL, 1, 2), MobDrop.DropType.Normal, 0, null, null, false, false);
            drop.variableChance = true;
            drop.chanceModifiers.add(new BeheadingModifier(10.0, 20.0));
            drops.add(drop);
            MobDrop mobDrop = new MobDrop(new ItemStack(TinkerTools.materials, 1, 2), MobDrop.DropType.Normal, 0, null, null, true, false);
            mobDrop.variableChance = true;
            mobDrop.chanceModifiers.addAll(Arrays.asList(new IExtraLoader.NormalChance(10.0), new IExtraLoader.DropsOnlyUsing((Item)TinkerTools.cleaver)));
            drops.add(mobDrop);
        }
        if (recipe.entity.getClass() == EntityCreeper.class) {
            drop = new MobDrop(new ItemStack(Items.field_151144_bL, 1, 4), MobDrop.DropType.Normal, 0, null, null, false, false);
            drop.variableChance = true;
            drop.chanceModifiers.add(new BeheadingModifier(5.0, 10.0));
            drops.add(drop);
        }
        if (recipe.entity instanceof IMob) {
            drop = new MobDrop(new ItemStack(TinkerArmor.heartCanister, 1, 1), MobDrop.DropType.Normal, 50, null, null, false, false);
            drops.add(drop);
        }
        if (recipe.entity instanceof IBossDisplayData) {
            String entityName = recipe.entity.getClass().getSimpleName().toLowerCase();
            for (String name : PHConstruct.heartDropBlacklist) {
                if (!name.toLowerCase(Locale.US).equals(entityName)) continue;
                return;
            }
            MobDrop mobDrop = new MobDrop(new ItemStack(TinkerArmor.heartCanister, recipe.entity instanceof EntityDragon ? 5 : 1, 3), MobDrop.DropType.Normal, 10000, null, null, false, false);
            drops.add(mobDrop);
        }
    }

    private static class BeheadingModifier
    implements IChanceModifier {
        double m1;
        double m2;

        BeheadingModifier() {
        }

        BeheadingModifier(double m1, double m2) {
            this.m1 = m1;
            this.m2 = m2;
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void applyTooltip(List<String> currentTooltip) {
            currentTooltip.addAll(Arrays.asList(Translations.BASE_CHANCE.get(0.0), Translations.TINKERS_CONSTRUCT_BEHEADING.get(this.m1), Translations.TINKERS_CONSTRUCT_BEHEADING_1.get(this.m2)));
        }

        @Override
        public double apply(double chance, @Nonnull World world, @Nonnull List<ItemStack> drops, Entity attacker, EntityLiving victim) {
            if (!(attacker instanceof EntityPlayer)) {
                return 0.0;
            }
            ItemStack stack = ((EntityPlayer)attacker).func_71045_bC();
            if (stack != null && stack.func_77942_o() && stack.func_77973_b() instanceof ToolCore) {
                int beheading = stack.func_77978_p().func_74775_l("InfiTool").func_74762_e("Beheading");
                if (stack.func_77973_b() == TinkerTools.cleaver) {
                    beheading += 2;
                }
                return this.m1 * (double)beheading;
            }
            return 0.0;
        }

        @Override
        public void writeToByteBuf(ByteBuf byteBuf) {
            byteBuf.writeDouble(this.m1);
            byteBuf.writeDouble(this.m2);
        }

        @Override
        public void readFromByteBuf(ByteBuf byteBuf) {
            this.m1 = byteBuf.readDouble();
            this.m2 = byteBuf.readDouble();
        }
    }
}

