/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.drawable;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.TextRenderer;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.common.internal.JsonHelper;
import com.gtnewhorizons.modularui.common.internal.Theme;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import org.jetbrains.annotations.ApiStatus;

public class Text
implements IDrawable {
    public static final Text EMPTY = new Text("");
    private static final TextRenderer renderer = new TextRenderer();
    private Alignment alignment = Alignment.Center;
    private final String text;
    private String formatting = "";
    @Nullable
    private Supplier<Object[]> localisationData;
    private int color;
    private boolean shadow = false;

    public Text(String text) {
        this.text = Objects.requireNonNull(text, "String in Text can't be null!");
        this.color = Theme.INSTANCE.getText();
    }

    public static Text localised(String key, Object ... data) {
        return new Text(key).localise(data);
    }

    public static Text of(ChatComponentText textComponent) {
        return new Text(textComponent.func_150254_d());
    }

    public Text color(int color) {
        this.color = Color.withAlpha(color, 255);
        return this;
    }

    public Text format(EnumChatFormatting color) {
        this.formatting = color.toString() + this.formatting;
        return this;
    }

    public Text shadow(boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    public Text localise(Supplier<Object[]> localisationData) {
        this.localisationData = localisationData;
        return this;
    }

    public Text localise(Object ... localisationData) {
        this.localise(() -> localisationData);
        return this;
    }

    public Text shadow() {
        return this.shadow(true);
    }

    public Text alignment(Alignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public boolean hasColor() {
        return Color.getAlpha(this.color) > 0;
    }

    public boolean hasShadow() {
        return this.shadow;
    }

    public String getRawText() {
        return this.text;
    }

    public String getFormatting() {
        return this.formatting;
    }

    @ApiStatus.Internal
    public void setFormatting(String formatting) {
        this.formatting = formatting;
    }

    @Override
    public void applyThemeColor(int color) {
        renderer.setColor(this.hasColor() ? this.color : Theme.INSTANCE.getText());
    }

    @Override
    public void draw(float x, float y, float width, float height, float partialTicks) {
        renderer.setPos((int)((double)x + 0.5), (int)((double)y + 0.5));
        renderer.setShadow(this.shadow);
        renderer.setAlignment(this.alignment, width, height);
        renderer.draw(this.getFormatted());
    }

    public String getFormatted() {
        String text = this.getRawText();
        if (this.localisationData != null && FMLCommonHandler.instance().getSide().isClient()) {
            text = I18n.func_135052_a((String)text, (Object[])this.localisationData.get()).replaceAll("\\\\n", "\n");
        }
        if (!this.formatting.isEmpty()) {
            text = this.formatting + text;
        }
        return text;
    }

    public static String getFormatted(Text ... texts) {
        StringBuilder builder = new StringBuilder();
        for (Text text : texts) {
            builder.append(text.getFormatted());
        }
        return builder.toString();
    }

    public static Text ofJson(JsonElement json) {
        if (json.isJsonObject()) {
            JsonObject jsonObject = json.getAsJsonObject();
            Text text = new Text(JsonHelper.getString(jsonObject, "E:404", "text"));
            text.shadow(JsonHelper.getBoolean(jsonObject, false, "shadow"));
            Integer color = JsonHelper.getElement(jsonObject, null, Color::ofJson, "color");
            if (color != null) {
                text.color(color);
            }
            if (JsonHelper.getBoolean(jsonObject, false, "localise")) {
                text.localise(new Object[0]);
            }
            return text;
        }
        if (!json.isJsonArray()) {
            return new Text(json.getAsString());
        }
        return new Text("");
    }
}

