/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.builder;

import com.gtnewhorizons.modularui.ModularUI;
import com.gtnewhorizons.modularui.api.screen.IContainerCreator;
import com.gtnewhorizons.modularui.api.screen.IGuiCreator;
import com.gtnewhorizons.modularui.common.internal.InternalUIMapper;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class UIInfo<CC extends IContainerCreator, GC extends IGuiCreator> {
    private final int id;
    private final CC containerCreator;
    private final GC guiCreator;

    UIInfo(CC containerCreator, GC guiCreator) {
        this.id = InternalUIMapper.getInstance().register(containerCreator, guiCreator);
        this.containerCreator = containerCreator;
        this.guiCreator = guiCreator;
    }

    public void open(EntityPlayer player, World world, int x, int y, int z) {
        if (NetworkUtils.isClient()) {
            ModularUI.logger.warn("Please use UIInfos.openClientUI to open a client only ui!");
        }
        FMLNetworkHandler.openGui((EntityPlayer)player, (Object)ModularUI.INSTANCE, (int)this.id, (World)world, (int)x, (int)y, (int)z);
    }

    public void open(EntityPlayer player, World world, Vec3 pos) {
        this.open(player, world, (int)pos.field_72450_a, (int)pos.field_72448_b, (int)pos.field_72449_c);
    }

    public void open(EntityPlayer player) {
        this.open(player, player.func_130014_f_(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
    }
}

