/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget;

import com.gtnewhorizons.modularui.api.math.CrossAxisAlignment;
import com.gtnewhorizons.modularui.api.math.MainAxisAlignment;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.IWidgetParent;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.MultiChildWidget;
import org.jetbrains.annotations.NotNull;

public class Column
extends MultiChildWidget
implements IWidgetBuilder<Column> {
    private MainAxisAlignment maa = MainAxisAlignment.START;
    private CrossAxisAlignment caa = CrossAxisAlignment.START;
    private int maxHeight = -1;
    private int maxWidth = 0;
    private Integer space;
    protected boolean skipDisabledChild = false;

    @Override
    public void addWidgetInternal(Widget widget) {
        this.addChild(widget);
    }

    @Override
    @NotNull
    protected Size determineSize(int maxWidth, int maxHeight) {
        if (this.maa == MainAxisAlignment.START) {
            return IWidgetParent.getSizeOf(this.children);
        }
        return new Size(this.maxWidth, this.maxHeight);
    }

    @Override
    public void layoutChildren(int maxWidthC, int maxHeightC) {
        if (this.maxHeight < 0 && this.maa != MainAxisAlignment.START) {
            this.maxHeight = this.isAutoSized() ? maxHeightC - this.getPos().x : this.getSize().height;
        }
        this.maxWidth = 0;
        int totalHeight = 0;
        for (Widget widget : this.getChildren()) {
            if (this.skipDisabledChild && !widget.isEnabled()) continue;
            totalHeight += widget.getSize().height;
            this.maxWidth = Math.max(this.maxWidth, widget.getSize().width);
        }
        int lastY = 0;
        if (this.maa == MainAxisAlignment.CENTER) {
            lastY = (int)((float)this.maxHeight / 2.0f - (float)totalHeight / 2.0f);
        } else if (this.maa == MainAxisAlignment.END) {
            lastY = this.maxHeight - totalHeight;
        }
        for (Widget widget : this.getChildren()) {
            if (this.skipDisabledChild && !widget.isEnabled()) continue;
            int x = widget.getPos().x;
            if (this.caa == CrossAxisAlignment.CENTER) {
                x = (int)((float)this.maxWidth / 2.0f - (float)widget.getSize().width / 2.0f);
            } else if (this.caa == CrossAxisAlignment.END) {
                x = this.maxWidth - widget.getSize().width;
            }
            widget.setPosSilent(new Pos2d(x, lastY));
            lastY += widget.getSize().height;
            if (this.maa != MainAxisAlignment.SPACE_BETWEEN) continue;
            if (this.space != null) {
                lastY += this.space.intValue();
                continue;
            }
            lastY += (this.maxHeight - totalHeight) / (this.getChildren().size() - 1);
        }
    }

    public Column setAlignment(MainAxisAlignment maa) {
        return this.setAlignment(maa, this.caa);
    }

    public Column setAlignment(CrossAxisAlignment caa) {
        return this.setAlignment(this.maa, caa);
    }

    public Column setAlignment(MainAxisAlignment maa, CrossAxisAlignment caa) {
        this.maa = maa;
        this.caa = caa;
        return this;
    }

    public Column setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public Column setSpace(int space) {
        this.space = space;
        return this;
    }
}

