/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.network;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.util.BiomeSearchWorker;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.biome.BiomeGenBase;

public class PacketSync
implements IMessage {
    private boolean canTeleport;
    private Set<BiomeGenBase> availableBiomes;
    private int oldDimensionId;
    private boolean completedSearch;

    public PacketSync() {
    }

    public PacketSync(boolean canTeleport, Set<BiomeGenBase> availableBiomes, int oldDimensionId, boolean completedSearch) {
        this.canTeleport = canTeleport;
        this.availableBiomes = availableBiomes;
        this.oldDimensionId = oldDimensionId;
        this.completedSearch = completedSearch;
    }

    public void fromBytes(ByteBuf buf) {
        this.canTeleport = buf.readBoolean();
        this.availableBiomes = new HashSet<BiomeGenBase>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.availableBiomes.add(BiomeGenBase.func_150568_d((int)buf.readInt()));
        }
        this.oldDimensionId = buf.readInt();
        this.completedSearch = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.canTeleport);
        buf.writeInt(this.availableBiomes.size());
        for (BiomeGenBase biome : this.availableBiomes) {
            buf.writeInt(biome.field_76756_M);
        }
        buf.writeInt(this.oldDimensionId);
        buf.writeBoolean(this.completedSearch);
    }

    public static class Handler
    implements IMessageHandler<PacketSync, IMessage> {
        public IMessage onMessage(PacketSync packet, MessageContext ctx) {
            NaturesCompass.canTeleport = packet.canTeleport;
            BiomeSearchWorker.availableBiomes = packet.availableBiomes;
            BiomeSearchWorker.oldDimensionId = packet.oldDimensionId;
            BiomeSearchWorker.completedSearch = packet.completedSearch;
            return null;
        }
    }
}

