/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;

public class Inventory {
    private TileEntityChest chest;
    List<Integer> shuffledSlots;

    public Inventory(Random rand, TileEntityChest chest) {
        this.chest = chest;
        this.shuffledSlots = new ArrayList<Integer>();
        for (int i = 0; i < this.getInventorySize(); ++i) {
            this.shuffledSlots.add(i);
        }
        Collections.shuffle(this.shuffledSlots, rand);
    }

    public boolean setRandomEmptySlot(ItemStack item) {
        int slot = this.getRandomEmptySlot();
        if (slot < 0) {
            return false;
        }
        return this.setInventorySlot(slot, item);
    }

    private int getRandomEmptySlot() {
        for (int slot : this.shuffledSlots) {
            if (!this.isEmptySlot(slot)) continue;
            return slot;
        }
        return -1;
    }

    public boolean isEmptySlot(int slot) {
        try {
            return this.chest.func_70301_a(slot) == null;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public boolean setInventorySlot(int slot, ItemStack item) {
        try {
            this.chest.func_70299_a(slot, item);
            return true;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public int getInventorySize() {
        if (this.chest == null) {
            return 0;
        }
        try {
            return this.chest.func_70302_i_();
        }
        catch (NullPointerException e) {
            return 0;
        }
    }
}

