/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public interface IForgePlayer {
    private Player self() {
        return (Player)this;
    }

    default public double getAttackRange() {
        double range = this.self().m_21133_(ForgeMod.ATTACK_RANGE.get());
        return range == 0.0 ? 0.0 : range + (double)(this.self().m_7500_() ? 3 : 0);
    }

    default public double getReachDistance() {
        double reach = this.self().m_21133_(ForgeMod.REACH_DISTANCE.get());
        return reach == 0.0 ? 0.0 : reach + (this.self().m_7500_() ? 0.5 : 0.0);
    }

    default public boolean canHit(Entity entity, double padding) {
        return this.isCloseEnough(entity, this.getAttackRange() + padding);
    }

    default public boolean canInteractWith(Entity entity, double padding) {
        return this.isCloseEnough(entity, this.getReachDistance() + padding);
    }

    default public boolean isCloseEnough(Entity entity, double dist) {
        Vec3 eye = this.self().m_146892_();
        Vec3 targetCenter = entity.m_20318_(1.0f).m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0);
        Optional hit = entity.m_20191_().m_82371_(eye, targetCenter);
        return (hit.isPresent() ? eye.m_82557_((Vec3)hit.get()) : this.self().m_20280_(entity)) < dist * dist;
    }

    default public boolean canInteractWith(BlockPos pos, double padding) {
        double reach = this.getReachDistance() + padding;
        return this.self().m_146892_().m_82531_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) < reach * reach;
    }
}

