/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ItemLayerModel
implements IUnbakedGeometry<ItemLayerModel> {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private ImmutableList<Material> textures;
    private final IntSet emissiveLayers;
    private final Int2ObjectMap<ResourceLocation> renderTypeNames;
    private final boolean deprecatedLoader;
    private final boolean logWarning;

    public ItemLayerModel(@Nullable ImmutableList<Material> textures, IntSet emissiveLayers, Int2ObjectMap<ResourceLocation> renderTypeNames) {
        this(textures, emissiveLayers, renderTypeNames, false, false);
    }

    private ItemLayerModel(@Nullable ImmutableList<Material> textures, IntSet emissiveLayers, Int2ObjectMap<ResourceLocation> renderTypeNames, boolean deprecatedLoader, boolean logWarning) {
        this.textures = textures;
        this.emissiveLayers = emissiveLayers;
        this.renderTypeNames = renderTypeNames;
        this.deprecatedLoader = deprecatedLoader;
        this.logWarning = logWarning;
    }

    @Override
    public BakedModel bake(IGeometryBakingContext context, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        if (this.textures == null) {
            throw new IllegalStateException("Textures have not been initialized. Either pass them in through the constructor or call getMaterials(...) first.");
        }
        if (this.deprecatedLoader) {
            LOGGER.warn("Model \"" + modelLocation + "\" is using the deprecated loader \"forge:item-layers\" instead of \"forge:item_layers\". This loader will be removed in 1.20.");
        }
        if (this.logWarning) {
            LOGGER.warn("Model \"" + modelLocation + "\" is using the deprecated \"fullbright_layers\" field in its item layer model instead of \"emissive_layers\". This field will be removed in 1.20.");
        }
        TextureAtlasSprite particle = spriteGetter.apply(context.hasMaterial("particle") ? context.getMaterial("particle") : (Material)this.textures.get(0));
        Transformation rootTransform = context.getRootTransform();
        if (!rootTransform.isIdentity()) {
            modelState = new SimpleModelState(modelState.m_6189_().m_121096_(rootTransform), modelState.m_7538_());
        }
        RenderTypeGroup normalRenderTypes = new RenderTypeGroup(RenderType.m_110466_(), ForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get());
        CompositeModel.Baked.Builder builder = CompositeModel.Baked.builder(context, particle, overrides, context.getTransforms());
        for (int i = 0; i < this.textures.size(); ++i) {
            ResourceLocation renderTypeName;
            TextureAtlasSprite sprite = spriteGetter.apply((Material)this.textures.get(i));
            List<BlockElement> unbaked = UnbakedGeometryHelper.createUnbakedItemElements(i, sprite);
            List<BakedQuad> quads = UnbakedGeometryHelper.bakeElements(unbaked, $ -> sprite, modelState, modelLocation);
            if (this.emissiveLayers.contains(i)) {
                QuadTransformers.settingMaxEmissivity().processInPlace(quads);
            }
            RenderTypeGroup renderTypes = (renderTypeName = (ResourceLocation)this.renderTypeNames.get(i)) != null ? context.getRenderType(renderTypeName) : null;
            builder.addQuads(renderTypes != null ? renderTypes : normalRenderTypes, quads);
        }
        return builder.build();
    }

    @Override
    public Collection<Material> getMaterials(IGeometryBakingContext context, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        if (this.textures != null) {
            return this.textures;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        if (context.hasMaterial("particle")) {
            builder.add((Object)context.getMaterial("particle"));
        }
        int i = 0;
        while (context.hasMaterial("layer" + i)) {
            builder.add((Object)context.getMaterial("layer" + i));
            ++i;
        }
        this.textures = builder.build();
        return this.textures;
    }

    public static final class Loader
    implements IGeometryLoader<ItemLayerModel> {
        public static final Loader INSTANCE = new Loader(false);
        @Deprecated(forRemoval=true, since="1.19")
        public static final Loader INSTANCE_DEPRECATED = new Loader(true);
        private final boolean deprecated;

        private Loader(boolean deprecated) {
            this.deprecated = deprecated;
        }

        @Override
        public ItemLayerModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            Int2ObjectOpenHashMap renderTypeNames = new Int2ObjectOpenHashMap();
            if (jsonObject.has("render_types")) {
                JsonObject renderTypes = jsonObject.getAsJsonObject("render_types");
                for (Map.Entry entry : renderTypes.entrySet()) {
                    ResourceLocation renderType = new ResourceLocation((String)entry.getKey());
                    for (JsonElement layer : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                        if (renderTypeNames.put(layer.getAsInt(), (Object)renderType) == null) continue;
                        throw new JsonParseException("Registered duplicate render type for layer " + layer);
                    }
                }
            }
            IntOpenHashSet emissiveLayers = new IntOpenHashSet();
            this.readUnlit(jsonObject, "emissive_layers", (Int2ObjectOpenHashMap<ResourceLocation>)renderTypeNames, emissiveLayers, false);
            boolean logWarning = this.readUnlit(jsonObject, "fullbright_layers", (Int2ObjectOpenHashMap<ResourceLocation>)renderTypeNames, emissiveLayers, true);
            return new ItemLayerModel(null, (IntSet)emissiveLayers, (Int2ObjectMap<ResourceLocation>)renderTypeNames, this.deprecated, logWarning);
        }

        private boolean readUnlit(JsonObject jsonObject, String name, Int2ObjectOpenHashMap<ResourceLocation> renderTypeNames, IntOpenHashSet litLayers, boolean logWarning) {
            if (!jsonObject.has(name)) {
                return false;
            }
            JsonArray fullbrightLayers = jsonObject.getAsJsonArray(name);
            ResourceLocation renderType = new ResourceLocation("forge", "item_unlit");
            for (JsonElement layer : fullbrightLayers) {
                litLayers.add(layer.getAsInt());
                renderTypeNames.putIfAbsent(layer.getAsInt(), (Object)renderType);
            }
            return logWarning && !fullbrightLayers.isEmpty();
        }
    }
}

