/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Iterator;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.client.SetCameraView;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.network.PacketDistributor;

public class SecurityCameraBlock
extends OwnableBlock {
    public static final DirectionProperty FACING = DirectionProperty.m_61546_((String)"facing", facing -> facing != Direction.UP);
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty BEING_VIEWED = BooleanProperty.m_61465_((String)"being_viewed");
    private static final VoxelShape SHAPE_SOUTH = Shapes.m_83064_((AABB)new AABB((double)0.275f, 0.25, 0.0, (double)0.7f, (double)0.8f, (double)0.85f));
    private static final VoxelShape SHAPE_NORTH = Shapes.m_83064_((AABB)new AABB((double)0.275f, 0.25, (double)0.15f, (double)0.7f, (double)0.8f, 1.0));
    private static final VoxelShape SHAPE_WEST = Shapes.m_83064_((AABB)new AABB(0.125, 0.25, (double)0.275f, 1.0, (double)0.8f, (double)0.725f));
    private static final VoxelShape SHAPE = Shapes.m_83064_((AABB)new AABB(0.0, 0.25, (double)0.275f, (double)0.85f, (double)0.8f, (double)0.725f));
    private static final VoxelShape SHAPE_DOWN = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)7.0, (double)15.0, (double)5.0, (double)9.0, (double)16.0, (double)11.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)6.0, (double)15.0, (double)6.0, (double)7.0, (double)16.0, (double)10.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)15.0, (double)7.0, (double)6.0, (double)16.0, (double)9.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)9.0, (double)15.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)10.0, (double)15.0, (double)7.0, (double)11.0, (double)16.0, (double)9.0), (VoxelShape)Block.m_49796_((double)7.0, (double)14.0, (double)7.0, (double)9.0, (double)15.0, (double)9.0))))));

    public SecurityCameraBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BEING_VIEWED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return Shapes.m_83040_();
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return state.m_61143_((Property)FACING) == Direction.DOWN ? RenderShape.MODEL : RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (player.m_7500_() && (blockEntity = level.m_7702_(pos)) instanceof IModuleInventory) {
            IModuleInventory inv = (IModuleInventory)blockEntity;
            inv.getInventory().clear();
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof IModuleInventory) {
                IModuleInventory inv = (IModuleInventory)blockEntity;
                inv.dropAllModules();
            }
            if (!newState.m_155947_()) {
                level.m_46747_(pos);
            }
        }
        level.m_46672_(pos.m_122012_(), state.m_60734_());
        level.m_46672_(pos.m_122019_(), state.m_60734_());
        level.m_46672_(pos.m_122029_(), state.m_60734_());
        level.m_46672_(pos.m_122024_(), state.m_60734_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.DOWN -> SHAPE_DOWN;
            default -> SHAPE;
        };
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return ctx.m_43719_() != Direction.UP ? this.getStateForPlacement(ctx.m_43725_(), ctx.m_8083_(), ctx.m_43719_(), ctx.m_43720_().f_82479_, ctx.m_43720_().f_82480_, ctx.m_43720_().f_82481_, ctx.m_43723_()) : null;
    }

    public BlockState getStateForPlacement(Level level, BlockPos pos, Direction facing, double hitX, double hitY, double hitZ, Player placer) {
        BlockState state;
        block1: {
            Direction newFacing;
            state = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing);
            if (this.m_7898_(state, (LevelReader)level, pos)) break block1;
            Iterator iterator = Direction.Plane.HORIZONTAL.iterator();
            while (iterator.hasNext() && !this.m_7898_(state = (BlockState)state.m_61124_((Property)FACING, (Comparable)(newFacing = (Direction)iterator.next())), (LevelReader)level, pos)) {
            }
        }
        return state;
    }

    public void mountCamera(Level level, BlockPos pos, Player player) {
        if (!level.f_46443_) {
            SecurityCamera dummyEntity;
            ServerLevel serverLevel = (ServerLevel)level;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SectionPos chunkPos = SectionPos.m_123199_((BlockPos)pos);
            int viewDistance = serverPlayer.f_8924_.m_6846_().m_11312_();
            Entity entity = serverPlayer.m_8954_();
            if (entity instanceof SecurityCamera) {
                SecurityCamera cam = (SecurityCamera)entity;
                dummyEntity = new SecurityCamera(level, pos, cam);
            } else {
                dummyEntity = new SecurityCamera(level, pos);
            }
            level.m_7967_((Entity)dummyEntity);
            dummyEntity.setChunkLoadingDistance(viewDistance);
            for (int x = chunkPos.m_123341_() - viewDistance; x <= chunkPos.m_123341_() + viewDistance; ++x) {
                for (int z = chunkPos.m_123343_() - viewDistance; z <= chunkPos.m_123343_() + viewDistance; ++z) {
                    ForgeChunkManager.forceChunk((ServerLevel)serverLevel, (String)"securitycraft", (Entity)dummyEntity, (int)x, (int)z, (boolean)true, (boolean)false);
                }
            }
            serverPlayer.f_8926_ = dummyEntity;
            SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SetCameraView(dummyEntity));
            entity = level.m_7702_(pos);
            if (entity instanceof SecurityCameraBlockEntity) {
                SecurityCameraBlockEntity cam = (SecurityCameraBlockEntity)entity;
                cam.startViewing();
            }
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return BlockUtils.isSideSolid(level, pos.m_121945_(facing.m_122424_()), facing);
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && ((IModuleInventory)level.m_7702_(pos)).isModuleEnabled(ModuleType.REDSTONE)) {
            return 15;
        }
        return 0;
    }

    public int m_6376_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && ((IModuleInventory)level.m_7702_(pos)).isModuleEnabled(ModuleType.REDSTONE) && state.m_61143_((Property)FACING) == side) {
            return 15;
        }
        return 0;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean flag) {
        if (!this.m_7898_(level.m_8055_(pos), (LevelReader)level, pos) && !this.m_7898_(state, (LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWERED, BEING_VIEWED});
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SecurityCameraBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return SecurityCameraBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)SCContent.SECURITY_CAMERA_BLOCK_ENTITY.get()), LevelUtils::blockEntityTicker);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (facing.m_122434_() != Direction.Axis.Z) break;
                return (BlockState)state.m_61124_((Property)FACING, (Comparable)facing.m_122424_());
            }
            case FRONT_BACK: {
                if (facing.m_122434_() != Direction.Axis.X) break;
                return (BlockState)state.m_61124_((Property)FACING, (Comparable)facing.m_122424_());
            }
        }
        return state;
    }
}

