/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.block.entity;

import ad_astra_giselle_addon.common.block.entity.AddonMachineBlockEntity;
import ad_astra_giselle_addon.common.block.entity.IRangedWorkingAreaBlockEntity;
import ad_astra_giselle_addon.common.block.entity.IRocketSensingType;
import ad_astra_giselle_addon.common.block.entity.RocketSensingType;
import ad_astra_giselle_addon.common.config.MachinesConfig;
import ad_astra_giselle_addon.common.menu.RocketSensorMenu;
import ad_astra_giselle_addon.common.registry.AddonBlockEntityTypes;
import earth.terrarium.ad_astra.common.entity.vehicle.Rocket;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RocketSensorBlockEntity
extends AddonMachineBlockEntity
implements IRangedWorkingAreaBlockEntity {
    public static final String DATA_WORKINGAREA_VISIBLE_KEY = "workingAreaVisible";
    public static final String DATA_SENSING_TYPE_KEY = "sensingType";
    public static final String DATA_INVERTED_KEY = "inverted";
    public static final String DATA_ANALOG_SIGNAL_KEY = "analogSignal";
    private boolean workingAreaVisible = false;
    private IRocketSensingType sensingType = RocketSensingType.DISABLED;
    private boolean inverted = false;
    private int analogSignal = 0;
    private Rocket cachedTarget;

    public RocketSensorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)AddonBlockEntityTypes.ROCKET_SENSOR.get(), pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.workingAreaVisible = nbt.m_128471_(DATA_WORKINGAREA_VISIBLE_KEY);
        this.sensingType = IRocketSensingType.readNBT(nbt.m_128423_(DATA_SENSING_TYPE_KEY));
        this.inverted = nbt.m_128471_(DATA_INVERTED_KEY);
        this.analogSignal = nbt.m_128451_(DATA_ANALOG_SIGNAL_KEY);
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_(DATA_WORKINGAREA_VISIBLE_KEY, this.workingAreaVisible);
        nbt.m_128365_(DATA_SENSING_TYPE_KEY, IRocketSensingType.writeNBT(this.sensingType));
        nbt.m_128379_(DATA_INVERTED_KEY, this.inverted);
        nbt.m_128405_(DATA_ANALOG_SIGNAL_KEY, this.analogSignal);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new RocketSensorMenu(windowId, inv, this);
    }

    public void tick() {
        Level level = this.m_58904_();
        if (!level.m_5776_()) {
            int analogSignal;
            Rocket newTarget = this.findRocket();
            int n = analogSignal = newTarget != null ? this.getSensingType().getAnalogSignal(newTarget) : 0;
            if (this.isInverted()) {
                analogSignal = 15 - analogSignal;
            }
            if (this.getCachedTarget() != newTarget) {
                this.cachedTarget = newTarget;
                this.analogSignal = analogSignal;
                this.m_6596_();
            } else if (this.getAnalogSignal() != analogSignal) {
                this.analogSignal = analogSignal;
                this.m_6596_();
            }
        }
    }

    public Rocket findRocket() {
        Level level = this.m_58904_();
        AABB workingArea = this.getWorkingArea();
        return level.m_45976_(Rocket.class, workingArea).stream().findFirst().orElse(null);
    }

    @Override
    public boolean isWorkingAreaVisible() {
        return this.workingAreaVisible;
    }

    @Override
    public void setWorkingAreaVisible(boolean visible) {
        if (this.isWorkingAreaVisible() != visible) {
            this.workingAreaVisible = visible;
            this.m_6596_();
        }
    }

    @Override
    public int getWorkingRange() {
        return MachinesConfig.ROCKET_SENSOR_WORKING_RANGE;
    }

    @Override
    public AABB getWorkingArea(double range) {
        return this.getWorkingArea(this.m_58899_(), range);
    }

    public Rocket getCachedTarget() {
        return this.cachedTarget;
    }

    @NotNull
    public IRocketSensingType getSensingType() {
        return this.sensingType;
    }

    public void setSensingType(@Nullable IRocketSensingType sensingType) {
        if (sensingType == null) {
            sensingType = RocketSensingType.DISABLED;
        }
        if (this.getSensingType() != sensingType) {
            this.sensingType = sensingType;
            this.m_6596_();
        }
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        if (this.isInverted() != inverted) {
            this.inverted = inverted;
            this.m_6596_();
        }
    }

    public int getAnalogSignal() {
        return this.analogSignal;
    }
}

