/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.advpump;

import com.yogpc.qp.machines.EnchantmentLevel;
import com.yogpc.qp.utils.MapMulti;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.registries.ForgeRegistries;

class EnchantmentEfficiency {
    private final List<EnchantmentLevel> enchantments;
    final long energyCapacity;
    final int fluidCapacity;
    final long baseEnergy;
    static final List<Integer> baseEnergyMap = List.of(Integer.valueOf(100), Integer.valueOf(80), Integer.valueOf(50), Integer.valueOf(20));
    final int range;

    EnchantmentEfficiency(List<EnchantmentLevel> enchantments) {
        this.enchantments = enchantments;
        int efficiency = EnchantmentEfficiency.getLevel(enchantments, Enchantments.f_44984_);
        int unbreaking = EnchantmentEfficiency.getLevel(enchantments, Enchantments.f_44986_);
        int rangeLevel = Math.max(EnchantmentEfficiency.getLevel(enchantments, Enchantments.f_44987_), 3 * Math.min(EnchantmentEfficiency.getLevel(enchantments, Enchantments.f_44985_), 1));
        this.range = (rangeLevel + 1) * 32;
        this.energyCapacity = (long)((int)Math.pow(2.0, 10 + efficiency)) * 1000000000L;
        this.fluidCapacity = 512000 * (efficiency + 1);
        this.baseEnergy = (long)baseEnergyMap.get(Mth.m_14045_((int)unbreaking, (int)0, (int)3)).intValue() * 1000000000L;
    }

    static int getLevel(List<EnchantmentLevel> enchantments, Enchantment enchantment) {
        return enchantments.stream().filter(e -> enchantment.equals(e.enchantment())).mapToInt(EnchantmentLevel::level).max().orElse(0);
    }

    CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        for (EnchantmentLevel enchantment : this.enchantments) {
            tag.m_128405_(Objects.requireNonNull(enchantment.enchantmentID()).toString(), enchantment.level());
        }
        return tag;
    }

    List<EnchantmentLevel> getEnchantments() {
        return this.enchantments;
    }

    Predicate<BlockPos> rangePredicate(BlockPos center) {
        return p -> {
            int zDiff;
            int xDiff = center.m_123341_() - p.m_123341_();
            return xDiff * xDiff + (zDiff = center.m_123343_() - p.m_123343_()) * zDiff < this.range * this.range;
        };
    }

    int areaSize() {
        return (int)(Math.PI * (double)this.range * (double)this.range);
    }

    static EnchantmentEfficiency fromNbt(CompoundTag tag) {
        List<EnchantmentLevel> enchantmentLevels = tag.m_128431_().stream().mapMulti(MapMulti.getEntry(ForgeRegistries.ENCHANTMENTS, arg_0 -> ((CompoundTag)tag).m_128451_(arg_0))).map(EnchantmentLevel::new).sorted(EnchantmentLevel.QUARRY_ENCHANTMENT_COMPARATOR).toList();
        return new EnchantmentEfficiency(enchantmentLevels);
    }

    static EnchantmentEfficiency fromMap(Map<Enchantment, Integer> enchantmentMap) {
        return new EnchantmentEfficiency(EnchantmentLevel.fromMap(enchantmentMap));
    }
}

