/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.mini_quarry;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.yogpc.qp.QuarryPlus;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraftforge.gametest.ForgeGameTestHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Logger;

interface BlockStatePredicate {
    public boolean test(BlockState var1, BlockGetter var2, BlockPos var3);

    public static BlockStatePredicate air() {
        return Air.INSTANCE;
    }

    public static BlockStatePredicate fluid() {
        return Fluid.INSTANCE;
    }

    public static BlockStatePredicate name(ResourceLocation location) {
        return new Name(location);
    }

    public static BlockStatePredicate tag(ResourceLocation location) {
        return new Tag(location);
    }

    public static BlockStatePredicate predicateString(String blockPredicate) {
        return new VanillaBlockPredicate(blockPredicate);
    }

    public static BlockStatePredicate all() {
        return All.INSTANCE;
    }

    public static BlockStatePredicate fromTag(CompoundTag tag) {
        String type;
        return switch (type = tag.m_128461_("type")) {
            case "all" -> BlockStatePredicate.all();
            case "air" -> BlockStatePredicate.air();
            case "fluid" -> BlockStatePredicate.fluid();
            case "name" -> BlockStatePredicate.name(new ResourceLocation(tag.m_128461_("location")));
            case "tag" -> BlockStatePredicate.tag(new ResourceLocation(tag.m_128461_("location")));
            case "vanilla" -> BlockStatePredicate.predicateString(tag.m_128461_("predicate"));
            default -> throw new IllegalArgumentException("invalid type name: %s, got from %s".formatted(type, tag));
        };
    }

    public CompoundTag toTag();

    public String gameTestName();

    public static final class Air
    implements BlockStatePredicate {
        private static final Air INSTANCE = new Air();

        private Air() {
        }

        @Override
        public boolean test(BlockState state, BlockGetter level, BlockPos pos) {
            return state.m_60795_();
        }

        @Override
        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("type", this.toString().toLowerCase(Locale.ROOT));
            return tag;
        }

        @Override
        public String gameTestName() {
            return "block_state_predicate_air";
        }

        public String toString() {
            return "Air";
        }
    }

    public static final class Fluid
    implements BlockStatePredicate {
        private static final Fluid INSTANCE = new Fluid();

        private Fluid() {
        }

        @Override
        public boolean test(BlockState state, BlockGetter level, BlockPos pos) {
            return !state.m_60819_().m_76178_();
        }

        @Override
        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("type", this.toString().toLowerCase(Locale.ROOT));
            return tag;
        }

        @Override
        public String gameTestName() {
            return "block_state_predicate_fluid";
        }

        public String toString() {
            return "Fluid";
        }
    }

    public record Name(ResourceLocation location) implements BlockStatePredicate
    {
        @Override
        public boolean test(BlockState state, BlockGetter level, BlockPos pos) {
            return this.location.equals((Object)ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()));
        }

        @Override
        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("type", "name");
            tag.m_128359_("location", this.location.toString());
            return tag;
        }

        @Override
        public String gameTestName() {
            return "name_%s_%s".formatted(this.location.m_135827_(), this.location.m_135815_());
        }

        @Override
        public String toString() {
            return "Name{location=" + this.location + "}";
        }
    }

    public static final class Tag
    implements BlockStatePredicate {
        private final TagKey<Block> tag;
        private final ResourceLocation location;

        private Tag(ResourceLocation tagName) {
            this.location = tagName;
            this.tag = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)tagName);
        }

        @Override
        public boolean test(BlockState state, BlockGetter level, BlockPos pos) {
            return state.m_204336_(this.tag);
        }

        @Override
        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("type", "tag");
            tag.m_128359_("location", this.location.toString());
            return tag;
        }

        @Override
        public String gameTestName() {
            return "tag_%s_%s".formatted(this.location.m_135827_(), this.location.m_135815_());
        }

        public String toString() {
            return "Tag{" + this.location + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tag tag = (Tag)o;
            return this.location.equals((Object)tag.location);
        }

        public int hashCode() {
            return this.location.hashCode();
        }
    }

    public static final class VanillaBlockPredicate
    implements BlockStatePredicate {
        private static final Logger LOGGER = QuarryPlus.getLogger(VanillaBlockPredicate.class);
        private final String blockPredicate;

        public VanillaBlockPredicate(String blockPredicate) {
            this.blockPredicate = blockPredicate;
        }

        @Override
        public boolean test(BlockState state, BlockGetter blockGetter, BlockPos pos) {
            if (blockGetter instanceof Level) {
                Level level = (Level)blockGetter;
                try {
                    BlockPredicateArgument.Result argument = BlockPredicateArgument.m_234627_((CommandBuildContext)new CommandBuildContext((RegistryAccess)Optional.ofNullable(level.m_7654_()).map(MinecraftServer::m_206579_).orElseThrow())).parse(new StringReader(this.blockPredicate));
                    return argument.test((Object)new BlockInWorld((LevelReader)level, pos, true));
                }
                catch (CommandSyntaxException e) {
                    if (!ForgeGameTestHooks.isGametestServer()) {
                        LOGGER.warn("Caught error in creating predicate.", (Throwable)e);
                    }
                    return false;
                }
            }
            return false;
        }

        @Override
        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("type", "vanilla");
            tag.m_128359_("predicate", this.blockPredicate);
            return tag;
        }

        @Override
        public String gameTestName() {
            return this.blockPredicate.replace("#", "tag_").replace(":", "_").replace("[", "_").replace("]", "_").replace("=", "_");
        }

        public String toString() {
            return "VanillaBlockPredicate{blockPredicate='" + this.blockPredicate + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VanillaBlockPredicate that = (VanillaBlockPredicate)o;
            return this.blockPredicate.equals(that.blockPredicate);
        }

        public int hashCode() {
            return this.blockPredicate.hashCode();
        }
    }

    public static final class All
    implements BlockStatePredicate {
        private static final All INSTANCE = new All();

        private All() {
        }

        @Override
        public boolean test(BlockState state, BlockGetter level, BlockPos pos) {
            return true;
        }

        @Override
        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("type", this.toString().toLowerCase(Locale.ROOT));
            return tag;
        }

        @Override
        public String gameTestName() {
            return "block_state_predicate_all";
        }

        public String toString() {
            return "All";
        }
    }
}

