/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.advancementplaques;

import com.electronwill.nightconfig.core.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class AdvancementPlaquesConfig {
    public static final ForgeConfigSpec SPEC;
    public static final AdvancementPlaquesConfig INSTANCE;
    public final ForgeConfigSpec.BooleanValue onTop;
    public final ForgeConfigSpec.IntValue distance;
    public final ForgeConfigSpec.BooleanValue hideWaila;
    public final ForgeConfigSpec.BooleanValue tasks;
    public final ForgeConfigSpec.BooleanValue goals;
    public final ForgeConfigSpec.BooleanValue challenges;
    public final ForgeConfigSpec.LongValue titleColor;
    public final ForgeConfigSpec.LongValue nameColor;
    public final ForgeConfigSpec.DoubleValue taskEffectFadeInTime;
    public final ForgeConfigSpec.DoubleValue taskEffectFadeOutTime;
    public final ForgeConfigSpec.DoubleValue taskDuration;
    public final ForgeConfigSpec.DoubleValue goalEffectFadeInTime;
    public final ForgeConfigSpec.DoubleValue goalEffectFadeOutTime;
    public final ForgeConfigSpec.DoubleValue goalDuration;
    public final ForgeConfigSpec.DoubleValue challengeEffectFadeInTime;
    public final ForgeConfigSpec.DoubleValue challengeEffectFadeOutTime;
    public final ForgeConfigSpec.DoubleValue challengeDuration;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> whitelist;
    public final ForgeConfigSpec.BooleanValue muteTasks;
    public final ForgeConfigSpec.BooleanValue muteGoals;
    public final ForgeConfigSpec.BooleanValue muteChallenges;

    public AdvancementPlaquesConfig(ForgeConfigSpec.Builder build) {
        build.comment("Client Configuration").push("client").push("visual_options");
        this.onTop = build.comment(" If plaques should show on the top of the screen.").define("on_top", true);
        this.distance = build.comment(" The distance from the top or bottom of the screen, in pixels.").defineInRange("distance", 16, 8, 256);
        this.hideWaila = build.comment(" Hide waila/hwyla/jade popups while plaques are showing.").define("hide_waila", false);
        this.tasks = build.comment(" If plaques should show for task advancements (normal advancements).").define("tasks", true);
        this.goals = build.comment(" If plaques should show for goal advancements (medium-difficulty advancements).").define("goals", true);
        this.challenges = build.comment(" If plaques should show for challenge advancements (high-difficulty advancements).").define("challenges", true);
        this.titleColor = build.comment(" Text color to use for plaque titles (like \"Advancement made!\"). Can be entered as an 8-digit hex color code 0xAARRGGBB for convenience.").defineInRange("title_color", 4281541120L, 0L, 0xFFFFFFFFL);
        this.nameColor = build.comment(" Text color to use for advancement names on plaques. Can be entered as an 8-digit hex color code 0xAARRGGBB for convenience.").defineInRange("name_color", 0xFFFFFFFFL, 0L, 0xFFFFFFFFL);
        build.pop().push("duration_options");
        this.taskEffectFadeInTime = build.comment(" Duration of the shiny effect fade in for tasks.").defineInRange("task_effect_fadein", 0.5, 0.1, 3.0);
        this.taskEffectFadeOutTime = build.comment(" Duration of the shiny effect fade out for tasks.").defineInRange("task_effect_fadeout", 1.5, 0.1, 3.0);
        this.taskDuration = build.comment(" Duration of the plaques for tasks (minus the effect fade in/out durations).").defineInRange("task_duration", 7.0, 2.0, 10.0);
        this.goalEffectFadeInTime = build.comment(" Duration of the shiny effect fade in for goals.").defineInRange("goal_effect_fadein", 0.5, 0.1, 3.0);
        this.goalEffectFadeOutTime = build.comment(" Duration of the shiny effect fade out for goals.").defineInRange("goal_effect_fadeout", 1.5, 0.1, 3.0);
        this.goalDuration = build.comment(" Duration of the plaques for goals (minus the effect fade in/out durations).").defineInRange("goal_duration", 7.0, 2.0, 10.0);
        this.challengeEffectFadeInTime = build.comment(" Duration of the shiny effect fade in for challenges.").defineInRange("challenge_effect_fadein", 1.25, 0.1, 3.0);
        this.challengeEffectFadeOutTime = build.comment(" Duration of the shiny effect fade out for challenges.").defineInRange("challenge_effect_fadeout", 1.5, 0.1, 3.0);
        this.challengeDuration = build.comment(" Duration of the plaques for challenges (minus the effect fade in/out durations).").defineInRange("challenge_duration", 7.0, 2.0, 10.0);
        build.pop().push("functionality_options");
        this.whitelist = build.comment(" Whitelist of advancements to show plaques for.  Leave empty to display for all.").defineListAllowEmpty(Arrays.asList("whitelist"), () -> new ArrayList(), e -> ResourceLocation.m_135830_((String)((String)e)));
        this.muteTasks = build.comment(" If task sounds should be muted.").define("mute_tasks", false);
        this.muteGoals = build.comment(" If goal sounds should be muted.").define("mute_goals", false);
        this.muteChallenges = build.comment(" If challenge sounds should be muted.").define("mute_challenges", false);
        build.pop().pop();
    }

    static {
        Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(AdvancementPlaquesConfig::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        INSTANCE = (AdvancementPlaquesConfig)specPair.getLeft();
    }
}

