/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import java.util.Iterator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.mixin.CreeperAccessor;
import vazkii.botania.mixin.GoalSelectorAccessor;
import vazkii.botania.mixin.MobAccessor;
import vazkii.botania.mixin.NearestAttackableTargetGoalAccessor;
import vazkii.botania.xplat.XplatAbstractions;

public class TigerseyeBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final int RANGE = 10;
    private static final int RANGE_Y = 4;
    private static final int COST = 70;
    private static final int SUCCESS_EVENT = 0;

    public TigerseyeBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.TIGERSEYE, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.m_58904_().f_46443_) {
            return;
        }
        for (Creeper entity : this.m_58904_().m_45976_(Creeper.class, new AABB(this.getEffectivePos().m_7918_(-10, -4, -10), this.getEffectivePos().m_7918_(11, 5, 11)))) {
            ((CreeperAccessor)entity).setCurrentFuseTime(2);
            entity.m_6710_(null);
            if (this.getMana() < 70 || !TigerseyeBlockEntity.pacifyCreeper(entity)) continue;
            XplatAbstractions.INSTANCE.tigersEyeComponent(entity).setPacified();
            entity.m_5496_(BotaniaSounds.tigerseyePacify, 1.0f, (this.f_58857_.f_46441_.m_188501_() - this.f_58857_.f_46441_.m_188501_()) * 0.2f + 1.0f);
            this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 0, entity.m_19879_());
            this.addMana(-70);
            this.sync();
        }
    }

    public static void pacifyAfterLoad(Entity entity, ServerLevel level) {
        Creeper creeper;
        if (entity instanceof Creeper && XplatAbstractions.INSTANCE.tigersEyeComponent(creeper = (Creeper)entity).isPacified()) {
            TigerseyeBlockEntity.pacifyCreeper(creeper);
        }
    }

    private static boolean pacifyCreeper(Creeper creeper) {
        boolean did = false;
        GoalSelector goalSelector = ((MobAccessor)creeper).getGoalSelector();
        Set<WrappedGoal> goals = ((GoalSelectorAccessor)goalSelector).getAvailableGoals();
        for (WrappedGoal goal : goals) {
            Goal wrapped = goal.m_26015_();
            if (!(wrapped instanceof CreeperAvoidPlayerGoal)) continue;
            CreeperAvoidPlayerGoal playerGoal = (CreeperAvoidPlayerGoal)wrapped;
            if (playerGoal.enabled) continue;
            playerGoal.enable();
            did = true;
            break;
        }
        GoalSelector targetSelector = ((MobAccessor)creeper).getTargetSelector();
        Iterator<WrappedGoal> iterator = ((GoalSelectorAccessor)targetSelector).getAvailableGoals().iterator();
        while (iterator.hasNext()) {
            NearestAttackableTargetGoalAccessor targetGoal;
            WrappedGoal pg = iterator.next();
            Goal goal = pg.m_26015_();
            if (!(goal instanceof NearestAttackableTargetGoalAccessor) || (targetGoal = (NearestAttackableTargetGoalAccessor)goal).getTargetClass() != Player.class) continue;
            iterator.remove();
            did = true;
        }
        return did;
    }

    public boolean m_7531_(int id, int payload) {
        if (id == 0) {
            Entity e;
            if (this.f_58857_.f_46443_ && (e = this.f_58857_.m_6815_(payload)) != null) {
                float r = (float)(this.getColor() >> 16 & 0xFF) / 255.0f;
                float g = (float)(this.getColor() >> 8 & 0xFF) / 255.0f;
                float b = (float)(this.getColor() & 0xFF) / 255.0f;
                SparkleParticleData data = SparkleParticleData.sparkle(this.f_58857_.f_46441_.m_188501_(), r, g, b, 10);
                for (int i = 0; i < 50; ++i) {
                    double x = e.m_20185_() + this.f_58857_.f_46441_.m_188500_() - 0.5;
                    double y = e.m_20186_() + (double)e.m_20206_() * this.f_58857_.f_46441_.m_188500_();
                    double z = e.m_20189_() + this.f_58857_.f_46441_.m_188500_() - 0.5;
                    this.f_58857_.m_7106_((ParticleOptions)data, x, y, z, 0.0, 0.0, 0.0);
                }
            }
            return true;
        }
        return super.m_7531_(id, payload);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 10);
    }

    @Override
    public int getColor() {
        return 11642392;
    }

    @Override
    public int getMaxMana() {
        return 1000;
    }

    public static class CreeperAvoidPlayerGoal
    extends AvoidEntityGoal<Player> {
        private boolean enabled = false;

        public CreeperAvoidPlayerGoal(Creeper mob) {
            this(mob, 6.0f, 1.0, 1.2);
        }

        private CreeperAvoidPlayerGoal(Creeper mob, float maxDist, double walkSpeedModifier, double sprintSpeedModifier) {
            super((PathfinderMob)mob, Player.class, maxDist, walkSpeedModifier, sprintSpeedModifier);
        }

        public void enable() {
            this.enabled = true;
        }

        public boolean m_8036_() {
            return this.enabled && super.m_8036_();
        }
    }
}

